/*     */ package org.jboss.jms.server.container;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.JMSSecurityException;
/*     */ import javax.jms.Message;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.jms.message.JBossMessage;
/*     */ import org.jboss.jms.server.SecurityStore;
/*     */ import org.jboss.jms.server.endpoint.ServerConnectionEndpoint;
/*     */ import org.jboss.jms.server.endpoint.ServerConsumerEndpoint;
/*     */ import org.jboss.jms.server.endpoint.ServerSessionEndpoint;
/*     */ import org.jboss.jms.server.endpoint.advised.ConnectionAdvised;
/*     */ import org.jboss.jms.server.endpoint.advised.ConsumerAdvised;
/*     */ import org.jboss.jms.server.endpoint.advised.SessionAdvised;
/*     */ import org.jboss.jms.server.security.CheckType;
/*     */ import org.jboss.jms.server.security.SecurityMetadata;
/*     */ import org.jboss.jms.tx.ClientTransaction;
/*     */ import org.jboss.jms.tx.ClientTransaction.SessionTxState;
/*     */ import org.jboss.jms.tx.TransactionRequest;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class SecurityAspect
/*     */ {
/*  71 */   private static final Logger log = Logger.getLogger(SecurityAspect.class);
/*     */ 
/*  77 */   private boolean trace = log.isTraceEnabled();
/*     */   private Set readCache;
/*     */   private Set writeCache;
/*     */   private Set createCache;
/*     */   private static final long INVALIDATION_INTERVAL = 15000L;
/*     */   private long lastCheck;
/*     */ 
/*     */   public SecurityAspect()
/*     */   {
/*  95 */     this.readCache = new HashSet();
/*     */ 
/*  97 */     this.writeCache = new HashSet();
/*     */ 
/*  99 */     this.createCache = new HashSet();
/*     */   }
/*     */ 
/*     */   public Object handleCreateConsumerDelegate(Invocation invocation) throws Throwable
/*     */   {
/* 104 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 107 */     Destination dest = (Destination)mi.getArguments()[0];
/*     */ 
/* 109 */     SessionAdvised del = (SessionAdvised)invocation.getTargetObject();
/* 110 */     ServerSessionEndpoint sess = (ServerSessionEndpoint)del.getEndpoint();
/*     */ 
/* 112 */     check(dest, CheckType.READ, sess.getConnectionEndpoint());
/*     */ 
/* 116 */     String subscriptionName = (String)mi.getArguments()[3];
/* 117 */     if (subscriptionName != null)
/*     */     {
/* 120 */       check(dest, CheckType.CREATE, sess.getConnectionEndpoint());
/*     */     }
/*     */ 
/* 123 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object handleCreateBrowserDelegate(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 130 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 132 */     Destination dest = (Destination)mi.getArguments()[0];
/*     */ 
/* 134 */     SessionAdvised del = (SessionAdvised)invocation.getTargetObject();
/* 135 */     ServerSessionEndpoint sess = (ServerSessionEndpoint)del.getEndpoint();
/*     */ 
/* 137 */     check(dest, CheckType.READ, sess.getConnectionEndpoint());
/*     */ 
/* 139 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object handleSend(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 146 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 148 */     Message m = (Message)mi.getArguments()[0];
/* 149 */     Destination dest = m.getJMSDestination();
/*     */ 
/* 151 */     SessionAdvised del = (SessionAdvised)invocation.getTargetObject();
/* 152 */     ServerSessionEndpoint se = (ServerSessionEndpoint)del.getEndpoint();
/* 153 */     ServerConnectionEndpoint ce = se.getConnectionEndpoint();
/*     */ 
/* 155 */     check(dest, CheckType.WRITE, ce);
/*     */ 
/* 157 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object handleSendTransaction(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 164 */     ConnectionAdvised del = (ConnectionAdvised)invocation.getTargetObject();
/* 165 */     ServerConnectionEndpoint ce = (ServerConnectionEndpoint)del.getEndpoint();
/*     */ 
/* 167 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 169 */     TransactionRequest t = (TransactionRequest)mi.getArguments()[0];
/*     */ 
/* 171 */     ClientTransaction txState = t.getState();
/*     */     Iterator iterDestinations;
/* 173 */     if (txState != null)
/*     */     {
/* 176 */       HashSet destinations = new HashSet();
/*     */ 
/* 178 */       for (Iterator i = txState.getSessionStates().iterator(); i.hasNext(); )
/*     */       {
/* 180 */         ClientTransaction.SessionTxState sessionState = (ClientTransaction.SessionTxState)i.next();
/* 181 */         for (j = sessionState.getMsgs().iterator(); j.hasNext(); )
/*     */         {
/* 183 */           JBossMessage message = (JBossMessage)j.next();
/* 184 */           destinations.add(message.getJMSDestination());
/*     */         }
/*     */       }
/*     */       Iterator j;
/* 187 */       for (iterDestinations = destinations.iterator(); iterDestinations.hasNext(); )
/*     */       {
/* 189 */         Destination destination = (Destination)iterDestinations.next();
/* 190 */         check(destination, CheckType.WRITE, ce);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 195 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   protected void checkConsumerAccess(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 202 */     ConsumerAdvised del = (ConsumerAdvised)invocation.getTargetObject();
/* 203 */     ServerConsumerEndpoint cons = (ServerConsumerEndpoint)del.getEndpoint();
/* 204 */     ServerConnectionEndpoint conn = cons.getSessionEndpoint().getConnectionEndpoint();
/* 205 */     JBossDestination dest = cons.getDestination();
/*     */ 
/* 207 */     check(dest, CheckType.READ, conn);
/*     */   }
/*     */ 
/*     */   private boolean checkCached(Destination dest, CheckType checkType)
/*     */   {
/* 218 */     long now = System.currentTimeMillis();
/*     */ 
/* 220 */     boolean granted = false;
/*     */ 
/* 222 */     if (now - this.lastCheck > 15000L)
/*     */     {
/* 224 */       this.readCache.clear();
/*     */ 
/* 226 */       this.writeCache.clear();
/*     */ 
/* 228 */       this.createCache.clear();
/*     */     }
/*     */     else
/*     */     {
/* 232 */       switch (checkType.type)
/*     */       {
/*     */       case 0:
/* 236 */         granted = this.readCache.contains(dest);
/* 237 */         break;
/*     */       case 1:
/* 241 */         granted = this.writeCache.contains(dest);
/* 242 */         break;
/*     */       case 2:
/* 246 */         granted = this.createCache.contains(dest);
/* 247 */         break;
/*     */       default:
/* 251 */         throw new IllegalArgumentException("Invalid checkType:" + checkType);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 256 */     this.lastCheck = now;
/*     */ 
/* 258 */     return granted;
/*     */   }
/*     */ 
/*     */   private void check(Destination dest, CheckType checkType, ServerConnectionEndpoint conn)
/*     */     throws JMSSecurityException
/*     */   {
/* 264 */     JBossDestination jbd = (JBossDestination)dest;
/*     */ 
/* 266 */     if (jbd.isTemporary())
/*     */     {
/* 268 */       if (this.trace) log.trace("skipping permission check on temporary destination " + dest);
/* 269 */       return;
/*     */     }
/*     */ 
/* 272 */     if (this.trace) log.trace("checking access permissions to " + dest);
/*     */ 
/* 274 */     if (checkCached(dest, checkType))
/*     */     {
/* 277 */       return;
/*     */     }
/*     */ 
/* 280 */     boolean isQueue = jbd.isQueue();
/* 281 */     String name = jbd.getName();
/*     */ 
/* 283 */     SecurityStore sm = conn.getSecurityManager();
/* 284 */     SecurityMetadata securityMetadata = sm.getSecurityMetadata(isQueue, name);
/*     */ 
/* 286 */     if (securityMetadata == null)
/*     */     {
/* 288 */       throw new JMSSecurityException("No security configuration avaliable for " + name);
/*     */     }
/*     */ 
/* 296 */     sm.authenticate(conn.getUsername(), conn.getPassword());
/*     */ 
/* 299 */     Set principals = checkType == CheckType.WRITE ? securityMetadata.getWritePrincipals() : checkType == CheckType.READ ? securityMetadata.getReadPrincipals() : securityMetadata.getCreatePrincipals();
/*     */     try
/*     */     {
/* 304 */       if (!sm.authorize(conn.getUsername(), principals, checkType))
/*     */       {
/* 306 */         String msg = "User: " + conn.getUsername() + " is not authorized to " + (checkType == CheckType.WRITE ? "write to" : checkType == CheckType.READ ? "read from" : "create durable sub on") + " destination " + name;
/*     */ 
/* 312 */         throw new JMSSecurityException(msg);
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 318 */       SecurityActions.popSubjectContext();
/*     */     }
/*     */ 
/* 323 */     switch (checkType.type)
/*     */     {
/*     */     case 0:
/* 327 */       this.readCache.add(dest);
/* 328 */       break;
/*     */     case 1:
/* 332 */       this.writeCache.add(dest);
/* 333 */       break;
/*     */     case 2:
/* 337 */       this.createCache.add(dest);
/* 338 */       break;
/*     */     default:
/* 342 */       throw new IllegalArgumentException("Invalid checkType:" + checkType);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.container.SecurityAspect
 * JD-Core Version:    0.6.0
 */