/*     */ package org.jboss.jms.server.connectormanager;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.jms.server.ConnectorManager;
/*     */ 
/*     */ public class SimpleConnectorManager
/*     */   implements ConnectorManager
/*     */ {
/*     */   protected Map connectors;
/*     */ 
/*     */   public SimpleConnectorManager()
/*     */   {
/*  51 */     this.connectors = new HashMap();
/*     */   }
/*     */ 
/*     */   public synchronized void unregisterConnector(String name) throws Exception
/*     */   {
/*  56 */     Integer refCount = (Integer)this.connectors.get(name);
/*     */ 
/*  58 */     if (refCount == null)
/*     */     {
/*  60 */       throw new IllegalArgumentException("Cannot find connector " + name + " to remove");
/*     */     }
/*     */ 
/*  63 */     if (refCount.intValue() == 1)
/*     */     {
/*  65 */       this.connectors.remove(name);
/*     */     }
/*     */     else
/*     */     {
/*  69 */       this.connectors.put(name, new Integer(refCount.intValue() - 1));
/*     */     }
/*     */   }
/*     */ 
/*     */   public int registerConnector(String name) throws Exception
/*     */   {
/*  75 */     Integer refCount = (Integer)this.connectors.get(name);
/*     */ 
/*  77 */     if (refCount != null)
/*     */     {
/*  81 */       refCount = new Integer(refCount.intValue() + 1);
/*     */     }
/*     */     else
/*     */     {
/*  85 */       refCount = new Integer(1);
/*     */     }
/*     */ 
/*  88 */     this.connectors.put(name, refCount);
/*     */ 
/*  90 */     return refCount.intValue();
/*     */   }
/*     */ 
/*     */   public synchronized boolean containsConnector(String connectorName)
/*     */   {
/*  95 */     return this.connectors.containsKey(connectorName);
/*     */   }
/*     */ 
/*     */   public synchronized int getCount(String connectorName)
/*     */   {
/* 100 */     Integer i = (Integer)this.connectors.get(connectorName);
/*     */ 
/* 102 */     if (i == null)
/*     */     {
/* 104 */       return 0;
/*     */     }
/*     */ 
/* 108 */     return i.intValue();
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.connectormanager.SimpleConnectorManager
 * JD-Core Version:    0.6.0
 */