/*     */ package org.jboss.jms.server.connectionfactory;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Comparator;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.jms.client.JBossConnectionFactory;
/*     */ import org.jboss.jms.client.delegate.ClientClusteredConnectionFactoryDelegate;
/*     */ import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
/*     */ import org.jboss.jms.client.plugin.LoadBalancingFactory;
/*     */ import org.jboss.jms.client.plugin.LoadBalancingPolicy;
/*     */ import org.jboss.jms.client.plugin.NoLoadBalancingLoadBalancingFactory;
/*     */ import org.jboss.jms.delegate.ConnectionFactoryDelegate;
/*     */ import org.jboss.jms.server.ConnectionFactoryManager;
/*     */ import org.jboss.jms.server.ServerPeer;
/*     */ import org.jboss.jms.server.endpoint.ServerConnectionFactoryEndpoint;
/*     */ import org.jboss.jms.server.endpoint.advised.ConnectionFactoryAdvised;
/*     */ import org.jboss.jms.wireformat.Dispatcher;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.ClusterNotification;
/*     */ import org.jboss.messaging.core.contract.ClusterNotificationListener;
/*     */ import org.jboss.messaging.core.contract.PostOffice;
/*     */ import org.jboss.messaging.core.contract.Replicator;
/*     */ import org.jboss.messaging.util.JNDIUtil;
/*     */ import org.jboss.messaging.util.Version;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class ConnectionFactoryJNDIMapper
/*     */   implements ConnectionFactoryManager, ClusterNotificationListener
/*     */ {
/*  71 */   private static final Logger log = Logger.getLogger(ConnectionFactoryJNDIMapper.class);
/*     */ 
/*  75 */   private static boolean trace = log.isTraceEnabled();
/*     */   protected Context initialContext;
/*     */   protected ServerPeer serverPeer;
/*     */   private Map endpoints;
/*     */   private Map delegates;
/*     */   private Replicator replicator;
/*     */ 
/*     */   public ConnectionFactoryJNDIMapper(ServerPeer serverPeer)
/*     */     throws Exception
/*     */   {
/*  94 */     this.serverPeer = serverPeer;
/*  95 */     this.endpoints = new HashMap();
/*  96 */     this.delegates = new HashMap();
/*     */   }
/*     */ 
/*     */   public synchronized void registerConnectionFactory(String uniqueName, String clientID, JNDIBindings jndiBindings, String locatorURI, boolean clientPing, int prefetchSize, boolean slowConsumers, int defaultTempQueueFullSize, int defaultTempQueuePageSize, int defaultTempQueueDownCacheSize, int dupsOKBatchSize, boolean supportsFailover, boolean supportsLoadBalancing, LoadBalancingFactory loadBalancingFactory, boolean strictTck)
/*     */     throws Exception
/*     */   {
/* 121 */     log.debug(this + " registering connection factory '" + uniqueName + "', bindings: " + jndiBindings);
/*     */ 
/* 124 */     if (this.delegates.containsKey(uniqueName))
/*     */     {
/* 126 */       throw new IllegalArgumentException("There's already a connection factory registered with name " + uniqueName);
/*     */     }
/*     */ 
/* 131 */     String id = uniqueName;
/*     */ 
/* 133 */     Version version = this.serverPeer.getVersion();
/*     */ 
/* 135 */     ServerConnectionFactoryEndpoint endpoint = new ServerConnectionFactoryEndpoint(uniqueName, id, this.serverPeer, clientID, jndiBindings, prefetchSize, slowConsumers, defaultTempQueueFullSize, defaultTempQueuePageSize, defaultTempQueueDownCacheSize, dupsOKBatchSize, supportsFailover);
/*     */ 
/* 144 */     this.endpoints.put(uniqueName, endpoint);
/*     */ 
/* 146 */     ConnectionFactoryDelegate delegate = null;
/*     */ 
/* 148 */     if ((supportsFailover) || (supportsLoadBalancing))
/*     */     {
/* 150 */       setupReplicator();
/*     */     }
/*     */ 
/* 153 */     if ((supportsFailover) && (this.replicator == null))
/*     */     {
/* 155 */       log.warn("supportsFailover attribute is true on connection factory: " + uniqueName + " but post office is non clustered. " + "So connection factory will *not* support failover");
/*     */     }
/*     */ 
/* 159 */     if ((supportsLoadBalancing) && (this.replicator == null))
/*     */     {
/* 161 */       log.warn("supportsLoadBalancing attribute is true on connection factory: " + uniqueName + " but post office is non clustered. " + "So connection factory will *not* support load balancing");
/*     */     }
/*     */ 
/* 165 */     boolean creatingClustered = ((supportsFailover) || (supportsLoadBalancing)) && (this.replicator != null);
/*     */ 
/* 168 */     boolean useStrict = (this.serverPeer.isStrictTck()) || (strictTck);
/*     */ 
/* 170 */     ClientConnectionFactoryDelegate localDelegate = new ClientConnectionFactoryDelegate(uniqueName, id, this.serverPeer.getServerPeerID(), locatorURI, version, clientPing, useStrict);
/*     */ 
/* 174 */     log.debug(this + " created local delegate " + localDelegate);
/*     */ 
/* 183 */     if (creatingClustered)
/*     */     {
/* 187 */       if (!supportsLoadBalancing)
/*     */       {
/* 189 */         loadBalancingFactory = new NoLoadBalancingLoadBalancingFactory(localDelegate);
/*     */       }
/*     */ 
/* 192 */       Map localDelegates = this.replicator.get("CF_" + uniqueName);
/* 193 */       boolean ok = sanityCheckFactories(localDelegates.values());
/* 194 */       if (!ok)
/*     */       {
/* 196 */         String msg = "The remoting locator configuration for a particular clustered connection factory must be the same on each node in the cluster. We have detected that the configuration differs on this node. Please correct and redeploy the connection factory";
/*     */ 
/* 199 */         log.error("The remoting locator configuration for a particular clustered connection factory must be the same on each node in the cluster. We have detected that the configuration differs on this node. Please correct and redeploy the connection factory");
/* 200 */         throw new IllegalArgumentException("The remoting locator configuration for a particular clustered connection factory must be the same on each node in the cluster. We have detected that the configuration differs on this node. Please correct and redeploy the connection factory");
/*     */       }
/* 202 */       delegate = createClusteredDelegate(uniqueName, localDelegates.values(), loadBalancingFactory, endpoint, supportsFailover);
/*     */ 
/* 204 */       log.debug(this + " created clustered delegate " + delegate);
/*     */     }
/*     */     else
/*     */     {
/* 208 */       delegate = localDelegate;
/*     */     }
/*     */ 
/* 211 */     log.trace(this + " adding delegates factory " + uniqueName + " pointing to " + delegate);
/*     */ 
/* 213 */     this.delegates.put(uniqueName, delegate);
/*     */ 
/* 216 */     rebindConnectionFactory(this.initialContext, jndiBindings, delegate);
/*     */     ConnectionFactoryAdvised advised;
/* 222 */     synchronized (AspectManager.instance())
/*     */     {
/* 224 */       advised = new ConnectionFactoryAdvised(endpoint);
/*     */     }
/*     */ 
/* 229 */     Dispatcher.instance.registerTarget(id, advised);
/*     */ 
/* 233 */     if (this.replicator != null) this.replicator.put("CF_" + uniqueName, localDelegate);
/*     */   }
/*     */ 
/*     */   public synchronized void unregisterConnectionFactory(String uniqueName, boolean supportsFailover, boolean supportsLoadBalancing)
/*     */     throws Exception
/*     */   {
/* 239 */     log.trace("ConnectionFactory " + uniqueName + " being unregistered");
/* 240 */     ServerConnectionFactoryEndpoint endpoint = (ServerConnectionFactoryEndpoint)this.endpoints.remove(uniqueName);
/*     */ 
/* 243 */     if (endpoint == null)
/*     */     {
/* 245 */       throw new IllegalArgumentException("Cannot find endpoint with name " + uniqueName);
/*     */     }
/*     */ 
/* 248 */     JNDIBindings jndiBindings = endpoint.getJNDIBindings();
/*     */     Iterator i;
/* 250 */     if (jndiBindings != null)
/*     */     {
/* 252 */       List jndiNames = jndiBindings.getNames();
/* 253 */       for (i = jndiNames.iterator(); i.hasNext(); )
/*     */       {
/* 255 */         String jndiName = (String)i.next();
/* 256 */         this.initialContext.unbind(jndiName);
/* 257 */         log.debug(jndiName + " unregistered");
/*     */       }
/*     */     }
/*     */ 
/* 261 */     if (trace) log.trace("Removing delegate from delegates list with key=" + uniqueName + " at serverPeerID=" + this.serverPeer.getServerPeerID());
/*     */ 
/* 263 */     ConnectionFactoryDelegate delegate = (ConnectionFactoryDelegate)this.delegates.remove(uniqueName);
/*     */ 
/* 265 */     if (delegate == null)
/*     */     {
/* 267 */       throw new IllegalArgumentException("Cannot find factory with name " + uniqueName);
/*     */     }
/*     */ 
/* 270 */     if (this.replicator != null)
/*     */     {
/* 272 */       if (!this.replicator.remove("CF_" + uniqueName))
/*     */       {
/* 274 */         throw new IllegalStateException("Cannot find replicant to remove: CF_" + uniqueName);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 279 */     Dispatcher.instance.unregisterTarget(endpoint.getID(), endpoint);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 286 */     this.initialContext = new InitialContext();
/*     */ 
/* 288 */     log.debug("started");
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 293 */     this.initialContext.close();
/*     */ 
/* 295 */     log.debug("stopped");
/*     */   }
/*     */ 
/*     */   public synchronized void notify(ClusterNotification notification)
/*     */   {
/* 302 */     log.debug(this + " received notification from node " + notification.nodeID);
/*     */     try
/*     */     {
/*     */       Map failoverMap;
/*     */       Iterator i;
/* 306 */       if ((notification.type == 4) || (notification.type == 5))
/*     */       {
/* 311 */         failoverMap = this.serverPeer.getPostOfficeInstance().getFailoverMap();
/*     */ 
/* 315 */         for (i = this.endpoints.entrySet().iterator(); i.hasNext(); )
/*     */         {
/* 317 */           Map.Entry entry = (Map.Entry)i.next();
/* 318 */           String uniqueName = (String)entry.getKey();
/*     */ 
/* 320 */           Object del = this.delegates.get(uniqueName);
/*     */ 
/* 322 */           if (del == null)
/*     */           {
/* 324 */             throw new IllegalStateException("Cannot find connection factory with name " + uniqueName);
/*     */           }
/*     */ 
/* 328 */           if ((del instanceof ClientClusteredConnectionFactoryDelegate))
/*     */           {
/* 330 */             ((ClientClusteredConnectionFactoryDelegate)del).setFailoverMap(failoverMap);
/*     */           }
/*     */         }
/*     */       }
/* 334 */       else if (((notification.type == 6) || (notification.type == 7)) && ((notification.data instanceof String)) && (((String)notification.data).startsWith("CF_")))
/*     */       {
/* 338 */         log.debug("Updating CF information for " + notification.data);
/*     */ 
/* 345 */         String key = (String)notification.data;
/*     */ 
/* 347 */         String uniqueName = key.substring("CF_".length());
/*     */ 
/* 349 */         log.debug(this + " received '" + uniqueName + "' connection factory deploy / undeploy");
/*     */ 
/* 351 */         ConnectionFactoryDelegate cfd = (ConnectionFactoryDelegate)this.delegates.get(uniqueName);
/*     */ 
/* 353 */         if (cfd != null)
/*     */         {
/* 360 */           if (!(cfd instanceof ClientConnectionFactoryDelegate))
/*     */           {
/* 369 */             ClientClusteredConnectionFactoryDelegate del = (ClientClusteredConnectionFactoryDelegate)cfd;
/*     */ 
/* 371 */             Map updatedReplicantMap = this.replicator.get(key);
/*     */ 
/* 373 */             List newDels = sortDelegatesOnServerID(updatedReplicantMap.values());
/*     */ 
/* 375 */             ClientConnectionFactoryDelegate[] delArr = (ClientConnectionFactoryDelegate[])(ClientConnectionFactoryDelegate[])newDels.toArray(new ClientConnectionFactoryDelegate[newDels.size()]);
/*     */ 
/* 379 */             Map failoverMap = this.serverPeer.getPostOfficeInstance().getFailoverMap();
/*     */ 
/* 381 */             del.setDelegates(delArr);
/* 382 */             del.setFailoverMap(failoverMap);
/*     */ 
/* 384 */             ServerConnectionFactoryEndpoint endpoint = (ServerConnectionFactoryEndpoint)this.endpoints.get(uniqueName);
/*     */ 
/* 387 */             if (endpoint == null)
/*     */             {
/* 389 */               throw new IllegalStateException("Cannot find endpoint with name " + uniqueName);
/*     */             }
/*     */ 
/* 392 */             rebindConnectionFactory(this.initialContext, endpoint.getJNDIBindings(), del);
/*     */ 
/* 394 */             endpoint.updateClusteredClients(delArr, failoverMap);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 401 */       log.error("Failed to rebind connection factory", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void injectReplicator(Replicator replicator)
/*     */   {
/* 409 */     this.replicator = replicator;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 414 */     return "Server[" + this.serverPeer.getServerPeerID() + "].ConnFactoryJNDIMapper";
/*     */   }
/*     */ 
/*     */   private void setupReplicator()
/*     */     throws Exception
/*     */   {
/* 425 */     this.serverPeer.getPostOfficeInstance();
/*     */   }
/*     */ 
/*     */   private ClientClusteredConnectionFactoryDelegate createClusteredDelegate(String uniqueName, Collection localDelegates, LoadBalancingFactory loadBalancingFactory, ServerConnectionFactoryEndpoint endpoint, boolean supportsFailover)
/*     */     throws Exception
/*     */   {
/* 436 */     log.trace(this + " creating a clustered ConnectionFactoryDelegate based on " + localDelegates);
/*     */ 
/* 439 */     List sortedLocalDelegates = sortDelegatesOnServerID(localDelegates);
/*     */ 
/* 441 */     ClientConnectionFactoryDelegate[] delegates = (ClientConnectionFactoryDelegate[])(ClientConnectionFactoryDelegate[])sortedLocalDelegates.toArray(new ClientConnectionFactoryDelegate[sortedLocalDelegates.size()]);
/*     */ 
/* 445 */     Map failoverMap = this.serverPeer.getPostOfficeInstance().getFailoverMap();
/*     */ 
/* 447 */     LoadBalancingPolicy lbp = loadBalancingFactory.createLoadBalancingPolicy(delegates);
/*     */ 
/* 449 */     endpoint.updateTopology(delegates, failoverMap);
/*     */ 
/* 451 */     return new ClientClusteredConnectionFactoryDelegate(uniqueName, delegates, failoverMap, lbp, supportsFailover);
/*     */   }
/*     */ 
/*     */   private void rebindConnectionFactory(Context ic, JNDIBindings jndiBindings, ConnectionFactoryDelegate delegate)
/*     */     throws NamingException
/*     */   {
/* 458 */     JBossConnectionFactory cf = new JBossConnectionFactory(delegate);
/*     */     Iterator i;
/* 460 */     if (jndiBindings != null)
/*     */     {
/* 462 */       List jndiNames = jndiBindings.getNames();
/* 463 */       for (i = jndiNames.iterator(); i.hasNext(); )
/*     */       {
/* 465 */         String jndiName = (String)i.next();
/* 466 */         log.debug(this + " rebinding " + cf + " as " + jndiName);
/* 467 */         JNDIUtil.rebind(ic, jndiName, cf);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private List sortDelegatesOnServerID(Collection delegates)
/*     */   {
/* 474 */     List localDels = new ArrayList(delegates);
/*     */ 
/* 476 */     Collections.sort(localDels, new Comparator()
/*     */     {
/*     */       public int compare(Object obj1, Object obj2)
/*     */       {
/* 481 */         ClientConnectionFactoryDelegate del1 = (ClientConnectionFactoryDelegate)obj1;
/* 482 */         ClientConnectionFactoryDelegate del2 = (ClientConnectionFactoryDelegate)obj2;
/* 483 */         return del1.getServerID() - del2.getServerID();
/*     */       }
/*     */     });
/* 487 */     return localDels;
/*     */   }
/*     */ 
/*     */   private boolean sanityCheckFactories(Collection factories) throws Exception
/*     */   {
/* 492 */     Iterator iter = factories.iterator();
/* 493 */     InvokerLocator prevLocator = null;
/* 494 */     while (iter.hasNext())
/*     */     {
/* 496 */       ClientConnectionFactoryDelegate fact = (ClientConnectionFactoryDelegate)iter.next();
/*     */ 
/* 499 */       String locatorString = fact.getServerLocatorURI();
/*     */ 
/* 501 */       InvokerLocator locator = new InvokerLocator(locatorString);
/*     */ 
/* 503 */       if (prevLocator != null)
/*     */       {
/* 507 */         if (!locator.getProtocol().equals(prevLocator.getProtocol()))
/*     */         {
/* 509 */           log.error("Protocol to be used for connection factory does not match protocol specified at other nodes in the cluster " + locator.getProtocol() + ", " + prevLocator.getProtocol());
/*     */ 
/* 511 */           return false;
/*     */         }
/* 513 */         Map prevParams = prevLocator.getParameters();
/* 514 */         Map params = locator.getParameters();
/* 515 */         if (prevParams.size() != params.size())
/*     */         {
/* 517 */           log.error("Locator for connection factory has different number of parameters");
/* 518 */           return false;
/*     */         }
/* 520 */         Iterator iter2 = prevParams.entrySet().iterator();
/* 521 */         while (iter2.hasNext())
/*     */         {
/* 523 */           Map.Entry entry = (Map.Entry)iter2.next();
/*     */ 
/* 525 */           String prevKey = (String)entry.getKey();
/* 526 */           String prevValue = (String)entry.getValue();
/* 527 */           String value = (String)params.get(prevKey);
/* 528 */           if ((value == null) || (!prevValue.equals(value)))
/*     */           {
/* 530 */             log.error("Locator param does not exist or has wrong value");
/* 531 */             return false;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 536 */       prevLocator = locator;
/*     */     }
/* 538 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.connectionfactory.ConnectionFactoryJNDIMapper
 * JD-Core Version:    0.6.0
 */