/*     */ package org.jboss.jms.server.connectionfactory;
/*     */ 
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.jms.client.plugin.LoadBalancingFactory;
/*     */ import org.jboss.jms.server.ConnectionFactoryManager;
/*     */ import org.jboss.jms.server.ConnectionManager;
/*     */ import org.jboss.jms.server.ConnectorManager;
/*     */ import org.jboss.jms.server.ServerPeer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.util.ExceptionUtil;
/*     */ import org.jboss.messaging.util.JMXAccessor;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class ConnectionFactory extends ServiceMBeanSupport
/*     */ {
/*     */   private String clientID;
/*     */   private JNDIBindings jndiBindings;
/*  49 */   private int prefetchSize = 150;
/*     */   private boolean slowConsumers;
/*     */   private boolean supportsFailover;
/*     */   private boolean supportsLoadBalancing;
/*     */   private LoadBalancingFactory loadBalancingFactory;
/*  59 */   private int defaultTempQueueFullSize = 200000;
/*     */ 
/*  61 */   private int defaultTempQueuePageSize = 2000;
/*     */ 
/*  63 */   private int defaultTempQueueDownCacheSize = 2000;
/*     */ 
/*  65 */   private int dupsOKBatchSize = 1000;
/*     */   private ObjectName serverPeerObjectName;
/*     */   private ConnectionFactoryManager connectionFactoryManager;
/*     */   private ConnectorManager connectorManager;
/*     */   private ConnectionManager connectionManager;
/*     */   private ObjectName connectorObjectName;
/*     */   private boolean started;
/*     */   private boolean strictTck;
/*     */   private boolean disableRemotingChecks;
/*     */ 
/*     */   public ConnectionFactory()
/*     */   {
/*  87 */     this(null);
/*     */   }
/*     */ 
/*     */   public ConnectionFactory(String clientID)
/*     */   {
/*  92 */     this.clientID = clientID;
/*     */ 
/*  95 */     this.loadBalancingFactory = LoadBalancingFactory.getDefaultFactory();
/*     */   }
/*     */ 
/*     */   public synchronized void startService()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 104 */       this.log.debug(this + " starting");
/*     */ 
/* 106 */       this.started = true;
/*     */ 
/* 108 */       if (this.connectorObjectName == null)
/*     */       {
/* 110 */         throw new IllegalArgumentException("A Connector must be specified for each Connection Factory");
/*     */       }
/*     */ 
/* 114 */       if (this.serverPeerObjectName == null)
/*     */       {
/* 116 */         throw new IllegalArgumentException("ServerPeer must be specified for each Connection Factory");
/*     */       }
/*     */ 
/* 120 */       String locatorURI = (String)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.connectorObjectName, "InvokerLocator");
/*     */ 
/* 122 */       ServerPeer serverPeer = (ServerPeer)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.serverPeerObjectName, "Instance");
/*     */ 
/* 124 */       if (!serverPeer.isSupportsFailover())
/*     */       {
/* 126 */         this.supportsFailover = false;
/*     */       }
/*     */ 
/* 129 */       InvokerLocator locator = new InvokerLocator(locatorURI);
/*     */ 
/* 131 */       String protocol = locator.getProtocol();
/*     */ 
/* 133 */       if ((!this.disableRemotingChecks) && ((protocol.equals("bisocket")) || (protocol.equals("sslbisocket"))))
/*     */       {
/* 140 */         Map params = locator.getParameters();
/*     */ 
/* 143 */         boolean cont = (checkParam(params, "marshaller", "org.jboss.jms.wireformat.JMSWireFormat")) && (checkParam(params, "unmarshaller", "org.jboss.jms.wireformat.JMSWireFormat")) && (checkParam(params, "dataType", "jms")) && (checkParam(params, "timeout", "0")) && (checkParam(params, "clientSocketClass", "org.jboss.jms.client.remoting.ClientSocketWrapper")) && (checkParam(params, "numberOfCallRetries", "1")) && (checkParam(params, "pingFrequency", "214748364")) && (checkParam(params, "pingWindowFactor", "10"));
/*     */ 
/* 153 */         if (!cont)
/*     */         {
/* 155 */           throw new IllegalArgumentException("Failed to deploy connection factory since remoting configuration seems incorrect.");
/*     */         }
/*     */ 
/* 158 */         String val = (String)params.get("clientLeasePeriod");
/* 159 */         if (val != null)
/*     */         {
/* 161 */           int i = Integer.parseInt(val);
/* 162 */           if (i < 5000)
/*     */           {
/* 164 */             this.log.warn("Value of clientLeasePeriod at " + i + " seems low. Normal values are >= 5000");
/*     */           }
/*     */         }
/*     */ 
/* 168 */         val = (String)params.get("clientMaxPoolSize");
/* 169 */         if (val != null)
/*     */         {
/* 171 */           int i = Integer.parseInt(val);
/* 172 */           if (i < 50)
/*     */           {
/* 174 */             this.log.warn("Value of clientMaxPoolSize at " + i + " seems low. Normal values are >= 50");
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 179 */       this.connectionFactoryManager = serverPeer.getConnectionFactoryManager();
/* 180 */       this.connectorManager = serverPeer.getConnectorManager();
/* 181 */       this.connectionManager = serverPeer.getConnectionManager();
/*     */ 
/* 183 */       int refCount = this.connectorManager.registerConnector(this.connectorObjectName.getCanonicalName());
/*     */ 
/* 185 */       long leasePeriod = ((Long)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.connectorObjectName, "LeasePeriod")).longValue();
/*     */ 
/* 189 */       boolean enablePing = leasePeriod > 0L;
/*     */ 
/* 191 */       if ((refCount == 1) && (enablePing))
/*     */       {
/* 198 */         this.server.invoke(this.connectorObjectName, "addConnectionListener", new Object[] { this.connectionManager }, new String[] { "org.jboss.remoting.ConnectionListener" });
/*     */       }
/*     */ 
/* 205 */       this.connectionFactoryManager.registerConnectionFactory(getServiceName().getCanonicalName(), this.clientID, this.jndiBindings, locatorURI, enablePing, this.prefetchSize, this.slowConsumers, this.defaultTempQueueFullSize, this.defaultTempQueuePageSize, this.defaultTempQueueDownCacheSize, this.dupsOKBatchSize, this.supportsFailover, this.supportsLoadBalancing, this.loadBalancingFactory, this.strictTck);
/*     */ 
/* 212 */       String info = "Connector " + locator.getProtocol() + "://" + locator.getHost() + ":" + locator.getPort();
/*     */ 
/* 215 */       if (enablePing)
/*     */       {
/* 217 */         info = info + " has leasing enabled, lease period " + leasePeriod + " milliseconds";
/*     */       }
/*     */       else
/*     */       {
/* 221 */         info = info + " has lease disabled";
/*     */       }
/*     */ 
/* 224 */       this.log.info(info);
/* 225 */       this.log.info(this + " started");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 229 */       throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void stopService() throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 237 */       this.started = false;
/*     */ 
/* 239 */       this.connectionFactoryManager.unregisterConnectionFactory(getServiceName().getCanonicalName(), this.supportsFailover, this.supportsLoadBalancing);
/*     */ 
/* 241 */       this.connectorManager.unregisterConnector(this.connectorObjectName.getCanonicalName());
/*     */ 
/* 243 */       this.log.info(this + " undeployed");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 247 */       throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getDefaultTempQueueFullSize()
/*     */   {
/* 255 */     return this.defaultTempQueueFullSize;
/*     */   }
/*     */ 
/*     */   public void setDefaultTempQueueFullSize(int size)
/*     */   {
/* 260 */     this.defaultTempQueueFullSize = size;
/*     */   }
/*     */ 
/*     */   public int getDefaultTempQueuePageSize()
/*     */   {
/* 265 */     return this.defaultTempQueuePageSize;
/*     */   }
/*     */ 
/*     */   public void setDefaultTempQueuePageSize(int size)
/*     */   {
/* 270 */     this.defaultTempQueuePageSize = size;
/*     */   }
/*     */ 
/*     */   public int getDefaultTempQueueDownCacheSize()
/*     */   {
/* 275 */     return this.defaultTempQueueDownCacheSize;
/*     */   }
/*     */ 
/*     */   public void setDefaultTempQueueDownCacheSize(int size)
/*     */   {
/* 280 */     this.defaultTempQueueDownCacheSize = size;
/*     */   }
/*     */ 
/*     */   public int getPrefetchSize()
/*     */   {
/* 285 */     return this.prefetchSize;
/*     */   }
/*     */ 
/*     */   public void setPrefetchSize(int prefetchSize)
/*     */   {
/* 290 */     this.prefetchSize = prefetchSize;
/*     */   }
/*     */ 
/*     */   public boolean isSlowConsumers()
/*     */   {
/* 295 */     return this.slowConsumers;
/*     */   }
/*     */ 
/*     */   public void setSlowConsumers(boolean slowConsumers)
/*     */   {
/* 300 */     this.slowConsumers = slowConsumers;
/*     */   }
/*     */ 
/*     */   public String getClientID()
/*     */   {
/* 305 */     return this.clientID;
/*     */   }
/*     */ 
/*     */   public void setJNDIBindings(Element e) throws Exception
/*     */   {
/* 310 */     this.jndiBindings = new JNDIBindings(e);
/*     */   }
/*     */ 
/*     */   public Element getJNDIBindings()
/*     */   {
/* 315 */     if (this.jndiBindings == null)
/*     */     {
/* 317 */       return null;
/*     */     }
/* 319 */     return this.jndiBindings.getDelegate();
/*     */   }
/*     */ 
/*     */   public void setServerPeer(ObjectName on)
/*     */   {
/* 324 */     if (this.started)
/*     */     {
/* 326 */       this.log.warn("Cannot change the value of associated server ObjectName after initialization!");
/*     */ 
/* 328 */       return;
/*     */     }
/*     */ 
/* 331 */     this.serverPeerObjectName = on;
/*     */   }
/*     */ 
/*     */   public ObjectName getServerPeer()
/*     */   {
/* 336 */     return this.serverPeerObjectName;
/*     */   }
/*     */ 
/*     */   public void setConnector(ObjectName on)
/*     */   {
/* 341 */     if (this.started)
/*     */     {
/* 343 */       this.log.warn("Cannot change the value of associated connector ObjectName after initialization!");
/*     */ 
/* 345 */       return;
/*     */     }
/*     */ 
/* 348 */     this.connectorObjectName = on;
/*     */   }
/*     */ 
/*     */   public ObjectName getConnector()
/*     */   {
/* 353 */     return this.connectorObjectName;
/*     */   }
/*     */ 
/*     */   public boolean isSupportsFailover()
/*     */   {
/* 358 */     return this.supportsFailover;
/*     */   }
/*     */ 
/*     */   public void setSupportsFailover(boolean supportsFailover)
/*     */   {
/* 363 */     if (this.started)
/*     */     {
/* 365 */       this.log.warn("supportsFailover can only be changed when connection factory is stopped");
/* 366 */       return;
/*     */     }
/* 368 */     this.supportsFailover = supportsFailover;
/*     */   }
/*     */ 
/*     */   public boolean isSupportsLoadBalancing()
/*     */   {
/* 373 */     return this.supportsLoadBalancing;
/*     */   }
/*     */ 
/*     */   public void setSupportsLoadBalancing(boolean supportsLoadBalancing)
/*     */   {
/* 378 */     if (this.started)
/*     */     {
/* 380 */       this.log.warn("supportsLoadBalancing can only be changed when connection factory is stopped");
/* 381 */       return;
/*     */     }
/* 383 */     this.supportsLoadBalancing = supportsLoadBalancing;
/*     */   }
/*     */ 
/*     */   public String getLoadBalancingFactory()
/*     */   {
/* 388 */     return this.loadBalancingFactory.getClass().getName();
/*     */   }
/*     */ 
/*     */   public void setLoadBalancingFactory(String factoryName) throws Exception
/*     */   {
/* 393 */     if (this.started)
/*     */     {
/* 395 */       this.log.warn("Load balancing policy can only be changed when connection factory is stopped");
/* 396 */       return;
/*     */     }
/*     */ 
/* 400 */     Class clz = Thread.currentThread().getContextClassLoader().loadClass(factoryName);
/*     */ 
/* 402 */     this.loadBalancingFactory = ((LoadBalancingFactory)clz.newInstance());
/*     */   }
/*     */ 
/*     */   public void setDupsOKBatchSize(int size) throws Exception
/*     */   {
/* 407 */     if (this.started)
/*     */     {
/* 409 */       this.log.warn("DupsOKBatchSize can only be changed when connection factory is stopped");
/* 410 */       return;
/*     */     }
/*     */ 
/* 413 */     this.dupsOKBatchSize = size;
/*     */   }
/*     */ 
/*     */   public int getDupsOKBatchSize()
/*     */   {
/* 418 */     return this.dupsOKBatchSize;
/*     */   }
/*     */ 
/*     */   public boolean isStrictTck()
/*     */   {
/* 423 */     return this.strictTck;
/*     */   }
/*     */ 
/*     */   public void setStrictTck(boolean strictTck)
/*     */   {
/* 428 */     if (this.started)
/*     */     {
/* 430 */       this.log.warn("StrictTCK can only be changed when connection factory is stopped");
/* 431 */       return;
/*     */     }
/*     */ 
/* 434 */     this.strictTck = strictTck;
/*     */   }
/*     */ 
/*     */   public boolean isDisableRemotingChecks()
/*     */   {
/* 439 */     return this.disableRemotingChecks;
/*     */   }
/*     */ 
/*     */   public void setDisableRemotingChecks(boolean disable)
/*     */   {
/* 444 */     if (this.started)
/*     */     {
/* 446 */       this.log.warn("DisableRemotingChecks can only be changed when connection factory is stopped");
/* 447 */       return;
/*     */     }
/*     */ 
/* 450 */     this.disableRemotingChecks = disable;
/*     */   }
/*     */ 
/*     */   private boolean checkParam(Map params, String key, String value)
/*     */   {
/* 465 */     String val = (String)params.get(key);
/* 466 */     if (val == null)
/*     */     {
/* 468 */       this.log.error("Parameter " + key + " is not specified in the remoting congiguration");
/* 469 */       return false;
/*     */     }
/* 471 */     if (!val.equals(value))
/*     */     {
/* 473 */       this.log.error("Parameter " + key + " has a different value ( " + val + ") to the default shipped with this version of " + "JBM (" + value + "). " + "There is rarely a valid reason to change this parameter value. " + "If you are using ServiceBindingManager to supply the remoting configuration you should check " + "that the parameter value specified there exactly matches the value in the configuration supplied with JBM. " + "This connection factory will now not deploy. To override these checks set 'disableRemotingChecks' to " + "true on the connection factory. Only do this if you are absolutely sure you know the consequences.");
/*     */ 
/* 480 */       return false;
/*     */     }
/*     */ 
/* 484 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.connectionfactory.ConnectionFactory
 * JD-Core Version:    0.6.0
 */