/*     */ package org.jboss.jms.server.bridge;
/*     */ 
/*     */ import java.util.Properties;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.MessagingComponent;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class BridgeService extends ServiceMBeanSupport
/*     */   implements BridgeMBean
/*     */ {
/*     */   private Bridge bridge;
/*     */   private String sourceDestinationLookup;
/*     */   private String targetDestinationLookup;
/*     */   private ObjectName sourceProviderLoader;
/*     */   private ObjectName targetProviderLoader;
/*     */ 
/*     */   public BridgeService()
/*     */   {
/*  55 */     this.bridge = new Bridge();
/*     */   }
/*     */ 
/*     */   public synchronized ObjectName getSourceProviderLoader()
/*     */   {
/*  62 */     return this.sourceProviderLoader;
/*     */   }
/*     */ 
/*     */   public synchronized void setSourceProviderLoader(ObjectName sourceProvider)
/*     */   {
/*  67 */     if (this.bridge.isStarted())
/*     */     {
/*  69 */       this.log.warn("Cannot set SourceProvider when bridge is started");
/*  70 */       return;
/*     */     }
/*  72 */     this.sourceProviderLoader = sourceProvider;
/*     */   }
/*     */ 
/*     */   public synchronized ObjectName getTargetProviderLoader()
/*     */   {
/*  77 */     return this.targetProviderLoader;
/*     */   }
/*     */ 
/*     */   public synchronized void setTargetProviderLoader(ObjectName targetProvider)
/*     */   {
/*  82 */     if (this.bridge.isStarted())
/*     */     {
/*  84 */       this.log.warn("Cannot set TargetProvider when bridge is started");
/*  85 */       return;
/*     */     }
/*  87 */     this.targetProviderLoader = targetProvider;
/*     */   }
/*     */ 
/*     */   public String getSourceDestinationLookup()
/*     */   {
/*  92 */     return this.sourceDestinationLookup;
/*     */   }
/*     */ 
/*     */   public String getTargetDestinationLookup()
/*     */   {
/*  97 */     return this.targetDestinationLookup;
/*     */   }
/*     */ 
/*     */   public void setSourceDestinationLookup(String lookup)
/*     */   {
/* 102 */     if (this.bridge.isStarted())
/*     */     {
/* 104 */       this.log.warn("Cannot set SourceDestinationLookup when bridge is started");
/* 105 */       return;
/*     */     }
/* 107 */     this.sourceDestinationLookup = checkAndTrim(lookup);
/*     */   }
/*     */ 
/*     */   public void setTargetDestinationLookup(String lookup)
/*     */   {
/* 112 */     if (this.bridge.isStarted())
/*     */     {
/* 114 */       this.log.warn("Cannot set TargetDestinationLookup when bridge is started");
/* 115 */       return;
/*     */     }
/* 117 */     this.targetDestinationLookup = checkAndTrim(lookup);
/*     */   }
/*     */ 
/*     */   public String getSourceUsername()
/*     */   {
/* 122 */     return this.bridge.getSourceUsername();
/*     */   }
/*     */ 
/*     */   public String getSourcePassword()
/*     */   {
/* 127 */     return this.bridge.getSourcePassword();
/*     */   }
/*     */ 
/*     */   public void setSourceUsername(String name)
/*     */   {
/* 132 */     this.bridge.setSourceUsername(name);
/*     */   }
/*     */ 
/*     */   public void setSourcePassword(String pwd)
/*     */   {
/* 137 */     this.bridge.setSourcePassword(pwd);
/*     */   }
/*     */ 
/*     */   public String getTargetUsername()
/*     */   {
/* 142 */     return this.bridge.getDestUsername();
/*     */   }
/*     */ 
/*     */   public String getTargetPassword()
/*     */   {
/* 147 */     return this.bridge.getDestPassword();
/*     */   }
/*     */ 
/*     */   public void setTargetUsername(String name)
/*     */   {
/* 152 */     this.bridge.setDestUserName(name);
/*     */   }
/*     */ 
/*     */   public void setTargetPassword(String pwd)
/*     */   {
/* 157 */     this.bridge.setDestPassword(pwd);
/*     */   }
/*     */ 
/*     */   public int getQualityOfServiceMode()
/*     */   {
/* 162 */     return this.bridge.getQualityOfServiceMode();
/*     */   }
/*     */ 
/*     */   public void setQualityOfServiceMode(int mode)
/*     */   {
/* 167 */     this.bridge.setQualityOfServiceMode(mode);
/*     */   }
/*     */ 
/*     */   public String getSelector()
/*     */   {
/* 172 */     return this.bridge.getSelector();
/*     */   }
/*     */ 
/*     */   public void setSelector(String selector)
/*     */   {
/* 177 */     this.bridge.setSelector(selector);
/*     */   }
/*     */ 
/*     */   public int getMaxBatchSize()
/*     */   {
/* 182 */     return this.bridge.getMaxBatchSize();
/*     */   }
/*     */ 
/*     */   public void setMaxBatchSize(int size)
/*     */   {
/* 187 */     this.bridge.setMaxBatchSize(size);
/*     */   }
/*     */ 
/*     */   public long getMaxBatchTime()
/*     */   {
/* 192 */     return this.bridge.getMaxBatchTime();
/*     */   }
/*     */ 
/*     */   public void setMaxBatchTime(long time)
/*     */   {
/* 197 */     this.bridge.setMaxBatchTime(time);
/*     */   }
/*     */ 
/*     */   public String getSubName()
/*     */   {
/* 202 */     return this.bridge.getSubName();
/*     */   }
/*     */ 
/*     */   public void setSubName(String subname)
/*     */   {
/* 207 */     this.bridge.setSubName(subname);
/*     */   }
/*     */ 
/*     */   public String getClientID()
/*     */   {
/* 212 */     return this.bridge.getClientID();
/*     */   }
/*     */ 
/*     */   public void setClientID(String clientID)
/*     */   {
/* 217 */     this.bridge.setClientID(clientID);
/*     */   }
/*     */ 
/*     */   public long getFailureRetryInterval()
/*     */   {
/* 222 */     return this.bridge.getFailureRetryInterval();
/*     */   }
/*     */ 
/*     */   public void setFailureRetryInterval(long interval)
/*     */   {
/* 227 */     this.bridge.setFailureRetryInterval(interval);
/*     */   }
/*     */ 
/*     */   public int getMaxRetries()
/*     */   {
/* 232 */     return this.bridge.getMaxRetries();
/*     */   }
/*     */ 
/*     */   public void setMaxRetries(int retries)
/*     */   {
/* 237 */     this.bridge.setMaxRetries(retries);
/*     */   }
/*     */ 
/*     */   public boolean isAddMessageIDInHeader()
/*     */   {
/* 242 */     return this.bridge.isAddMessageIDInHeader();
/*     */   }
/*     */ 
/*     */   public void setAddMessageIDInHeader(boolean value)
/*     */   {
/* 247 */     this.bridge.setAddMessageIDInHeader(value);
/*     */   }
/*     */ 
/*     */   public boolean isFailed()
/*     */   {
/* 252 */     return this.bridge.isFailed();
/*     */   }
/*     */ 
/*     */   public boolean isPaused()
/*     */   {
/* 257 */     return this.bridge.isPaused();
/*     */   }
/*     */ 
/*     */   public boolean isStarted()
/*     */   {
/* 262 */     return this.bridge.isStarted();
/*     */   }
/*     */ 
/*     */   public MessagingComponent getInstance()
/*     */   {
/* 267 */     return this.bridge;
/*     */   }
/*     */ 
/*     */   public void pause()
/*     */     throws Exception
/*     */   {
/* 274 */     this.bridge.pause();
/*     */   }
/*     */ 
/*     */   public void resume() throws Exception
/*     */   {
/* 279 */     this.bridge.resume();
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 286 */     if (this.log.isTraceEnabled()) this.log.trace("Starting bridge");
/*     */ 
/* 288 */     super.startService();
/*     */ 
/* 290 */     if (this.sourceProviderLoader == null)
/*     */     {
/* 292 */       throw new IllegalArgumentException("sourceProvider cannot be null");
/*     */     }
/*     */ 
/* 295 */     if (this.targetProviderLoader == null)
/*     */     {
/* 297 */       throw new IllegalArgumentException("targetProvider cannot be null");
/*     */     }
/*     */ 
/* 300 */     if (this.sourceDestinationLookup == null)
/*     */     {
/* 302 */       throw new IllegalArgumentException("Source destination lookup cannot be null");
/*     */     }
/*     */ 
/* 305 */     if (this.targetDestinationLookup == null)
/*     */     {
/* 307 */       throw new IllegalArgumentException("Target destination lookup cannot be null");
/*     */     }
/*     */ 
/* 310 */     boolean sameSourceAndTarget = this.sourceProviderLoader.equals(this.targetProviderLoader);
/*     */ 
/* 312 */     Properties sourceProps = (Properties)this.server.getAttribute(this.sourceProviderLoader, "Properties");
/*     */ 
/* 314 */     Properties targetProps = (Properties)this.server.getAttribute(this.targetProviderLoader, "Properties");
/*     */ 
/* 316 */     String sourceCFRef = (String)this.server.getAttribute(this.sourceProviderLoader, "FactoryRef");
/*     */ 
/* 318 */     String targetCFRef = (String)this.server.getAttribute(this.targetProviderLoader, "FactoryRef");
/*     */ 
/* 320 */     ConnectionFactoryFactory sourceCff = new JNDIConnectionFactoryFactory(sourceProps, sourceCFRef);
/*     */     ConnectionFactoryFactory destCff;
/*     */     ConnectionFactoryFactory destCff;
/* 325 */     if (sameSourceAndTarget)
/*     */     {
/* 327 */       destCff = sourceCff;
/*     */     }
/*     */     else
/*     */     {
/* 331 */       destCff = new JNDIConnectionFactoryFactory(targetProps, targetCFRef);
/*     */     }
/*     */ 
/* 334 */     this.bridge.setSourceConnectionFactoryFactory(sourceCff);
/*     */ 
/* 336 */     this.bridge.setDestConnectionFactoryFactory(destCff);
/*     */ 
/* 338 */     DestinationFactory sourceDestinationFactory = new JNDIDestinationFactory(sourceProps, this.sourceDestinationLookup);
/*     */ 
/* 340 */     DestinationFactory targetDestinationFactory = new JNDIDestinationFactory(targetProps, this.targetDestinationLookup);
/*     */ 
/* 342 */     this.bridge.setSourceDestinationFactory(sourceDestinationFactory);
/*     */ 
/* 344 */     this.bridge.setTargetDestinationFactory(targetDestinationFactory);
/*     */ 
/* 346 */     this.bridge.start();
/*     */ 
/* 348 */     this.log.info("Started bridge " + getName() + ". Source: " + this.sourceDestinationLookup + " Target: " + this.targetDestinationLookup);
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/* 354 */     if (this.log.isTraceEnabled()) this.log.trace("Stopping bridge");
/*     */ 
/* 356 */     this.bridge.stop();
/*     */ 
/* 358 */     this.log.info("Stopped bridge " + getName());
/*     */   }
/*     */ 
/*     */   private String checkAndTrim(String s)
/*     */   {
/* 365 */     if (s != null)
/*     */     {
/* 367 */       s = s.trim();
/* 368 */       if ("".equals(s))
/*     */       {
/* 370 */         s = null;
/*     */       }
/*     */     }
/* 373 */     return s;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.bridge.BridgeService
 * JD-Core Version:    0.6.0
 */