/*      */ package org.jboss.jms.server;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*      */ import java.io.ByteArrayOutputStream;
/*      */ import java.io.CharArrayWriter;
/*      */ import java.io.InputStream;
/*      */ import java.io.PrintWriter;
/*      */ import java.net.URL;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.Comparator;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import java.util.StringTokenizer;
/*      */ import javax.management.Attribute;
/*      */ import javax.management.InstanceNotFoundException;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.ObjectName;
/*      */ import javax.transaction.xa.Xid;
/*      */ import org.jboss.aop.AspectXmlLoader;
/*      */ import org.jboss.jms.server.connectionfactory.ConnectionFactoryJNDIMapper;
/*      */ import org.jboss.jms.server.connectionmanager.SimpleConnectionManager;
/*      */ import org.jboss.jms.server.connectormanager.SimpleConnectorManager;
/*      */ import org.jboss.jms.server.destination.ManagedQueue;
/*      */ import org.jboss.jms.server.endpoint.ServerConnectionEndpoint;
/*      */ import org.jboss.jms.server.endpoint.ServerSessionEndpoint;
/*      */ import org.jboss.jms.server.messagecounter.MessageCounter;
/*      */ import org.jboss.jms.server.messagecounter.MessageCounterManager;
/*      */ import org.jboss.jms.server.plugin.contract.JMSUserManager;
/*      */ import org.jboss.jms.server.remoting.JMSServerInvocationHandler;
/*      */ import org.jboss.jms.server.security.SecurityMetadataStore;
/*      */ import org.jboss.jms.wireformat.JMSWireFormat;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.messaging.core.contract.Binding;
/*      */ import org.jboss.messaging.core.contract.ClusterNotifier;
/*      */ import org.jboss.messaging.core.contract.MemoryManager;
/*      */ import org.jboss.messaging.core.contract.MessageStore;
/*      */ import org.jboss.messaging.core.contract.PersistenceManager;
/*      */ import org.jboss.messaging.core.contract.PostOffice;
/*      */ import org.jboss.messaging.core.contract.Queue;
/*      */ import org.jboss.messaging.core.contract.Replicator;
/*      */ import org.jboss.messaging.core.impl.DefaultClusterNotifier;
/*      */ import org.jboss.messaging.core.impl.FailoverWaiter;
/*      */ import org.jboss.messaging.core.impl.IDManager;
/*      */ import org.jboss.messaging.core.impl.JDBCPersistenceManager;
/*      */ import org.jboss.messaging.core.impl.clusterconnection.ClusterConnectionManager;
/*      */ import org.jboss.messaging.core.impl.memory.SimpleMemoryManager;
/*      */ import org.jboss.messaging.core.impl.message.SimpleMessageStore;
/*      */ import org.jboss.messaging.core.impl.postoffice.MessagingPostOffice;
/*      */ import org.jboss.messaging.core.impl.tx.TransactionRepository;
/*      */ import org.jboss.messaging.util.ExceptionUtil;
/*      */ import org.jboss.messaging.util.JMXAccessor;
/*      */ import org.jboss.messaging.util.Util;
/*      */ import org.jboss.messaging.util.Version;
/*      */ import org.jboss.mx.loading.UnifiedClassLoader3;
/*      */ import org.jboss.remoting.Client;
/*      */ import org.jboss.remoting.InvokerLocator;
/*      */ import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
/*      */ import org.jboss.remoting.marshal.MarshalFactory;
/*      */ import org.jboss.remoting.transport.ClientInvoker;
/*      */ import org.jboss.system.ServiceCreator;
/*      */ import org.jboss.system.ServiceMBeanSupport;
/*      */ import org.jboss.util.JBossStringBuilder;
/*      */ import org.w3c.dom.Element;
/*      */ 
/*      */ public class ServerPeer extends ServiceMBeanSupport
/*      */ {
/*  105 */   private static final Logger log = Logger.getLogger(ServerPeer.class);
/*      */   public static final String REMOTING_JMS_SUBSYSTEM = "JMS";
/*  115 */   private int serverPeerID = -1;
/*      */   private byte[] clientAOPStack;
/*      */   private Version version;
/*  119 */   private String defaultQueueJNDIContext = "";
/*  120 */   private String defaultTopicJNDIContext = "";
/*      */   private boolean started;
/*  124 */   private boolean supportsFailover = true;
/*      */ 
/*  128 */   private int defaultMaxDeliveryAttempts = 10;
/*      */ 
/*  131 */   private long failoverStartTimeout = 60000L;
/*      */ 
/*  134 */   private long failoverCompleteTimeout = 300000L;
/*      */   private Map sessions;
/*      */   private long defaultRedeliveryDelay;
/*  140 */   private long messageCounterSamplePeriod = 10000L;
/*      */   private int defaultMessageCounterHistoryDayLimit;
/*      */   private String clusterPullConnectionFactoryName;
/*      */   private boolean useXAForMessagePull;
/*      */   private boolean defaultPreserveOrdering;
/*  150 */   private long recoverDeliveriesTimeout = 300000L;
/*      */   private String suckerPassword;
/*      */   private boolean strictTck;
/*      */   private boolean strictTckProperty;
/*      */   private DestinationJNDIMapper destinationJNDIMapper;
/*      */   private SecurityMetadataStore securityStore;
/*      */   private ConnectionFactoryJNDIMapper connFactoryJNDIMapper;
/*      */   private TransactionRepository txRepository;
/*      */   private SimpleConnectionManager connectionManager;
/*      */   private ConnectorManager connectorManager;
/*      */   private IDManager messageIDManager;
/*      */   private IDManager channelIDManager;
/*      */   private IDManager transactionIDManager;
/*      */   private MemoryManager memoryManager;
/*      */   private MessageStore messageStore;
/*      */   private MessageCounterManager messageCounterManager;
/*      */   private ClusterConnectionManager clusterConnectionManager;
/*      */   private ClusterNotifier clusterNotifier;
/*      */   private FailoverWaiter failoverWaiter;
/*      */   protected ObjectName persistenceManagerObjectName;
/*      */   protected PersistenceManager persistenceManager;
/*      */   protected ObjectName postOfficeObjectName;
/*      */   protected PostOffice postOffice;
/*      */   protected ObjectName jmsUserManagerObjectName;
/*      */   protected JMSUserManager jmsUserManager;
/*      */   protected ObjectName defaultDLQObjectName;
/*      */   protected Queue defaultDLQ;
/*      */   protected ObjectName defaultExpiryQueueObjectName;
/*      */   protected Queue defaultExpiryQueue;
/*      */ 
/*      */   public ServerPeer()
/*      */     throws Exception
/*      */   {
/*  199 */     this.securityStore = new SecurityMetadataStore();
/*      */ 
/*  201 */     this.version = Version.instance();
/*      */ 
/*  203 */     this.sessions = new ConcurrentReaderHashMap();
/*      */ 
/*  205 */     this.started = false;
/*      */   }
/*      */ 
/*      */   public synchronized void startService()
/*      */     throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  214 */       log.debug("starting ServerPeer");
/*      */ 
/*  216 */       if (this.started)
/*      */       {
/*  218 */         return;
/*      */       }
/*      */ 
/*  221 */       if (this.serverPeerID < 0)
/*      */       {
/*  223 */         throw new IllegalStateException("ServerPeerID not set");
/*      */       }
/*      */ 
/*  226 */       log.debug(this + " starting");
/*      */ 
/*  228 */       loadClientAOPConfig();
/*      */ 
/*  230 */       loadServerAOPConfig();
/*      */ 
/*  232 */       MBeanServer mbeanServer = getServer();
/*      */ 
/*  238 */       this.persistenceManager = ((PersistenceManager)JMXAccessor.getJMXAttributeOverSecurity(mbeanServer, this.persistenceManagerObjectName, "Instance"));
/*  239 */       ((JDBCPersistenceManager)this.persistenceManager).injectNodeID(this.serverPeerID);
/*      */ 
/*  241 */       this.jmsUserManager = ((JMSUserManager)JMXAccessor.getJMXAttributeOverSecurity(mbeanServer, this.jmsUserManagerObjectName, "Instance"));
/*      */ 
/*  243 */       this.strictTckProperty = "true".equalsIgnoreCase(System.getProperty("jboss.messaging.stricttck"));
/*      */ 
/*  249 */       this.messageIDManager = new IDManager("MESSAGE_ID", 4096, this.persistenceManager);
/*  250 */       this.channelIDManager = new IDManager("CHANNEL_ID", 10, this.persistenceManager);
/*  251 */       this.transactionIDManager = new IDManager("TRANSACTION_ID", 1024, this.persistenceManager);
/*  252 */       this.destinationJNDIMapper = new DestinationJNDIMapper(this);
/*  253 */       this.connFactoryJNDIMapper = new ConnectionFactoryJNDIMapper(this);
/*  254 */       this.connectionManager = new SimpleConnectionManager();
/*  255 */       this.connectorManager = new SimpleConnectorManager();
/*  256 */       this.memoryManager = new SimpleMemoryManager();
/*  257 */       this.messageStore = new SimpleMessageStore();
/*  258 */       this.txRepository = new TransactionRepository(this.persistenceManager, this.messageStore, this.transactionIDManager);
/*      */ 
/*  260 */       this.messageCounterManager = new MessageCounterManager(this.messageCounterSamplePeriod);
/*      */ 
/*  262 */       this.clusterNotifier = new DefaultClusterNotifier();
/*  263 */       this.clusterNotifier.registerListener(this.connectionManager);
/*  264 */       this.clusterNotifier.registerListener(this.connFactoryJNDIMapper);
/*  265 */       this.failoverWaiter = new FailoverWaiter(this.serverPeerID, this.failoverStartTimeout, this.failoverCompleteTimeout, this.txRepository);
/*  266 */       this.clusterNotifier.registerListener(this.failoverWaiter);
/*      */ 
/*  268 */       if (this.suckerPassword == null)
/*      */       {
/*  270 */         this.suckerPassword = "CHANGE ME!!";
/*      */       }
/*  272 */       if (this.clusterPullConnectionFactoryName != null)
/*      */       {
/*  274 */         this.clusterConnectionManager = new ClusterConnectionManager(this.useXAForMessagePull, this.serverPeerID, this.clusterPullConnectionFactoryName, this.defaultPreserveOrdering, "JBM.SUCKER", this.suckerPassword);
/*      */ 
/*  277 */         this.clusterNotifier.registerListener(this.clusterConnectionManager);
/*      */       }
/*      */ 
/*  282 */       this.messageIDManager.start();
/*  283 */       this.channelIDManager.start();
/*  284 */       this.transactionIDManager.start();
/*  285 */       this.destinationJNDIMapper.start();
/*  286 */       this.connFactoryJNDIMapper.start();
/*  287 */       this.connectionManager.start();
/*  288 */       this.connectorManager.start();
/*  289 */       this.memoryManager.start();
/*  290 */       this.messageStore.start();
/*  291 */       this.securityStore.setSuckerPassword(this.suckerPassword);
/*  292 */       this.securityStore.start();
/*  293 */       this.txRepository.start();
/*  294 */       this.clusterConnectionManager.start();
/*      */ 
/*  301 */       this.txRepository.loadPreparedTransactions();
/*      */ 
/*  303 */       JMSWireFormat wf = new JMSWireFormat();
/*  304 */       MarshalFactory.addMarshaller("jms", wf, wf);
/*      */ 
/*  308 */       JMSServerInvocationHandler.setClosed(false);
/*      */ 
/*  310 */       this.started = true;
/*      */ 
/*  312 */       log.info("JBoss Messaging " + getVersion().getProviderVersion() + " server [" + getServerPeerID() + "] started");
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  317 */       throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void stopService() throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  325 */       if (!this.started)
/*      */       {
/*  327 */         return;
/*      */       }
/*      */ 
/*  330 */       log.info(this + " is Stopping. NOTE! Stopping the server peer cleanly will NOT cause failover to occur");
/*      */ 
/*  332 */       this.started = false;
/*      */ 
/*  337 */       JMSServerInvocationHandler.setClosed(true);
/*      */ 
/*  341 */       this.messageIDManager.stop();
/*  342 */       this.messageIDManager = null;
/*  343 */       this.channelIDManager.stop();
/*  344 */       this.channelIDManager = null;
/*  345 */       this.transactionIDManager.stop();
/*  346 */       this.transactionIDManager = null;
/*  347 */       this.destinationJNDIMapper.stop();
/*  348 */       this.destinationJNDIMapper = null;
/*  349 */       this.connFactoryJNDIMapper.stop();
/*  350 */       this.connFactoryJNDIMapper = null;
/*  351 */       this.connectionManager.stop();
/*  352 */       this.connectionManager = null;
/*  353 */       this.connectorManager.start();
/*  354 */       this.connectorManager = null;
/*  355 */       this.memoryManager.stop();
/*  356 */       this.memoryManager = null;
/*  357 */       this.messageStore.stop();
/*  358 */       this.messageStore = null;
/*  359 */       this.securityStore.stop();
/*      */ 
/*  361 */       this.txRepository.stop();
/*  362 */       this.txRepository = null;
/*  363 */       this.messageCounterManager.stop();
/*  364 */       this.messageCounterManager = null;
/*  365 */       this.clusterConnectionManager.stop();
/*  366 */       this.clusterConnectionManager = null;
/*  367 */       this.postOffice = null;
/*      */ 
/*  369 */       unloadServerAOPConfig();
/*      */ 
/*  373 */       MessagingTimeoutFactory.instance.reset();
/*      */ 
/*  375 */       log.info("JMS " + this + " stopped");
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  379 */       throw ExceptionUtil.handleJMXInvocation(t, this + " stopService");
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized ObjectName getPersistenceManager()
/*      */   {
/*  389 */     return this.persistenceManagerObjectName;
/*      */   }
/*      */ 
/*      */   public synchronized void setPersistenceManager(ObjectName on)
/*      */   {
/*  394 */     if (this.started)
/*      */     {
/*  396 */       log.warn("Cannot set persistence manager on server peer when server peer is started");
/*  397 */       return;
/*      */     }
/*  399 */     this.persistenceManagerObjectName = on;
/*      */   }
/*      */ 
/*      */   public synchronized ObjectName getPostOffice()
/*      */   {
/*  404 */     return this.postOfficeObjectName;
/*      */   }
/*      */ 
/*      */   public synchronized void setPostOffice(ObjectName on)
/*      */   {
/*  409 */     if (this.started)
/*      */     {
/*  411 */       log.warn("Cannot set post office on server peer when server peer is started");
/*  412 */       return;
/*      */     }
/*  414 */     this.postOfficeObjectName = on;
/*      */   }
/*      */ 
/*      */   public synchronized ObjectName getJmsUserManager()
/*      */   {
/*  419 */     return this.jmsUserManagerObjectName;
/*      */   }
/*      */ 
/*      */   public synchronized void setJMSUserManager(ObjectName on)
/*      */   {
/*  424 */     if (this.started)
/*      */     {
/*  426 */       log.warn("Cannot set jms user manager on server peer when server peer is started");
/*  427 */       return;
/*      */     }
/*  429 */     this.jmsUserManagerObjectName = on;
/*      */   }
/*      */ 
/*      */   public synchronized ObjectName getDefaultDLQ()
/*      */   {
/*  434 */     return this.defaultDLQObjectName;
/*      */   }
/*      */ 
/*      */   public synchronized void setDefaultDLQ(ObjectName on)
/*      */   {
/*  439 */     this.defaultDLQObjectName = on;
/*      */   }
/*      */ 
/*      */   public synchronized ObjectName getDefaultExpiryQueue()
/*      */   {
/*  444 */     return this.defaultExpiryQueueObjectName;
/*      */   }
/*      */ 
/*      */   public synchronized void setDefaultExpiryQueue(ObjectName on)
/*      */   {
/*  449 */     this.defaultExpiryQueueObjectName = on;
/*      */   }
/*      */ 
/*      */   public Object getInstance()
/*      */   {
/*  456 */     return this;
/*      */   }
/*      */ 
/*      */   public String getJMSVersion()
/*      */   {
/*  463 */     return this.version.getJMSVersion();
/*      */   }
/*      */ 
/*      */   public int getJMSMajorVersion()
/*      */   {
/*  468 */     return this.version.getJMSMajorVersion();
/*      */   }
/*      */ 
/*      */   public int getJMSMinorVersion()
/*      */   {
/*  473 */     return this.version.getJMSMinorVersion();
/*      */   }
/*      */ 
/*      */   public String getJMSProviderName()
/*      */   {
/*  478 */     return this.version.getJMSProviderName();
/*      */   }
/*      */ 
/*      */   public String getProviderVersion()
/*      */   {
/*  483 */     return this.version.getProviderVersion();
/*      */   }
/*      */ 
/*      */   public int getProviderMajorVersion()
/*      */   {
/*  488 */     return this.version.getProviderMajorVersion();
/*      */   }
/*      */ 
/*      */   public int getProviderMinorVersion()
/*      */   {
/*  493 */     return this.version.getProviderMinorVersion();
/*      */   }
/*      */ 
/*      */   public synchronized void setSecurityDomain(String securityDomain)
/*      */     throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  502 */       this.securityStore.setSecurityDomain(securityDomain);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  506 */       throw ExceptionUtil.handleJMXInvocation(t, this + " setSecurityDomain");
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized String getSecurityDomain()
/*      */   {
/*  512 */     return this.securityStore.getSecurityDomain();
/*      */   }
/*      */ 
/*      */   public synchronized void setDefaultSecurityConfig(Element conf) throws Exception
/*      */   {
/*  517 */     this.securityStore.setDefaultSecurityConfig(conf);
/*      */   }
/*      */ 
/*      */   public synchronized Element getDefaultSecurityConfig()
/*      */   {
/*  522 */     return this.securityStore.getDefaultSecurityConfig();
/*      */   }
/*      */ 
/*      */   public synchronized long getFailoverStartTimeout()
/*      */   {
/*  527 */     return this.failoverStartTimeout;
/*      */   }
/*      */ 
/*      */   public synchronized void setFailoverStartTimeout(long timeout)
/*      */   {
/*  532 */     this.failoverStartTimeout = timeout;
/*      */   }
/*      */ 
/*      */   public synchronized long getFailoverCompleteTimeout()
/*      */   {
/*  537 */     return this.failoverCompleteTimeout;
/*      */   }
/*      */ 
/*      */   public synchronized void setFailoverCompleteTimeout(long timeout)
/*      */   {
/*  542 */     this.failoverCompleteTimeout = timeout;
/*      */   }
/*      */ 
/*      */   public synchronized int getDefaultMaxDeliveryAttempts()
/*      */   {
/*  547 */     return this.defaultMaxDeliveryAttempts;
/*      */   }
/*      */ 
/*      */   public synchronized void setDefaultMaxDeliveryAttempts(int attempts)
/*      */   {
/*  552 */     this.defaultMaxDeliveryAttempts = attempts;
/*      */   }
/*      */ 
/*      */   public synchronized long getMessageCounterSamplePeriod()
/*      */   {
/*  557 */     return this.messageCounterSamplePeriod;
/*      */   }
/*      */ 
/*      */   public synchronized void setMessageCounterSamplePeriod(long newPeriod)
/*      */   {
/*  562 */     if (newPeriod < 1000L)
/*      */     {
/*  564 */       throw new IllegalArgumentException("Cannot set MessageCounterSamplePeriod < 1000 ms");
/*      */     }
/*      */ 
/*  567 */     if ((this.messageCounterManager != null) && (newPeriod != this.messageCounterSamplePeriod))
/*      */     {
/*  569 */       this.messageCounterManager.reschedule(newPeriod);
/*      */     }
/*      */ 
/*  572 */     this.messageCounterSamplePeriod = newPeriod;
/*      */   }
/*      */ 
/*      */   public synchronized long getDefaultRedeliveryDelay()
/*      */   {
/*  577 */     return this.defaultRedeliveryDelay;
/*      */   }
/*      */ 
/*      */   public synchronized void setDefaultRedeliveryDelay(long delay)
/*      */   {
/*  582 */     this.defaultRedeliveryDelay = delay;
/*      */   }
/*      */ 
/*      */   public synchronized int getDefaultMessageCounterHistoryDayLimit()
/*      */   {
/*  587 */     return this.defaultMessageCounterHistoryDayLimit;
/*      */   }
/*      */ 
/*      */   public void setDefaultMessageCounterHistoryDayLimit(int limit)
/*      */   {
/*  592 */     if (limit < -1)
/*      */     {
/*  594 */       limit = -1;
/*      */     }
/*      */ 
/*  597 */     this.defaultMessageCounterHistoryDayLimit = limit;
/*      */   }
/*      */ 
/*      */   public String getClusterPullConnectionFactoryName()
/*      */   {
/*  602 */     return this.clusterPullConnectionFactoryName;
/*      */   }
/*      */ 
/*      */   public void setClusterPullConnectionFactoryName(String name)
/*      */   {
/*  607 */     if (this.started)
/*      */     {
/*  609 */       throw new IllegalStateException("Cannot set ClusterPullConnectionFactoryName while the service is running");
/*      */     }
/*  611 */     this.clusterPullConnectionFactoryName = name;
/*      */   }
/*      */ 
/*      */   public boolean isUseXAForMessagePull()
/*      */   {
/*  616 */     return this.useXAForMessagePull;
/*      */   }
/*      */ 
/*      */   public void setUseXAForMessagePull(boolean useXA) throws Exception
/*      */   {
/*  621 */     if (this.started)
/*      */     {
/*  623 */       throw new IllegalStateException("Cannot set UseXAForMessagePull while the service is running");
/*      */     }
/*      */ 
/*  626 */     this.useXAForMessagePull = useXA;
/*      */   }
/*      */ 
/*      */   public boolean isDefaultPreserveOrdering()
/*      */   {
/*  631 */     return this.defaultPreserveOrdering;
/*      */   }
/*      */ 
/*      */   public void setDefaultPreserveOrdering(boolean preserve) throws Exception
/*      */   {
/*  636 */     if (this.started)
/*      */     {
/*  638 */       throw new IllegalStateException("Cannot set DefaultPreserveOrdering while the service is running");
/*      */     }
/*      */ 
/*  641 */     this.defaultPreserveOrdering = preserve;
/*      */   }
/*      */ 
/*      */   public long getRecoverDeliveriesTimeout()
/*      */   {
/*  646 */     return this.recoverDeliveriesTimeout;
/*      */   }
/*      */ 
/*      */   public void setRecoverDeliveriesTimeout(long timeout)
/*      */   {
/*  651 */     this.recoverDeliveriesTimeout = timeout;
/*      */   }
/*      */ 
/*      */   public synchronized void setServerPeerID(int serverPeerID)
/*      */   {
/*  656 */     if (this.started)
/*      */     {
/*  658 */       throw new IllegalStateException("Cannot set ServerPeerID while the service is running");
/*      */     }
/*  660 */     if (serverPeerID < 0)
/*      */     {
/*  662 */       throw new IllegalArgumentException("Attempt to set negative ServerPeerID: " + serverPeerID);
/*      */     }
/*  664 */     this.serverPeerID = serverPeerID;
/*      */   }
/*      */ 
/*      */   public int getServerPeerID()
/*      */   {
/*  669 */     return this.serverPeerID;
/*      */   }
/*      */ 
/*      */   public String getDefaultQueueJNDIContext()
/*      */   {
/*  674 */     return this.defaultQueueJNDIContext;
/*      */   }
/*      */ 
/*      */   public synchronized void setDefaultQueueJNDIContext(String defaultQueueJNDIContext)
/*      */   {
/*  679 */     if (this.started)
/*      */     {
/*  681 */       throw new IllegalStateException("Cannot set DefaultQueueJNDIContext while the service is running");
/*      */     }
/*      */ 
/*  684 */     this.defaultQueueJNDIContext = defaultQueueJNDIContext;
/*      */   }
/*      */ 
/*      */   public String getDefaultTopicJNDIContext()
/*      */   {
/*  689 */     return this.defaultTopicJNDIContext;
/*      */   }
/*      */ 
/*      */   public synchronized void setDefaultTopicJNDIContext(String defaultTopicJNDIContext)
/*      */   {
/*  694 */     if (this.started)
/*      */     {
/*  696 */       throw new IllegalStateException("Cannot set DefaultTopicJNDIContext while the service is running");
/*      */     }
/*      */ 
/*  699 */     this.defaultTopicJNDIContext = defaultTopicJNDIContext;
/*      */   }
/*      */ 
/*      */   public synchronized void setSuckerPassword(String password)
/*      */   {
/*  704 */     if (this.started)
/*      */     {
/*  706 */       throw new IllegalStateException("Cannot set SuckerPassword while the service is running");
/*      */     }
/*      */ 
/*  709 */     if (password == null)
/*      */     {
/*  711 */       throw new IllegalArgumentException("SuckerPassword cannot be null");
/*      */     }
/*      */ 
/*  714 */     this.suckerPassword = password;
/*      */   }
/*      */ 
/*      */   public void setStrictTck(boolean strictTck)
/*      */   {
/*  719 */     this.strictTck = ((strictTck) || (this.strictTckProperty));
/*      */   }
/*      */ 
/*      */   public boolean isStrictTck()
/*      */   {
/*  724 */     return (this.strictTck) || (this.strictTckProperty);
/*      */   }
/*      */ 
/*      */   public void enableMessageCounters()
/*      */   {
/*  729 */     this.messageCounterManager.start();
/*      */   }
/*      */ 
/*      */   public void disableMessageCounters()
/*      */   {
/*  734 */     this.messageCounterManager.stop();
/*      */ 
/*  736 */     this.messageCounterManager.resetAllCounters();
/*      */ 
/*  738 */     this.messageCounterManager.resetAllCounterHistories();
/*      */   }
/*      */ 
/*      */   public String deployQueue(String name, String jndiName)
/*      */     throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  747 */       return deployDestinationDefault(true, name, jndiName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  751 */     throw ExceptionUtil.handleJMXInvocation(t, this + " createQueue");
/*      */   }
/*      */ 
/*      */   public String deployQueue(String name, String jndiName, int fullSize, int pageSize, int downCacheSize)
/*      */     throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  759 */       return deployDestination(true, name, jndiName, fullSize, pageSize, downCacheSize);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  763 */     throw ExceptionUtil.handleJMXInvocation(t, this + " createQueue(2)");
/*      */   }
/*      */ 
/*      */   public boolean destroyQueue(String name)
/*      */     throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  771 */       return destroyDestination(true, name);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  775 */     throw ExceptionUtil.handleJMXInvocation(t, this + " destroyQueue");
/*      */   }
/*      */ 
/*      */   public boolean undeployQueue(String name)
/*      */     throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  783 */       return undeployDestination(true, name);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  787 */     throw ExceptionUtil.handleJMXInvocation(t, this + " destroyQueue");
/*      */   }
/*      */ 
/*      */   public String deployTopic(String name, String jndiName)
/*      */     throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  795 */       return deployDestinationDefault(false, name, jndiName);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  799 */     throw ExceptionUtil.handleJMXInvocation(t, this + " createTopic");
/*      */   }
/*      */ 
/*      */   public String deployTopic(String name, String jndiName, int fullSize, int pageSize, int downCacheSize)
/*      */     throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  807 */       return deployDestination(false, name, jndiName, fullSize, pageSize, downCacheSize);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  811 */     throw ExceptionUtil.handleJMXInvocation(t, this + " createTopic(2)");
/*      */   }
/*      */ 
/*      */   public boolean destroyTopic(String name)
/*      */     throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  819 */       return destroyDestination(false, name);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  823 */     throw ExceptionUtil.handleJMXInvocation(t, this + " destroyTopic");
/*      */   }
/*      */ 
/*      */   public boolean undeployTopic(String name)
/*      */     throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  831 */       return undeployDestination(false, name);
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  835 */     throw ExceptionUtil.handleJMXInvocation(t, this + " destroyTopic");
/*      */   }
/*      */ 
/*      */   public Set getDestinations()
/*      */     throws Exception
/*      */   {
/*      */     try
/*      */     {
/*  843 */       return this.destinationJNDIMapper.getDestinations();
/*      */     }
/*      */     catch (Throwable t) {
/*      */     }
/*  847 */     throw ExceptionUtil.handleJMXInvocation(t, this + " getDestinations");
/*      */   }
/*      */ 
/*      */   public List getMessageCounters()
/*      */     throws Exception
/*      */   {
/*  853 */     Collection counters = this.messageCounterManager.getMessageCounters();
/*      */ 
/*  855 */     return new ArrayList(counters);
/*      */   }
/*      */ 
/*      */   public List getMessageStatistics() throws Exception
/*      */   {
/*  860 */     return MessageCounter.getMessageStatistics(getMessageCounters());
/*      */   }
/*      */ 
/*      */   public String listMessageCountersAsHTML() throws Exception
/*      */   {
/*  865 */     List counters = getMessageCounters();
/*      */ 
/*  867 */     Collections.sort(counters, new Comparator() {
/*      */       public int compare(Object o1, Object o2) {
/*  869 */         MessageCounter m1 = (MessageCounter)o1;
/*  870 */         MessageCounter m2 = (MessageCounter)o2;
/*  871 */         return m1.getDestinationName().compareTo(m2.getDestinationName());
/*      */       }
/*      */     });
/*  875 */     String ret = "<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Type</th><th>Name</th><th>Subscription</th><th>Durable</th><th>Count</th><th>CountDelta</th><th>Depth</th><th>DepthDelta</th><th>Last Add</th></tr>";
/*      */ 
/*  889 */     String strNameLast = null;
/*  890 */     String strTypeLast = null;
/*  891 */     String strDestLast = null;
/*      */ 
/*  893 */     String destData = "";
/*  894 */     int destCount = 0;
/*      */ 
/*  896 */     int countTotal = 0;
/*  897 */     int countDeltaTotal = 0;
/*  898 */     int depthTotal = 0;
/*  899 */     int depthDeltaTotal = 0;
/*      */ 
/*  901 */     int i = 0;
/*      */ 
/*  905 */     Iterator iter = counters.iterator();
/*      */ 
/*  907 */     while (iter.hasNext())
/*      */     {
/*  909 */       MessageCounter counter = (MessageCounter)iter.next();
/*      */ 
/*  912 */       StringTokenizer tokens = new StringTokenizer(counter.getCounterAsString(), ",");
/*      */ 
/*  914 */       String strType = tokens.nextToken();
/*  915 */       String strName = tokens.nextToken();
/*  916 */       String strSub = tokens.nextToken();
/*  917 */       String strDurable = tokens.nextToken();
/*      */ 
/*  919 */       String strDest = strType + "-" + strName;
/*      */ 
/*  921 */       String strCount = tokens.nextToken();
/*  922 */       String strCountDelta = tokens.nextToken();
/*  923 */       String strDepth = tokens.nextToken();
/*  924 */       String strDepthDelta = tokens.nextToken();
/*  925 */       String strDate = tokens.nextToken();
/*      */ 
/*  928 */       countTotal += Integer.parseInt(strCount);
/*  929 */       depthTotal += Integer.parseInt(strDepth);
/*      */ 
/*  931 */       countDeltaTotal += Integer.parseInt(strCountDelta);
/*  932 */       depthDeltaTotal += Integer.parseInt(strDepthDelta);
/*      */ 
/*  934 */       if (strCountDelta.equalsIgnoreCase("0")) {
/*  935 */         strCountDelta = "-";
/*      */       }
/*  937 */       if (strDepthDelta.equalsIgnoreCase("0")) {
/*  938 */         strDepthDelta = "-";
/*      */       }
/*      */ 
/*  943 */       if ((strDestLast != null) && (strDestLast.equals(strDest)))
/*      */       {
/*  946 */         destData = destData + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
/*  947 */         destCount++;
/*      */       }
/*      */       else
/*      */       {
/*  952 */         if (strDestLast != null)
/*      */         {
/*  955 */           ret = ret + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\"><td rowspan=\"" + destCount + "\">" + strTypeLast + "</td><td rowspan=\"" + destCount + "\">" + strNameLast + "</td>" + destData;
/*      */ 
/*  968 */           destData = "";
/*      */         }
/*      */ 
/*  971 */         destCount = 1;
/*      */       }
/*      */ 
/*  975 */       destData = destData + "<td>" + strSub + "</td>" + "<td>" + strDurable + "</td>" + "<td>" + strCount + "</td>" + "<td>" + strCountDelta + "</td>" + "<td>" + strDepth + "</td>" + "<td>" + strDepthDelta + "</td>" + "<td>" + strDate + "</td>";
/*      */ 
/*  998 */       strTypeLast = strType;
/*  999 */       strNameLast = strName;
/* 1000 */       strDestLast = strDest;
/*      */     }
/*      */ 
/* 1003 */     if (strDestLast != null)
/*      */     {
/* 1006 */       ret = ret + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\"><td rowspan=\"" + destCount + "\">" + strTypeLast + "</td><td rowspan=\"" + destCount + "\">" + strNameLast + "</td>" + destData;
/*      */     }
/*      */ 
/* 1021 */     ret = ret + "<tr><td><![CDATA[ ]]></td><td><![CDATA[ ]]></td><td><![CDATA[ ]]></td><td><![CDATA[ ]]></td><td>" + countTotal + "</td><td>" + (countDeltaTotal == 0 ? "-" : Integer.toString(countDeltaTotal)) + "</td><td>" + depthTotal + "</td><td>" + (depthDeltaTotal == 0 ? "-" : Integer.toString(depthDeltaTotal)) + "</td><td>Total</td></tr></table>";
/*      */ 
/* 1033 */     return ret;
/*      */   }
/*      */ 
/*      */   public void resetAllMessageCounters()
/*      */   {
/* 1038 */     this.messageCounterManager.resetAllCounters();
/*      */   }
/*      */ 
/*      */   public void resetAllMessageCounterHistories()
/*      */   {
/* 1043 */     this.messageCounterManager.resetAllCounterHistories();
/*      */   }
/*      */ 
/*      */   public List retrievePreparedTransactions()
/*      */   {
/* 1048 */     return this.txRepository.getPreparedTransactions();
/*      */   }
/*      */ 
/*      */   public String showPreparedTransactionsAsHTML()
/*      */   {
/* 1053 */     List txs = this.txRepository.getPreparedTransactions();
/* 1054 */     JBossStringBuilder buffer = new JBossStringBuilder();
/* 1055 */     buffer.append("<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\">");
/* 1056 */     buffer.append("<tr><th>Xid</th></tr>");
/* 1057 */     for (Iterator i = txs.iterator(); i.hasNext(); )
/*      */     {
/* 1059 */       Xid xid = (Xid)i.next();
/* 1060 */       if (xid != null)
/*      */       {
/* 1062 */         buffer.append("<tr><td>");
/* 1063 */         buffer.append(xid);
/* 1064 */         buffer.append("</td></tr>");
/*      */       }
/*      */     }
/* 1067 */     buffer.append("</table>");
/* 1068 */     return buffer.toString();
/*      */   }
/*      */ 
/*      */   public String showActiveClientsAsHTML() throws Exception
/*      */   {
/* 1073 */     CharArrayWriter charArray = new CharArrayWriter();
/* 1074 */     PrintWriter out = new PrintWriter(charArray);
/*      */ 
/* 1076 */     List endpoints = this.connectionManager.getActiveConnections();
/*      */ 
/* 1078 */     out.println("<table><tr><td>ID</td><td>Host</td><td>User</td><td>#Sessions</td></tr>");
/* 1079 */     for (Iterator iter = endpoints.iterator(); iter.hasNext(); )
/*      */     {
/* 1081 */       ServerConnectionEndpoint endpoint = (ServerConnectionEndpoint)iter.next();
/*      */ 
/* 1083 */       out.println("<tr>");
/* 1084 */       out.println("<td>" + endpoint.toString() + "</td>");
/* 1085 */       out.println("<td>" + endpoint.getCallbackHandler().getCallbackClient().getInvoker().getLocator().getHost() + "</td>");
/* 1086 */       out.println("<td>" + endpoint.getUsername() + "</td>");
/* 1087 */       out.println("<td>" + endpoint.getSessions().size() + "</td>");
/* 1088 */       out.println("</tr>");
/*      */     }
/*      */ 
/* 1091 */     out.println("</table>");
/*      */ 
/* 1094 */     return charArray.toString();
/*      */   }
/*      */ 
/*      */   public void resetAllSuckers()
/*      */   {
/* 1101 */     this.clusterConnectionManager.resetAllSuckers();
/*      */   }
/*      */ 
/*      */   public byte[] getClientAOPStack()
/*      */   {
/* 1106 */     return this.clientAOPStack;
/*      */   }
/*      */ 
/*      */   public MessageCounterManager getMessageCounterManager()
/*      */   {
/* 1111 */     return this.messageCounterManager;
/*      */   }
/*      */ 
/*      */   public IDManager getMessageIDManager()
/*      */   {
/* 1116 */     return this.messageIDManager;
/*      */   }
/*      */ 
/*      */   public IDManager getChannelIDManager()
/*      */   {
/* 1121 */     return this.channelIDManager;
/*      */   }
/*      */ 
/*      */   public ServerSessionEndpoint getSession(String sessionID)
/*      */   {
/* 1126 */     return (ServerSessionEndpoint)this.sessions.get(sessionID);
/*      */   }
/*      */ 
/*      */   public Collection getSessions()
/*      */   {
/* 1131 */     return this.sessions.values();
/*      */   }
/*      */ 
/*      */   public void addSession(String id, ServerSessionEndpoint session)
/*      */   {
/* 1136 */     this.sessions.put(id, session);
/*      */   }
/*      */ 
/*      */   public void removeSession(String id)
/*      */   {
/* 1141 */     if (this.sessions.remove(id) == null)
/*      */     {
/* 1143 */       throw new IllegalStateException("Cannot find session with id " + id + " to remove");
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized Queue getDefaultDLQInstance() throws Exception
/*      */   {
/* 1149 */     Queue dlq = null;
/*      */ 
/* 1151 */     if (this.defaultDLQObjectName != null)
/*      */     {
/* 1153 */       ManagedQueue dest = null;
/*      */ 
/* 1156 */       dest = (ManagedQueue)JMXAccessor.getJMXAttributeOverSecurity(getServer(), this.defaultDLQObjectName, "Instance");
/*      */ 
/* 1158 */       if ((dest != null) && (dest.getName() != null))
/*      */       {
/* 1160 */         Binding binding = this.postOffice.getBindingForQueueName(dest.getName());
/*      */ 
/* 1162 */         if (binding == null)
/*      */         {
/* 1164 */           throw new IllegalStateException("Cannot find binding for queue " + dest.getName());
/*      */         }
/*      */ 
/* 1167 */         Queue queue = binding.queue;
/*      */ 
/* 1169 */         if (queue.isActive())
/*      */         {
/* 1171 */           dlq = queue;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1176 */     return dlq;
/*      */   }
/*      */ 
/*      */   public synchronized Queue getDefaultExpiryQueueInstance() throws Exception
/*      */   {
/* 1181 */     Queue expiryQueue = null;
/*      */ 
/* 1183 */     if (this.defaultExpiryQueueObjectName != null)
/*      */     {
/* 1185 */       ManagedQueue dest = null;
/*      */       try
/*      */       {
/* 1190 */         dest = (ManagedQueue)JMXAccessor.getJMXAttributeOverSecurity(getServer(), this.defaultExpiryQueueObjectName, "Instance");
/*      */       }
/*      */       catch (InstanceNotFoundException e)
/*      */       {
/*      */       }
/*      */ 
/* 1197 */       if ((dest != null) && (dest.getName() != null))
/*      */       {
/* 1199 */         Binding binding = this.postOffice.getBindingForQueueName(dest.getName());
/*      */ 
/* 1201 */         if (binding == null)
/*      */         {
/* 1203 */           throw new IllegalStateException("Cannot find binding for queue " + dest.getName());
/*      */         }
/*      */ 
/* 1206 */         Queue queue = binding.queue;
/*      */ 
/* 1208 */         if (queue.isActive())
/*      */         {
/* 1210 */           expiryQueue = queue;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1215 */     return expiryQueue;
/*      */   }
/*      */ 
/*      */   public TransactionRepository getTxRepository()
/*      */   {
/* 1220 */     return this.txRepository;
/*      */   }
/*      */ 
/*      */   public synchronized boolean isStarted()
/*      */   {
/* 1225 */     return this.started;
/*      */   }
/*      */ 
/*      */   public Version getVersion()
/*      */   {
/* 1230 */     return this.version;
/*      */   }
/*      */ 
/*      */   public SecurityStore getSecurityManager()
/*      */   {
/* 1237 */     return this.securityStore;
/*      */   }
/*      */ 
/*      */   public DestinationManager getDestinationManager()
/*      */   {
/* 1242 */     return this.destinationJNDIMapper;
/*      */   }
/*      */ 
/*      */   public ConnectionFactoryManager getConnectionFactoryManager()
/*      */   {
/* 1247 */     return this.connFactoryJNDIMapper;
/*      */   }
/*      */ 
/*      */   public ConnectionManager getConnectionManager()
/*      */   {
/* 1252 */     return this.connectionManager;
/*      */   }
/*      */ 
/*      */   public ConnectorManager getConnectorManager()
/*      */   {
/* 1257 */     return this.connectorManager;
/*      */   }
/*      */ 
/*      */   public MessageStore getMessageStore()
/*      */   {
/* 1262 */     return this.messageStore;
/*      */   }
/*      */ 
/*      */   public MemoryManager getMemoryManager()
/*      */   {
/* 1267 */     return this.memoryManager;
/*      */   }
/*      */ 
/*      */   public PersistenceManager getPersistenceManagerInstance()
/*      */   {
/* 1274 */     return this.persistenceManager;
/*      */   }
/*      */ 
/*      */   public JMSUserManager getJmsUserManagerInstance()
/*      */   {
/* 1279 */     return this.jmsUserManager;
/*      */   }
/*      */ 
/*      */   public PostOffice getPostOfficeInstance()
/*      */     throws Exception
/*      */   {
/* 1285 */     if (this.postOffice == null)
/*      */     {
/* 1287 */       this.postOffice = ((PostOffice)JMXAccessor.getJMXAttributeOverSecurity(getServer(), this.postOfficeObjectName, "Instance"));
/*      */ 
/* 1292 */       if (this.postOffice.isClustered())
/*      */       {
/* 1294 */         Replicator rep = (Replicator)this.postOffice;
/*      */ 
/* 1296 */         this.connFactoryJNDIMapper.injectReplicator(rep);
/*      */ 
/* 1300 */         this.clusterConnectionManager.injectPostOffice(this.postOffice);
/*      */ 
/* 1302 */         this.clusterConnectionManager.injectReplicator((Replicator)this.postOffice);
/*      */ 
/* 1304 */         this.connectionManager.injectReplicator((Replicator)this.postOffice);
/*      */ 
/* 1306 */         ((MessagingPostOffice)this.postOffice).injectServerPeer(this);
/*      */       }
/*      */ 
/* 1310 */       this.txRepository.injectPostOffice(this.postOffice);
/*      */     }
/* 1312 */     return this.postOffice;
/*      */   }
/*      */ 
/*      */   public ClusterNotifier getClusterNotifier()
/*      */   {
/* 1317 */     return this.clusterNotifier;
/*      */   }
/*      */ 
/*      */   public FailoverWaiter getFailoverWaiter()
/*      */   {
/* 1322 */     return this.failoverWaiter;
/*      */   }
/*      */ 
/*      */   public boolean isSupportsFailover()
/*      */   {
/* 1327 */     return this.supportsFailover;
/*      */   }
/*      */ 
/*      */   public void setSupportsFailover(boolean supportsFailover) throws Exception
/*      */   {
/* 1332 */     if (this.started)
/*      */     {
/* 1334 */       throw new IllegalAccessException("supportsFailover can only be changed when server peer is stopped");
/*      */     }
/*      */ 
/* 1337 */     this.supportsFailover = supportsFailover;
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/* 1342 */     return "ServerPeer[" + getServerPeerID() + "]";
/*      */   }
/*      */ 
/*      */   private void loadServerAOPConfig()
/*      */     throws Exception
/*      */   {
/* 1353 */     URL url = getClass().getClassLoader().getResource("aop-messaging-server.xml");
/* 1354 */     AspectXmlLoader.deployXML(url, getClass().getClassLoader());
/*      */   }
/*      */ 
/*      */   private void unloadServerAOPConfig() throws Exception
/*      */   {
/* 1359 */     URL url = getClass().getClassLoader().getResource("aop-messaging-server.xml");
/* 1360 */     AspectXmlLoader.undeployXML(url);
/*      */   }
/*      */ 
/*      */   private void loadClientAOPConfig()
/*      */     throws Exception
/*      */   {
/* 1369 */     URL url = getClass().getClassLoader().getResource("aop-messaging-client.xml");
/* 1370 */     InputStream is = null;
/* 1371 */     ByteArrayOutputStream os = new ByteArrayOutputStream();
/*      */     try
/*      */     {
/* 1374 */       is = url.openStream();
/*      */       int b;
/* 1376 */       while ((b = is.read()) != -1)
/*      */       {
/* 1378 */         os.write(b);
/*      */       }
/* 1380 */       os.flush();
/* 1381 */       this.clientAOPStack = os.toByteArray();
/*      */     }
/*      */     finally
/*      */     {
/* 1385 */       if (is != null)
/*      */       {
/* 1387 */         is.close();
/*      */       }
/* 1389 */       if (os != null)
/*      */       {
/* 1391 */         os.close();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private String deployDestinationDefault(boolean isQueue, String name, String jndiName)
/*      */     throws Exception
/*      */   {
/* 1409 */     String destType = isQueue ? "Queue" : "Topic";
/* 1410 */     String className = "org.jboss.jms.server.destination." + destType + "Service";
/* 1411 */     String ons = "jboss.messaging.destination:service=" + destType + ",name=" + name;
/* 1412 */     ObjectName on = new ObjectName(ons);
/*      */ 
/* 1414 */     String destinationMBeanConfig = "<mbean code=\"" + className + "\" " + "       name=\"" + ons + "\" " + "       xmbean-dd=\"xmdesc/" + destType + "-xmbean.xml\">\n" + "    <constructor>" + "        <arg type=\"boolean\" value=\"true\"/>" + "    </constructor>" + "</mbean>";
/*      */ 
/* 1423 */     return deployDestinationInternal(destinationMBeanConfig, on, jndiName, false, -1, -1, -1);
/*      */   }
/*      */ 
/*      */   private String deployDestination(boolean isQueue, String name, String jndiName, int fullSize, int pageSize, int downCacheSize)
/*      */     throws Exception
/*      */   {
/* 1435 */     String destType = isQueue ? "Queue" : "Topic";
/* 1436 */     String className = "org.jboss.jms.server.destination." + destType + "Service";
/*      */ 
/* 1438 */     String ons = "jboss.messaging.destination:service=" + destType + ",name=" + name;
/* 1439 */     ObjectName on = new ObjectName(ons);
/*      */ 
/* 1441 */     String destinationMBeanConfig = "<mbean code=\"" + className + "\" " + "       name=\"" + ons + "\" " + "       xmbean-dd=\"xmdesc/" + destType + "-xmbean.xml\">\n" + "    <constructor>" + "        <arg type=\"boolean\" value=\"true\"/>" + "    </constructor>" + "    <attribute name=\"FullSize\">" + fullSize + "</attribute>" + "    <attribute name=\"PageSize\">" + pageSize + "</attribute>" + "    <attribute name=\"DownCacheSize\">" + downCacheSize + "</attribute>" + "</mbean>";
/*      */ 
/* 1453 */     return deployDestinationInternal(destinationMBeanConfig, on, jndiName, true, fullSize, pageSize, downCacheSize);
/*      */   }
/*      */ 
/*      */   private String deployDestinationInternal(String destinationMBeanConfig, ObjectName on, String jndiName, boolean params, int fullSize, int pageSize, int downCacheSize)
/*      */     throws Exception
/*      */   {
/* 1461 */     log.trace("Deploying destination" + destinationMBeanConfig + " jndiName: " + jndiName + "fullSize: " + fullSize + " pageSize: " + pageSize + " downCacheSize: " + downCacheSize);
/*      */ 
/* 1464 */     MBeanServer mbeanServer = getServer();
/*      */ 
/* 1466 */     Element element = Util.stringToElement(destinationMBeanConfig);
/*      */ 
/* 1468 */     ServiceCreator sc = new ServiceCreator(mbeanServer);
/*      */ 
/* 1470 */     ClassLoader cl = getClass().getClassLoader();
/* 1471 */     ObjectName loaderObjectName = null;
/* 1472 */     if ((cl instanceof UnifiedClassLoader3))
/*      */     {
/* 1474 */       loaderObjectName = ((UnifiedClassLoader3)cl).getObjectName();
/*      */     }
/*      */ 
/* 1477 */     sc.install(on, loaderObjectName, element);
/*      */ 
/* 1480 */     mbeanServer.setAttribute(on, new Attribute("ServerPeer", getServiceName()));
/* 1481 */     mbeanServer.setAttribute(on, new Attribute("JNDIName", jndiName));
/* 1482 */     if (params)
/*      */     {
/* 1484 */       mbeanServer.setAttribute(on, new Attribute("FullSize", new Integer(fullSize)));
/* 1485 */       mbeanServer.setAttribute(on, new Attribute("PageSize", new Integer(pageSize)));
/* 1486 */       mbeanServer.setAttribute(on, new Attribute("DownCacheSize", new Integer(downCacheSize)));
/*      */     }
/* 1488 */     mbeanServer.invoke(on, "create", new Object[0], new String[0]);
/* 1489 */     mbeanServer.invoke(on, "start", new Object[0], new String[0]);
/*      */ 
/* 1491 */     return (String)JMXAccessor.getJMXAttributeOverSecurity(mbeanServer, on, "JNDIName");
/*      */   }
/*      */ 
/*      */   private boolean undeployDestination(boolean isQueue, String name)
/*      */     throws Exception
/*      */   {
/* 1501 */     String destType = isQueue ? "Queue" : "Topic";
/* 1502 */     String ons = "jboss.messaging.destination:service=" + destType + ",name=" + name;
/* 1503 */     ObjectName on = new ObjectName(ons);
/*      */ 
/* 1505 */     MBeanServer mbeanServer = getServer();
/*      */ 
/* 1508 */     if (!mbeanServer.isRegistered(on))
/*      */     {
/* 1510 */       return false;
/*      */     }
/* 1512 */     Boolean b = (Boolean)JMXAccessor.getJMXAttributeOverSecurity(mbeanServer, on, "CreatedProgrammatically");
/* 1513 */     if (!b.booleanValue())
/*      */     {
/* 1515 */       log.warn("Cannot undeploy a destination that has not been created programatically");
/* 1516 */       return false;
/*      */     }
/* 1518 */     mbeanServer.invoke(on, "stop", new Object[0], new String[0]);
/* 1519 */     mbeanServer.invoke(on, "destroy", new Object[0], new String[0]);
/* 1520 */     mbeanServer.unregisterMBean(on);
/* 1521 */     return true;
/*      */   }
/*      */ 
/*      */   private boolean destroyDestination(boolean isQueue, String name)
/*      */     throws Throwable
/*      */   {
/* 1529 */     String destType = isQueue ? "Queue" : "Topic";
/* 1530 */     String ons = "jboss.messaging.destination:service=" + destType + ",name=" + name;
/* 1531 */     ObjectName on = new ObjectName(ons);
/*      */ 
/* 1533 */     MBeanServer mbeanServer = getServer();
/*      */ 
/* 1536 */     if (!mbeanServer.isRegistered(on))
/*      */     {
/* 1538 */       return false;
/*      */     }
/*      */ 
/* 1541 */     JMSCondition condition = new JMSCondition(isQueue, name);
/*      */ 
/* 1543 */     Collection queues = this.postOffice.getQueuesForCondition(condition, true);
/*      */ 
/* 1545 */     Iterator iter = queues.iterator();
/*      */ 
/* 1547 */     while (iter.hasNext())
/*      */     {
/* 1549 */       Queue queue = (Queue)iter.next();
/*      */ 
/* 1551 */       queue.removeAllReferences();
/*      */     }
/*      */ 
/* 1555 */     if (!undeployDestination(isQueue, name))
/*      */     {
/* 1557 */       return false;
/*      */     }
/*      */ 
/* 1562 */     while (iter.hasNext())
/*      */     {
/* 1564 */       Queue queue = (Queue)iter.next();
/*      */ 
/* 1566 */       queue.removeAllReferences();
/*      */ 
/* 1569 */       boolean all = (!isQueue) && (queue.isRecoverable());
/*      */ 
/* 1571 */       this.postOffice.removeBinding(queue.getName(), all);
/*      */     }
/*      */ 
/* 1574 */     return true;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.ServerPeer
 * JD-Core Version:    0.6.0
 */