/*     */ package org.jboss.jms.server;
/*     */ 
/*     */ import org.jboss.messaging.core.contract.Condition;
/*     */ 
/*     */ public class JMSCondition
/*     */   implements Condition
/*     */ {
/*     */   private static final String QUEUE_PREFIX = "queue.";
/*     */   private static final String TOPIC_PREFIX = "topic.";
/*     */   private boolean queue;
/*     */   private String name;
/*  51 */   private int hash = -1;
/*     */ 
/*     */   public JMSCondition(boolean queue, String name)
/*     */   {
/*  57 */     this.queue = queue;
/*  58 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public JMSCondition(String text)
/*     */   {
/*  63 */     if (text.startsWith("queue."))
/*     */     {
/*  65 */       this.queue = true;
/*  66 */       this.name = text.substring("queue.".length());
/*     */     }
/*  68 */     else if (text.startsWith("topic."))
/*     */     {
/*  70 */       this.queue = false;
/*  71 */       this.name = text.substring("topic.".length());
/*     */     }
/*     */     else
/*     */     {
/*  75 */       throw new IllegalArgumentException("Illegal text: " + text);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toText()
/*     */   {
/*  83 */     return (this.queue ? "queue." : "topic.") + this.name;
/*     */   }
/*     */ 
/*     */   public boolean isQueue()
/*     */   {
/*  90 */     return this.queue;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  95 */     return this.name;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 100 */     if (!(other instanceof JMSCondition))
/*     */     {
/* 102 */       return false;
/*     */     }
/*     */ 
/* 105 */     JMSCondition jmsCond = (JMSCondition)other;
/*     */ 
/* 107 */     return (jmsCond.queue == this.queue) && (jmsCond.name.equals(this.name));
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 112 */     if (this.hash == -1)
/*     */     {
/* 114 */       this.hash = 17;
/* 115 */       this.hash = (37 * this.hash + (this.queue ? 0 : 1));
/* 116 */       this.hash = (37 * this.hash + this.name.hashCode());
/*     */     }
/*     */ 
/* 119 */     return this.hash;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 124 */     return toText();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.JMSCondition
 * JD-Core Version:    0.6.0
 */