/*     */ package org.jboss.jms.server;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.jms.InvalidDestinationException;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.jms.destination.JBossQueue;
/*     */ import org.jboss.jms.destination.JBossTemporaryQueue;
/*     */ import org.jboss.jms.destination.JBossTemporaryTopic;
/*     */ import org.jboss.jms.destination.JBossTopic;
/*     */ import org.jboss.jms.exception.MessagingJMSException;
/*     */ import org.jboss.jms.server.destination.ManagedDestination;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.util.JNDIUtil;
/*     */ 
/*     */ class DestinationJNDIMapper
/*     */   implements DestinationManager
/*     */ {
/*  59 */   private static final Logger log = Logger.getLogger(DestinationJNDIMapper.class);
/*     */   private Context initialContext;
/*     */   private Map queueMap;
/*     */   private Map topicMap;
/*     */   private ServerPeer serverPeer;
/*     */ 
/*     */   public DestinationJNDIMapper(ServerPeer serverPeer)
/*     */     throws Exception
/*     */   {
/*  78 */     this.queueMap = new HashMap();
/*  79 */     this.topicMap = new HashMap();
/*  80 */     this.serverPeer = serverPeer;
/*     */   }
/*     */ 
/*     */   public synchronized void registerDestination(ManagedDestination destination)
/*     */     throws Exception
/*     */   {
/*  87 */     String jndiName = destination.getJndiName();
/*     */ 
/*  89 */     if (!destination.isTemporary())
/*     */     {
/*     */       String parentContext;
/*     */       String jndiNameInContext;
/*  94 */       if (jndiName == null)
/*     */       {
/*  96 */         String parentContext = destination.isQueue() ? this.serverPeer.getDefaultQueueJNDIContext() : this.serverPeer.getDefaultTopicJNDIContext();
/*     */ 
/*  99 */         String jndiNameInContext = destination.getName();
/* 100 */         jndiName = parentContext + "/" + jndiNameInContext;
/*     */       }
/*     */       else
/*     */       {
/* 105 */         int sepIndex = jndiName.lastIndexOf('/');
/*     */         String parentContext;
/* 106 */         if (sepIndex == -1)
/*     */         {
/* 108 */           parentContext = "";
/*     */         }
/*     */         else
/*     */         {
/* 112 */           parentContext = jndiName.substring(0, sepIndex);
/*     */         }
/* 114 */         jndiNameInContext = jndiName.substring(sepIndex + 1);
/*     */       }
/*     */ 
/* 117 */       destination.setJndiName(jndiName);
/*     */       try
/*     */       {
/* 121 */         this.initialContext.lookup(jndiName);
/* 122 */         throw new InvalidDestinationException("Destination " + destination.getName() + " already exists");
/*     */       }
/*     */       catch (NameNotFoundException c)
/*     */       {
/* 129 */         Context c = JNDIUtil.createContext(this.initialContext, parentContext);
/*     */         JBossDestination jbDest;
/*     */         JBossDestination jbDest;
/* 133 */         if (destination.isQueue())
/*     */         {
/* 135 */           jbDest = new JBossQueue(destination.getName());
/*     */         }
/*     */         else
/*     */         {
/* 139 */           jbDest = new JBossTopic(destination.getName());
/*     */         }
/*     */ 
/* 142 */         c.rebind(jndiNameInContext, jbDest);
/*     */       }
/*     */     }
/* 145 */     if (destination.isQueue())
/*     */     {
/* 147 */       this.queueMap.put(destination.getName(), destination);
/*     */     }
/*     */     else
/*     */     {
/* 151 */       this.topicMap.put(destination.getName(), destination);
/*     */     }
/*     */ 
/* 154 */     log.debug((destination.isQueue() ? "queue" : "topic") + " " + destination.getName() + " registered ");
/* 155 */     log.debug((destination.isQueue() ? "queue" : "topic") + " bound in JNDI as " + jndiName);
/*     */   }
/*     */ 
/*     */   public synchronized void unregisterDestination(ManagedDestination destination) throws Exception
/*     */   {
/* 160 */     String jndiName = null;
/* 161 */     if (destination.isQueue())
/*     */     {
/* 163 */       ManagedDestination dest = (ManagedDestination)this.queueMap.remove(destination.getName());
/* 164 */       if (dest != null)
/*     */       {
/* 166 */         jndiName = dest.getJndiName();
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 171 */       ManagedDestination dest = (ManagedDestination)this.topicMap.remove(destination.getName());
/* 172 */       if (dest != null)
/*     */       {
/* 174 */         jndiName = dest.getJndiName();
/*     */       }
/*     */     }
/* 177 */     if (jndiName == null)
/*     */     {
/* 179 */       return;
/*     */     }
/*     */ 
/* 182 */     if (!destination.isTemporary())
/*     */     {
/* 184 */       this.initialContext.unbind(jndiName);
/*     */ 
/* 186 */       this.serverPeer.getSecurityManager().clearSecurityConfig(destination.isQueue(), destination.getName());
/*     */     }
/*     */ 
/* 189 */     log.debug("unregistered " + (destination.isQueue() ? "queue " : "topic ") + destination.getName());
/*     */   }
/*     */ 
/*     */   public synchronized ManagedDestination getDestination(String name, boolean isQueue)
/*     */   {
/* 194 */     Map m = isQueue ? this.queueMap : this.topicMap;
/*     */ 
/* 196 */     ManagedDestination holder = (ManagedDestination)m.get(name);
/*     */ 
/* 198 */     return holder;
/*     */   }
/*     */ 
/*     */   public synchronized Set getDestinations()
/*     */   {
/* 203 */     Set destinations = new HashSet();
/*     */ 
/* 205 */     Iterator iter = this.queueMap.values().iterator();
/* 206 */     while (iter.hasNext())
/*     */     {
/* 208 */       ManagedDestination dest = (ManagedDestination)iter.next();
/* 209 */       if (dest.isTemporary())
/*     */       {
/* 211 */         destinations.add(new JBossTemporaryQueue(dest.getName()));
/*     */       }
/*     */       else
/*     */       {
/* 215 */         destinations.add(new JBossQueue(dest.getName()));
/*     */       }
/*     */     }
/*     */ 
/* 219 */     iter = this.topicMap.values().iterator();
/* 220 */     while (iter.hasNext())
/*     */     {
/* 222 */       ManagedDestination dest = (ManagedDestination)iter.next();
/* 223 */       if (dest.isTemporary())
/*     */       {
/* 225 */         destinations.add(new JBossTemporaryTopic(dest.getName()));
/*     */       }
/*     */       else
/*     */       {
/* 229 */         destinations.add(new JBossTopic(dest.getName()));
/*     */       }
/*     */     }
/*     */ 
/* 233 */     return destinations;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 240 */     this.initialContext = new InitialContext();
/*     */ 
/* 243 */     createContext(this.serverPeer.getDefaultQueueJNDIContext());
/* 244 */     createContext(this.serverPeer.getDefaultTopicJNDIContext());
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 249 */     Set queues = new HashSet(this.queueMap.values());
/*     */ 
/* 251 */     Set topics = new HashSet(this.topicMap.values());
/*     */ 
/* 254 */     for (Iterator i = queues.iterator(); i.hasNext(); )
/*     */     {
/* 256 */       unregisterDestination((ManagedDestination)i.next());
/*     */     }
/*     */ 
/* 259 */     for (Iterator i = topics.iterator(); i.hasNext(); )
/*     */     {
/* 261 */       unregisterDestination((ManagedDestination)i.next());
/*     */     }
/*     */ 
/* 264 */     this.initialContext.unbind(this.serverPeer.getDefaultQueueJNDIContext());
/* 265 */     this.initialContext.unbind(this.serverPeer.getDefaultTopicJNDIContext());
/*     */ 
/* 267 */     this.initialContext.close();
/*     */   }
/*     */ 
/*     */   private void createContext(String contextName)
/*     */     throws Exception
/*     */   {
/* 280 */     Object context = null;
/*     */     try
/*     */     {
/* 283 */       context = this.initialContext.lookup(contextName);
/*     */ 
/* 285 */       if (!(context instanceof Context))
/*     */       {
/* 287 */         throw new MessagingJMSException(contextName + " is already bound " + " and is not a JNDI context!");
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (NameNotFoundException e)
/*     */     {
/* 293 */       this.initialContext.createSubcontext(contextName);
/* 294 */       log.debug(contextName + " subcontext created");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.DestinationJNDIMapper
 * JD-Core Version:    0.6.0
 */