/*     */ package org.jboss.jms.recovery;
/*     */ 
/*     */ import javax.jms.ExceptionListener;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.XAConnection;
/*     */ import javax.jms.XAConnectionFactory;
/*     */ import javax.jms.XASession;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.transaction.xa.XAException;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import javax.transaction.xa.Xid;
/*     */ import org.jboss.jms.jndi.JMSProviderAdapter;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.naming.Util;
/*     */ 
/*     */ public class XAResourceWrapper
/*     */   implements XAResource, ExceptionListener
/*     */ {
/*  48 */   private static final Logger log = Logger.getLogger(XAResourceWrapper.class);
/*     */   private String providerName;
/*  54 */   private static final Object lock = new Object();
/*     */   private XAConnection connection;
/*     */   private XAResource delegate;
/*     */ 
/*     */   public String getProviderName()
/*     */   {
/*  69 */     return this.providerName;
/*     */   }
/*     */ 
/*     */   public void setProviderName(String providerName)
/*     */   {
/*  79 */     this.providerName = providerName;
/*     */   }
/*     */ 
/*     */   public Xid[] recover(int flag) throws XAException
/*     */   {
/*  84 */     log.debug("Recover " + this.providerName);
/*  85 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/*  88 */       return xaResource.recover(flag);
/*     */     }
/*     */     catch (XAException e) {
/*     */     }
/*  92 */     throw check(e);
/*     */   }
/*     */ 
/*     */   public void commit(Xid xid, boolean onePhase)
/*     */     throws XAException
/*     */   {
/*  98 */     log.debug("Commit " + this.providerName + " xid " + " onePhase=" + onePhase);
/*  99 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 102 */       xaResource.commit(xid, onePhase);
/*     */     }
/*     */     catch (XAException e)
/*     */     {
/* 106 */       throw check(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void rollback(Xid xid) throws XAException
/*     */   {
/* 112 */     log.debug("Rollback " + this.providerName + " xid ");
/* 113 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 116 */       xaResource.rollback(xid);
/*     */     }
/*     */     catch (XAException e)
/*     */     {
/* 120 */       throw check(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void forget(Xid xid) throws XAException
/*     */   {
/* 126 */     log.debug("Forget " + this.providerName + " xid ");
/* 127 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 130 */       xaResource.forget(xid);
/*     */     }
/*     */     catch (XAException e)
/*     */     {
/* 134 */       throw check(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isSameRM(XAResource xaRes) throws XAException
/*     */   {
/* 140 */     if ((xaRes instanceof XAResourceWrapper)) {
/* 141 */       xaRes = ((XAResourceWrapper)xaRes).getDelegate();
/*     */     }
/* 143 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 146 */       return xaResource.isSameRM(xaRes);
/*     */     }
/*     */     catch (XAException e) {
/*     */     }
/* 150 */     throw check(e);
/*     */   }
/*     */ 
/*     */   public int prepare(Xid xid)
/*     */     throws XAException
/*     */   {
/* 156 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 159 */       return xaResource.prepare(xid);
/*     */     }
/*     */     catch (XAException e) {
/*     */     }
/* 163 */     throw check(e);
/*     */   }
/*     */ 
/*     */   public void start(Xid xid, int flags)
/*     */     throws XAException
/*     */   {
/* 169 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 172 */       xaResource.start(xid, flags);
/*     */     }
/*     */     catch (XAException e)
/*     */     {
/* 176 */       throw check(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void end(Xid xid, int flags) throws XAException
/*     */   {
/* 182 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 185 */       xaResource.end(xid, flags);
/*     */     }
/*     */     catch (XAException e)
/*     */     {
/* 189 */       throw check(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getTransactionTimeout() throws XAException
/*     */   {
/* 195 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 198 */       return xaResource.getTransactionTimeout();
/*     */     }
/*     */     catch (XAException e) {
/*     */     }
/* 202 */     throw check(e);
/*     */   }
/*     */ 
/*     */   public boolean setTransactionTimeout(int seconds)
/*     */     throws XAException
/*     */   {
/* 208 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 211 */       return xaResource.setTransactionTimeout(seconds);
/*     */     }
/*     */     catch (XAException e) {
/*     */     }
/* 215 */     throw check(e);
/*     */   }
/*     */ 
/*     */   public void onException(JMSException exception)
/*     */   {
/* 221 */     log.warn("Notified of connection failure in recovery delegate for provider " + this.providerName, exception);
/* 222 */     close();
/*     */   }
/*     */ 
/*     */   public XAResource getDelegate()
/*     */     throws XAException
/*     */   {
/* 233 */     XAResource result = null;
/* 234 */     Exception error = null;
/*     */     try
/*     */     {
/* 237 */       result = connect();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 241 */       error = e;
/*     */     }
/*     */ 
/* 244 */     if (result == null)
/*     */     {
/* 246 */       XAException xae = new XAException("Error trying to connect to provider " + this.providerName);
/* 247 */       xae.errorCode = -3;
/* 248 */       if (error != null)
/* 249 */         xae.initCause(error);
/* 250 */       log.debug("Cannot get delegate XAResource", xae);
/* 251 */       throw xae;
/*     */     }
/*     */ 
/* 254 */     return result;
/*     */   }
/*     */ 
/*     */   protected XAResource connect()
/*     */     throws Exception
/*     */   {
/* 266 */     synchronized (lock)
/*     */     {
/* 268 */       if (this.delegate != null) {
/* 269 */         return this.delegate;
/*     */       }
/*     */     }
/*     */ 
/* 273 */     XAConnection xaConnection = getConnectionFactory().createXAConnection();
/* 274 */     synchronized (lock)
/*     */     {
/* 276 */       this.connection = xaConnection;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 282 */       XASession session = this.connection.createXASession();
/* 283 */       XAResource result = session.getXAResource();
/* 284 */       synchronized (lock)
/*     */       {
/* 286 */         this.delegate = result;
/*     */       }
/* 288 */       return this.delegate;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 292 */       close();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected XAConnectionFactory getConnectionFactory()
/*     */     throws Exception
/*     */   {
/* 306 */     if (this.providerName == null)
/* 307 */       throw new IllegalArgumentException("Null provider name");
/* 308 */     String providerAdapterJNDI = this.providerName;
/* 309 */     if (!providerAdapterJNDI.startsWith("java:"))
/* 310 */       providerAdapterJNDI = "java:" + providerAdapterJNDI;
/* 311 */     Context ctx = new InitialContext();
/* 312 */     JMSProviderAdapter adapter = (JMSProviderAdapter)Util.lookup(providerAdapterJNDI, JMSProviderAdapter.class);
/*     */ 
/* 315 */     String connectionFactoryRef = adapter.getFactoryRef();
/* 316 */     if (connectionFactoryRef == null) {
/* 317 */       throw new IllegalStateException("Provider '" + this.providerName + "' has no FactoryRef");
/*     */     }
/*     */ 
/* 320 */     ctx = adapter.getInitialContext();
/*     */     try
/*     */     {
/* 323 */       localXAConnectionFactory = (XAConnectionFactory)Util.lookup(ctx, connectionFactoryRef, XAConnectionFactory.class);
/*     */     }
/*     */     finally
/*     */     {
/*     */       XAConnectionFactory localXAConnectionFactory;
/* 327 */       ctx.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void close()
/*     */   {
/*     */     try
/*     */     {
/* 338 */       XAConnection oldConnection = null;
/* 339 */       synchronized (lock)
/*     */       {
/* 341 */         oldConnection = this.connection;
/* 342 */         this.connection = null;
/* 343 */         this.delegate = null;
/*     */       }
/* 345 */       if (oldConnection != null)
/* 346 */         oldConnection.close();
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/* 350 */       log.trace("Ignored error during close", ignored);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected XAException check(XAException e)
/*     */     throws XAException
/*     */   {
/* 364 */     if ((e.errorCode == -3) || (e.errorCode == -7))
/*     */     {
/* 366 */       log.debug("Fatal error in provider " + this.providerName, e);
/* 367 */       close();
/*     */     }
/* 369 */     throw e;
/*     */   }
/*     */ 
/*     */   protected void finalize() throws Throwable
/*     */   {
/* 374 */     close();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.recovery.XAResourceWrapper
 * JD-Core Version:    0.6.0
 */