/*     */ package org.jboss.jms.message;
/*     */ 
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.MessageNotReadableException;
/*     */ import javax.jms.MessageNotWriteableException;
/*     */ import javax.jms.StreamMessage;
/*     */ 
/*     */ public class StreamMessageProxy extends MessageProxy
/*     */   implements StreamMessage
/*     */ {
/*     */   private static final long serialVersionUID = 856367553964704474L;
/*     */ 
/*     */   public StreamMessageProxy(long deliveryId, JBossStreamMessage message, int deliveryCount)
/*     */   {
/*  43 */     super(deliveryId, message, deliveryCount);
/*     */   }
/*     */ 
/*     */   public StreamMessageProxy(JBossStreamMessage message)
/*     */   {
/*  48 */     super(message);
/*     */   }
/*     */ 
/*     */   public boolean readBoolean() throws JMSException
/*     */   {
/*  53 */     if (!this.bodyReadOnly) {
/*  54 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/*  56 */     return ((StreamMessage)this.message).readBoolean();
/*     */   }
/*     */ 
/*     */   public byte readByte() throws JMSException
/*     */   {
/*  61 */     if (!this.bodyReadOnly) {
/*  62 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/*  64 */     return ((StreamMessage)this.message).readByte();
/*     */   }
/*     */ 
/*     */   public int readBytes(byte[] value) throws JMSException
/*     */   {
/*  69 */     if (!this.bodyReadOnly) {
/*  70 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/*  72 */     return ((StreamMessage)this.message).readBytes(value);
/*     */   }
/*     */ 
/*     */   public char readChar() throws JMSException
/*     */   {
/*  77 */     if (!this.bodyReadOnly) {
/*  78 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/*  80 */     return ((StreamMessage)this.message).readChar();
/*     */   }
/*     */ 
/*     */   public double readDouble() throws JMSException
/*     */   {
/*  85 */     if (!this.bodyReadOnly) {
/*  86 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/*  88 */     return ((StreamMessage)this.message).readDouble();
/*     */   }
/*     */ 
/*     */   public float readFloat() throws JMSException
/*     */   {
/*  93 */     if (!this.bodyReadOnly) {
/*  94 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/*  96 */     return ((StreamMessage)this.message).readFloat();
/*     */   }
/*     */ 
/*     */   public int readInt() throws JMSException
/*     */   {
/* 101 */     if (!this.bodyReadOnly) {
/* 102 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 104 */     return ((StreamMessage)this.message).readInt();
/*     */   }
/*     */ 
/*     */   public long readLong() throws JMSException
/*     */   {
/* 109 */     if (!this.bodyReadOnly) {
/* 110 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 112 */     return ((StreamMessage)this.message).readLong();
/*     */   }
/*     */ 
/*     */   public Object readObject() throws JMSException
/*     */   {
/* 117 */     if (!this.bodyReadOnly) {
/* 118 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 120 */     return ((StreamMessage)this.message).readObject();
/*     */   }
/*     */ 
/*     */   public short readShort() throws JMSException
/*     */   {
/* 125 */     if (!this.bodyReadOnly) {
/* 126 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 128 */     return ((StreamMessage)this.message).readShort();
/*     */   }
/*     */ 
/*     */   public String readString() throws JMSException
/*     */   {
/* 133 */     if (!this.bodyReadOnly) {
/* 134 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 136 */     return ((StreamMessage)this.message).readString();
/*     */   }
/*     */ 
/*     */   public void reset() throws JMSException
/*     */   {
/* 141 */     this.bodyReadOnly = true;
/* 142 */     ((StreamMessage)this.message).reset();
/*     */   }
/*     */ 
/*     */   public void writeBoolean(boolean value) throws JMSException
/*     */   {
/* 147 */     if (this.bodyReadOnly)
/* 148 */       throw new MessageNotWriteableException("The message body is readonly");
/* 149 */     bodyChange();
/* 150 */     ((StreamMessage)this.message).writeBoolean(value);
/*     */   }
/*     */ 
/*     */   public void writeByte(byte value) throws JMSException
/*     */   {
/* 155 */     if (this.bodyReadOnly)
/* 156 */       throw new MessageNotWriteableException("The message body is readonly");
/* 157 */     bodyChange();
/* 158 */     ((StreamMessage)this.message).writeByte(value);
/*     */   }
/*     */ 
/*     */   public void writeBytes(byte[] value) throws JMSException
/*     */   {
/* 163 */     if (this.bodyReadOnly)
/* 164 */       throw new MessageNotWriteableException("The message body is readonly");
/* 165 */     bodyChange();
/* 166 */     ((StreamMessage)this.message).writeBytes(value);
/*     */   }
/*     */ 
/*     */   public void writeBytes(byte[] value, int offset, int length) throws JMSException
/*     */   {
/* 171 */     if (this.bodyReadOnly)
/* 172 */       throw new MessageNotWriteableException("The message body is readonly");
/* 173 */     bodyChange();
/* 174 */     ((StreamMessage)this.message).writeBytes(value, offset, length);
/*     */   }
/*     */ 
/*     */   public void writeChar(char value) throws JMSException
/*     */   {
/* 179 */     if (this.bodyReadOnly)
/* 180 */       throw new MessageNotWriteableException("The message body is readonly");
/* 181 */     bodyChange();
/* 182 */     ((StreamMessage)this.message).writeChar(value);
/*     */   }
/*     */ 
/*     */   public void writeDouble(double value) throws JMSException
/*     */   {
/* 187 */     if (this.bodyReadOnly)
/* 188 */       throw new MessageNotWriteableException("The message body is readonly");
/* 189 */     bodyChange();
/* 190 */     ((StreamMessage)this.message).writeDouble(value);
/*     */   }
/*     */ 
/*     */   public void writeFloat(float value) throws JMSException
/*     */   {
/* 195 */     if (this.bodyReadOnly)
/* 196 */       throw new MessageNotWriteableException("The message body is readonly");
/* 197 */     bodyChange();
/* 198 */     ((StreamMessage)this.message).writeFloat(value);
/*     */   }
/*     */ 
/*     */   public void writeInt(int value) throws JMSException
/*     */   {
/* 203 */     if (this.bodyReadOnly)
/* 204 */       throw new MessageNotWriteableException("The message body is readonly");
/* 205 */     bodyChange();
/* 206 */     ((StreamMessage)this.message).writeInt(value);
/*     */   }
/*     */ 
/*     */   public void writeLong(long value) throws JMSException
/*     */   {
/* 211 */     if (this.bodyReadOnly)
/* 212 */       throw new MessageNotWriteableException("The message body is readonly");
/* 213 */     bodyChange();
/* 214 */     ((StreamMessage)this.message).writeLong(value);
/*     */   }
/*     */ 
/*     */   public void writeObject(Object value) throws JMSException
/*     */   {
/* 219 */     if (this.bodyReadOnly)
/* 220 */       throw new MessageNotWriteableException("The message body is readonly");
/* 221 */     bodyChange();
/* 222 */     ((StreamMessage)this.message).writeObject(value);
/*     */   }
/*     */ 
/*     */   public void writeShort(short value) throws JMSException
/*     */   {
/* 227 */     if (this.bodyReadOnly)
/* 228 */       throw new MessageNotWriteableException("The message body is readonly");
/* 229 */     bodyChange();
/* 230 */     ((StreamMessage)this.message).writeShort(value);
/*     */   }
/*     */ 
/*     */   public void writeString(String value) throws JMSException
/*     */   {
/* 235 */     if (this.bodyReadOnly)
/* 236 */       throw new MessageNotWriteableException("The message body is readonly");
/* 237 */     bodyChange();
/* 238 */     ((StreamMessage)this.message).writeString(value);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.message.StreamMessageProxy
 * JD-Core Version:    0.6.0
 */