/*     */ package org.jboss.jms.message;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Enumeration;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.MessageNotWriteableException;
/*     */ import org.jboss.jms.delegate.SessionDelegate;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class MessageProxy
/*     */   implements Message, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 5903095946142192468L;
/*  60 */   protected Logger log = Logger.getLogger(MessageProxy.class);
/*     */   private transient SessionDelegate delegate;
/*     */   private transient boolean cc;
/*     */   private int deliveryCount;
/*     */   private long deliveryId;
/*     */   private transient boolean needToCopyHeader;
/*     */   private transient boolean needToCopyBody;
/*     */   private transient boolean propertiesReadOnly;
/*     */   protected transient boolean bodyReadOnly;
/*     */   protected JBossMessage message;
/*     */ 
/*     */   public void beforeSend()
/*     */   {
/*  83 */     this.needToCopyHeader = true;
/*     */ 
/*  85 */     this.needToCopyBody = true;
/*     */ 
/*  87 */     this.propertiesReadOnly = false;
/*     */ 
/*  89 */     this.bodyReadOnly = false;
/*     */   }
/*     */ 
/*     */   public MessageProxy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public MessageProxy(JBossMessage message)
/*     */   {
/* 110 */     this.message = message;
/*     */ 
/* 112 */     this.needToCopyHeader = false;
/*     */ 
/* 114 */     this.needToCopyBody = false;
/*     */   }
/*     */ 
/*     */   public MessageProxy(long deliveryId, JBossMessage message, int deliveryCount)
/*     */   {
/* 122 */     this.deliveryId = deliveryId;
/*     */ 
/* 124 */     this.message = message;
/*     */ 
/* 126 */     this.deliveryCount = deliveryCount;
/*     */ 
/* 128 */     this.needToCopyHeader = true;
/*     */ 
/* 130 */     this.needToCopyBody = true;
/*     */ 
/* 132 */     this.propertiesReadOnly = true;
/*     */ 
/* 134 */     this.bodyReadOnly = true;
/*     */   }
/*     */ 
/*     */   public String getJMSMessageID()
/*     */     throws JMSException
/*     */   {
/* 141 */     return this.message.getJMSMessageID();
/*     */   }
/*     */ 
/*     */   public void setJMSMessageID(String id) throws JMSException
/*     */   {
/* 146 */     headerChange();
/* 147 */     this.message.setJMSMessageID(id);
/*     */   }
/*     */ 
/*     */   public long getJMSTimestamp() throws JMSException
/*     */   {
/* 152 */     return this.message.getJMSTimestamp();
/*     */   }
/*     */ 
/*     */   public void setJMSTimestamp(long timestamp) throws JMSException
/*     */   {
/* 157 */     headerChange();
/* 158 */     this.message.setJMSTimestamp(timestamp);
/*     */   }
/*     */ 
/*     */   public byte[] getJMSCorrelationIDAsBytes() throws JMSException
/*     */   {
/* 163 */     return this.message.getJMSCorrelationIDAsBytes();
/*     */   }
/*     */ 
/*     */   public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException
/*     */   {
/* 168 */     headerChange();
/* 169 */     this.message.setJMSCorrelationIDAsBytes(correlationID);
/*     */   }
/*     */ 
/*     */   public void setJMSCorrelationID(String correlationID) throws JMSException
/*     */   {
/* 174 */     headerChange();
/* 175 */     this.message.setJMSCorrelationID(correlationID);
/*     */   }
/*     */ 
/*     */   public String getJMSCorrelationID() throws JMSException
/*     */   {
/* 180 */     return this.message.getJMSCorrelationID();
/*     */   }
/*     */ 
/*     */   public Destination getJMSReplyTo() throws JMSException
/*     */   {
/* 185 */     return this.message.getJMSReplyTo();
/*     */   }
/*     */ 
/*     */   public void setJMSReplyTo(Destination replyTo) throws JMSException
/*     */   {
/* 190 */     headerChange();
/* 191 */     this.message.setJMSReplyTo(replyTo);
/*     */   }
/*     */ 
/*     */   public Destination getJMSDestination() throws JMSException
/*     */   {
/* 196 */     return this.message.getJMSDestination();
/*     */   }
/*     */ 
/*     */   public void setJMSDestination(Destination destination) throws JMSException
/*     */   {
/* 201 */     headerChange();
/* 202 */     this.message.setJMSDestination(destination);
/*     */   }
/*     */ 
/*     */   public int getJMSDeliveryMode() throws JMSException
/*     */   {
/* 207 */     return this.message.getJMSDeliveryMode();
/*     */   }
/*     */ 
/*     */   public void setJMSDeliveryMode(int deliveryMode) throws JMSException
/*     */   {
/* 212 */     headerChange();
/* 213 */     this.message.setJMSDeliveryMode(deliveryMode);
/*     */   }
/*     */ 
/*     */   public boolean getJMSRedelivered()
/*     */     throws JMSException
/*     */   {
/* 223 */     return this.deliveryCount >= 2;
/*     */   }
/*     */ 
/*     */   public void setJMSRedelivered(boolean redelivered)
/*     */     throws JMSException
/*     */   {
/* 229 */     if (this.deliveryCount == 1)
/*     */     {
/* 231 */       this.deliveryCount += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getJMSType()
/*     */     throws JMSException
/*     */   {
/* 241 */     return this.message.getJMSType();
/*     */   }
/*     */ 
/*     */   public void setJMSType(String type) throws JMSException
/*     */   {
/* 246 */     headerChange();
/* 247 */     this.message.setJMSType(type);
/*     */   }
/*     */ 
/*     */   public long getJMSExpiration() throws JMSException
/*     */   {
/* 252 */     return this.message.getJMSExpiration();
/*     */   }
/*     */ 
/*     */   public void setJMSExpiration(long expiration) throws JMSException
/*     */   {
/* 257 */     headerChange();
/* 258 */     this.message.setJMSExpiration(expiration);
/*     */   }
/*     */ 
/*     */   public int getJMSPriority() throws JMSException
/*     */   {
/* 263 */     return this.message.getJMSPriority();
/*     */   }
/*     */ 
/*     */   public void setJMSPriority(int priority) throws JMSException
/*     */   {
/* 268 */     headerChange();
/* 269 */     this.message.setJMSPriority(priority);
/*     */   }
/*     */ 
/*     */   public void clearProperties() throws JMSException
/*     */   {
/* 274 */     headerChange();
/* 275 */     this.message.clearProperties();
/* 276 */     this.propertiesReadOnly = false;
/*     */   }
/*     */ 
/*     */   public boolean propertyExists(String name) throws JMSException
/*     */   {
/* 281 */     return this.message.propertyExists(name);
/*     */   }
/*     */ 
/*     */   public boolean getBooleanProperty(String name) throws JMSException
/*     */   {
/* 286 */     return this.message.getBooleanProperty(name);
/*     */   }
/*     */ 
/*     */   public byte getByteProperty(String name) throws JMSException
/*     */   {
/* 291 */     return this.message.getByteProperty(name);
/*     */   }
/*     */ 
/*     */   public short getShortProperty(String name) throws JMSException
/*     */   {
/* 296 */     return this.message.getShortProperty(name);
/*     */   }
/*     */ 
/*     */   public int getIntProperty(String name)
/*     */     throws JMSException
/*     */   {
/* 302 */     if ("JMSXDeliveryCount".equals(name))
/*     */     {
/* 304 */       return this.deliveryCount;
/*     */     }
/* 306 */     return this.message.getIntProperty(name);
/*     */   }
/*     */ 
/*     */   public long getLongProperty(String name)
/*     */     throws JMSException
/*     */   {
/* 312 */     if ("JMSXDeliveryCount".equals(name))
/*     */     {
/* 314 */       return this.deliveryCount;
/*     */     }
/* 316 */     return this.message.getLongProperty(name);
/*     */   }
/*     */ 
/*     */   public float getFloatProperty(String name) throws JMSException
/*     */   {
/* 321 */     return this.message.getFloatProperty(name);
/*     */   }
/*     */ 
/*     */   public double getDoubleProperty(String name) throws JMSException
/*     */   {
/* 326 */     return this.message.getDoubleProperty(name);
/*     */   }
/*     */ 
/*     */   public String getStringProperty(String name)
/*     */     throws JMSException
/*     */   {
/* 332 */     if ("JMSXDeliveryCount".equals(name))
/*     */     {
/* 334 */       return Integer.toString(this.deliveryCount);
/*     */     }
/* 336 */     return this.message.getStringProperty(name);
/*     */   }
/*     */ 
/*     */   public Object getObjectProperty(String name) throws JMSException
/*     */   {
/* 341 */     return this.message.getObjectProperty(name);
/*     */   }
/*     */ 
/*     */   public Enumeration getPropertyNames() throws JMSException
/*     */   {
/* 346 */     return this.message.getPropertyNames();
/*     */   }
/*     */ 
/*     */   public void setBooleanProperty(String name, boolean value) throws JMSException
/*     */   {
/* 351 */     if (this.propertiesReadOnly)
/* 352 */       throw new MessageNotWriteableException("Properties are read-only");
/* 353 */     headerChange();
/* 354 */     this.message.setBooleanProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setByteProperty(String name, byte value) throws JMSException
/*     */   {
/* 359 */     if (this.propertiesReadOnly)
/* 360 */       throw new MessageNotWriteableException("Properties are read-only");
/* 361 */     headerChange();
/* 362 */     this.message.setByteProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setShortProperty(String name, short value) throws JMSException
/*     */   {
/* 367 */     if (this.propertiesReadOnly)
/* 368 */       throw new MessageNotWriteableException("Properties are read-only");
/* 369 */     headerChange();
/* 370 */     this.message.setShortProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setIntProperty(String name, int value) throws JMSException
/*     */   {
/* 375 */     if (this.propertiesReadOnly)
/* 376 */       throw new MessageNotWriteableException("Properties are read-only");
/* 377 */     headerChange();
/* 378 */     this.message.setIntProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setLongProperty(String name, long value) throws JMSException
/*     */   {
/* 383 */     if (this.propertiesReadOnly)
/* 384 */       throw new MessageNotWriteableException("Properties are read-only");
/* 385 */     headerChange();
/* 386 */     this.message.setLongProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setFloatProperty(String name, float value) throws JMSException
/*     */   {
/* 391 */     if (this.propertiesReadOnly)
/* 392 */       throw new MessageNotWriteableException("Properties are read-only");
/* 393 */     headerChange();
/* 394 */     this.message.setFloatProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setDoubleProperty(String name, double value) throws JMSException
/*     */   {
/* 399 */     if (this.propertiesReadOnly)
/* 400 */       throw new MessageNotWriteableException("Properties are read-only");
/* 401 */     headerChange();
/* 402 */     this.message.setDoubleProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setStringProperty(String name, String value) throws JMSException
/*     */   {
/* 407 */     if (this.propertiesReadOnly)
/* 408 */       throw new MessageNotWriteableException("Properties are read-only");
/* 409 */     headerChange();
/* 410 */     this.message.setStringProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void setObjectProperty(String name, Object value) throws JMSException
/*     */   {
/* 415 */     if (this.propertiesReadOnly)
/* 416 */       throw new MessageNotWriteableException("Properties are read-only");
/* 417 */     headerChange();
/* 418 */     this.message.setObjectProperty(name, value);
/*     */   }
/*     */ 
/*     */   public void acknowledge() throws JMSException
/*     */   {
/* 423 */     if (!this.cc)
/*     */     {
/* 426 */       this.delegate.acknowledgeAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void clearBody() throws JMSException
/*     */   {
/* 432 */     bodyChange();
/* 433 */     this.message.clearBody();
/* 434 */     this.bodyReadOnly = false;
/*     */   }
/*     */ 
/*     */   public void setSessionDelegate(SessionDelegate sd, boolean isConnectionConsumer)
/*     */   {
/* 442 */     this.delegate = sd;
/* 443 */     this.cc = isConnectionConsumer;
/*     */   }
/*     */ 
/*     */   public SessionDelegate getSessionDelegate()
/*     */   {
/* 448 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public JBossMessage getMessage()
/*     */   {
/* 453 */     return this.message;
/*     */   }
/*     */ 
/*     */   public int getDeliveryCount()
/*     */   {
/* 458 */     return this.deliveryCount;
/*     */   }
/*     */ 
/*     */   public void incDeliveryCount()
/*     */   {
/* 463 */     this.deliveryCount += 1;
/*     */   }
/*     */ 
/*     */   public long getDeliveryId()
/*     */   {
/* 468 */     return this.deliveryId;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 473 */     return "delegator->" + this.message + ", deliveryId=" + this.deliveryId;
/*     */   }
/*     */ 
/*     */   protected void headerChange()
/*     */     throws JMSException
/*     */   {
/* 482 */     if (this.needToCopyHeader)
/*     */     {
/* 484 */       copyMessage();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bodyChange() throws JMSException
/*     */   {
/* 490 */     if (this.needToCopyBody)
/*     */     {
/* 492 */       headerChange();
/*     */ 
/* 494 */       this.message.copyPayload(this.message.getPayload());
/*     */ 
/* 496 */       this.needToCopyBody = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void copyMessage()
/*     */     throws JMSException
/*     */   {
/* 504 */     this.message = this.message.doCopy();
/*     */ 
/* 506 */     this.needToCopyHeader = false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.message.MessageProxy
 * JD-Core Version:    0.6.0
 */