/*     */ package org.jboss.jms.message;
/*     */ 
/*     */ import java.util.Enumeration;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.MapMessage;
/*     */ import javax.jms.MessageNotWriteableException;
/*     */ 
/*     */ public class MapMessageProxy extends MessageProxy
/*     */   implements MapMessage
/*     */ {
/*     */   private static final long serialVersionUID = 6953530870351885569L;
/*     */ 
/*     */   public MapMessageProxy(long deliveryId, JBossMapMessage message, int deliveryCount)
/*     */   {
/*  44 */     super(deliveryId, message, deliveryCount);
/*     */   }
/*     */ 
/*     */   public MapMessageProxy(JBossMapMessage message)
/*     */   {
/*  49 */     super(message);
/*     */   }
/*     */ 
/*     */   public boolean getBoolean(String name) throws JMSException
/*     */   {
/*  54 */     return ((MapMessage)this.message).getBoolean(name);
/*     */   }
/*     */ 
/*     */   public byte getByte(String name) throws JMSException
/*     */   {
/*  59 */     return ((MapMessage)this.message).getByte(name);
/*     */   }
/*     */ 
/*     */   public short getShort(String name) throws JMSException
/*     */   {
/*  64 */     return ((MapMessage)this.message).getShort(name);
/*     */   }
/*     */ 
/*     */   public char getChar(String name) throws JMSException
/*     */   {
/*  69 */     return ((MapMessage)this.message).getChar(name);
/*     */   }
/*     */ 
/*     */   public int getInt(String name) throws JMSException
/*     */   {
/*  74 */     return ((MapMessage)this.message).getInt(name);
/*     */   }
/*     */ 
/*     */   public long getLong(String name) throws JMSException
/*     */   {
/*  79 */     return ((MapMessage)this.message).getLong(name);
/*     */   }
/*     */ 
/*     */   public float getFloat(String name) throws JMSException
/*     */   {
/*  84 */     return ((MapMessage)this.message).getFloat(name);
/*     */   }
/*     */ 
/*     */   public double getDouble(String name) throws JMSException
/*     */   {
/*  89 */     return ((MapMessage)this.message).getDouble(name);
/*     */   }
/*     */ 
/*     */   public String getString(String name) throws JMSException
/*     */   {
/*  94 */     return ((MapMessage)this.message).getString(name);
/*     */   }
/*     */ 
/*     */   public byte[] getBytes(String name) throws JMSException
/*     */   {
/*  99 */     return ((MapMessage)this.message).getBytes(name);
/*     */   }
/*     */ 
/*     */   public Object getObject(String name) throws JMSException
/*     */   {
/* 104 */     return ((MapMessage)this.message).getObject(name);
/*     */   }
/*     */ 
/*     */   public Enumeration getMapNames() throws JMSException
/*     */   {
/* 109 */     return ((MapMessage)this.message).getMapNames();
/*     */   }
/*     */ 
/*     */   public void setBoolean(String name, boolean value) throws JMSException
/*     */   {
/* 114 */     if (this.bodyReadOnly)
/*     */     {
/* 116 */       throw new MessageNotWriteableException("Message is ReadOnly !");
/*     */     }
/* 118 */     bodyChange();
/* 119 */     ((MapMessage)this.message).setBoolean(name, value);
/*     */   }
/*     */ 
/*     */   public void setByte(String name, byte value) throws JMSException
/*     */   {
/* 124 */     if (this.bodyReadOnly)
/*     */     {
/* 126 */       throw new MessageNotWriteableException("Message is ReadOnly !");
/*     */     }
/* 128 */     bodyChange();
/* 129 */     ((MapMessage)this.message).setByte(name, value);
/*     */   }
/*     */ 
/*     */   public void setShort(String name, short value) throws JMSException
/*     */   {
/* 134 */     if (this.bodyReadOnly)
/*     */     {
/* 136 */       throw new MessageNotWriteableException("Message is ReadOnly !");
/*     */     }
/* 138 */     bodyChange();
/* 139 */     ((MapMessage)this.message).setShort(name, value);
/*     */   }
/*     */ 
/*     */   public void setChar(String name, char value) throws JMSException
/*     */   {
/* 144 */     if (this.bodyReadOnly)
/*     */     {
/* 146 */       throw new MessageNotWriteableException("Message is ReadOnly !");
/*     */     }
/* 148 */     bodyChange();
/* 149 */     ((MapMessage)this.message).setChar(name, value);
/*     */   }
/*     */ 
/*     */   public void setInt(String name, int value) throws JMSException
/*     */   {
/* 154 */     if (this.bodyReadOnly)
/*     */     {
/* 156 */       throw new MessageNotWriteableException("Message is ReadOnly !");
/*     */     }
/* 158 */     bodyChange();
/* 159 */     ((MapMessage)this.message).setInt(name, value);
/*     */   }
/*     */ 
/*     */   public void setLong(String name, long value) throws JMSException
/*     */   {
/* 164 */     if (this.bodyReadOnly)
/*     */     {
/* 166 */       throw new MessageNotWriteableException("Message is ReadOnly !");
/*     */     }
/* 168 */     bodyChange();
/* 169 */     ((MapMessage)this.message).setLong(name, value);
/*     */   }
/*     */ 
/*     */   public void setFloat(String name, float value) throws JMSException
/*     */   {
/* 174 */     if (this.bodyReadOnly)
/*     */     {
/* 176 */       throw new MessageNotWriteableException("Message is ReadOnly !");
/*     */     }
/* 178 */     bodyChange();
/* 179 */     ((MapMessage)this.message).setFloat(name, value);
/*     */   }
/*     */ 
/*     */   public void setDouble(String name, double value) throws JMSException
/*     */   {
/* 184 */     if (this.bodyReadOnly)
/*     */     {
/* 186 */       throw new MessageNotWriteableException("Message is ReadOnly !");
/*     */     }
/* 188 */     bodyChange();
/* 189 */     ((MapMessage)this.message).setDouble(name, value);
/*     */   }
/*     */ 
/*     */   public void setString(String name, String value) throws JMSException
/*     */   {
/* 194 */     if (this.bodyReadOnly)
/*     */     {
/* 196 */       throw new MessageNotWriteableException("Message is ReadOnly !");
/*     */     }
/* 198 */     bodyChange();
/* 199 */     ((MapMessage)this.message).setString(name, value);
/*     */   }
/*     */ 
/*     */   public void setBytes(String name, byte[] value) throws JMSException
/*     */   {
/* 204 */     if (this.bodyReadOnly)
/*     */     {
/* 206 */       throw new MessageNotWriteableException("Message is ReadOnly !");
/*     */     }
/* 208 */     bodyChange();
/* 209 */     ((MapMessage)this.message).setBytes(name, value);
/*     */   }
/*     */ 
/*     */   public void setBytes(String name, byte[] value, int offset, int length) throws JMSException
/*     */   {
/* 214 */     if (this.bodyReadOnly)
/*     */     {
/* 216 */       throw new MessageNotWriteableException("Message is ReadOnly !");
/*     */     }
/* 218 */     bodyChange();
/* 219 */     ((MapMessage)this.message).setBytes(name, value, offset, length);
/*     */   }
/*     */ 
/*     */   public void setObject(String name, Object value) throws JMSException
/*     */   {
/* 224 */     if (this.bodyReadOnly)
/*     */     {
/* 226 */       throw new MessageNotWriteableException("Message is ReadOnly !");
/*     */     }
/* 228 */     bodyChange();
/* 229 */     ((MapMessage)this.message).setObject(name, value);
/*     */   }
/*     */ 
/*     */   public boolean itemExists(String name) throws JMSException
/*     */   {
/* 234 */     return ((MapMessage)this.message).itemExists(name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.message.MapMessageProxy
 * JD-Core Version:    0.6.0
 */