/*     */ package org.jboss.jms.message;
/*     */ 
/*     */ import java.util.Map;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.TextMessage;
/*     */ 
/*     */ public class JBossTextMessage extends JBossMessage
/*     */   implements TextMessage
/*     */ {
/*     */   private static final long serialVersionUID = -5661567664746852006L;
/*     */   public static final byte TYPE = 3;
/*     */ 
/*     */   public JBossTextMessage()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JBossTextMessage(long messageID)
/*     */   {
/*  68 */     super(messageID);
/*     */   }
/*     */ 
/*     */   public JBossTextMessage(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map coreHeaders, byte[] payloadAsByteArray)
/*     */   {
/*  77 */     super(messageID, reliable, expiration, timestamp, priority, coreHeaders, payloadAsByteArray);
/*     */   }
/*     */ 
/*     */   public JBossTextMessage(JBossTextMessage other)
/*     */   {
/*  88 */     super(other);
/*     */   }
/*     */ 
/*     */   public JBossTextMessage(TextMessage foreign, long id)
/*     */     throws JMSException
/*     */   {
/*  96 */     super(foreign, id);
/*  97 */     String text = foreign.getText();
/*  98 */     if (text != null)
/*     */     {
/* 100 */       setText(text);
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte getType()
/*     */   {
/* 109 */     return 3;
/*     */   }
/*     */ 
/*     */   public void setText(String string)
/*     */     throws JMSException
/*     */   {
/* 116 */     this.payload = string;
/* 117 */     this.payloadAsByteArray = null;
/*     */   }
/*     */ 
/*     */   public String getText() throws JMSException
/*     */   {
/* 122 */     return (String)getPayload();
/*     */   }
/*     */ 
/*     */   public JBossMessage doCopy()
/*     */   {
/* 129 */     return new JBossTextMessage(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.message.JBossTextMessage
 * JD-Core Version:    0.6.0
 */