/*     */ package org.jboss.jms.message;
/*     */ 
/*     */ import B;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.MessageEOFException;
/*     */ import javax.jms.MessageFormatException;
/*     */ import javax.jms.StreamMessage;
/*     */ import org.jboss.util.Primitives;
/*     */ 
/*     */ public class JBossStreamMessage extends JBossMessage
/*     */   implements StreamMessage
/*     */ {
/*     */   private static final long serialVersionUID = 7469150228071568233L;
/*     */   public static final byte TYPE = 6;
/*     */   protected transient int position;
/*     */   protected transient int offset;
/*     */   protected int size;
/*     */ 
/*     */   public JBossStreamMessage()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JBossStreamMessage(long messageID)
/*     */   {
/*  82 */     super(messageID);
/*  83 */     this.payload = new ArrayList();
/*  84 */     this.position = 0;
/*  85 */     this.size = 0;
/*  86 */     this.offset = 0;
/*     */   }
/*     */ 
/*     */   public JBossStreamMessage(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map coreHeaders, byte[] payloadAsByteArray)
/*     */   {
/*  95 */     super(messageID, reliable, expiration, timestamp, priority, coreHeaders, payloadAsByteArray);
/*     */   }
/*     */ 
/*     */   public JBossStreamMessage(JBossStreamMessage other)
/*     */   {
/* 106 */     super(other);
/*     */   }
/*     */ 
/*     */   public JBossStreamMessage(StreamMessage foreign, long id) throws JMSException
/*     */   {
/* 111 */     super(foreign, id);
/*     */ 
/* 113 */     foreign.reset();
/*     */ 
/* 115 */     this.payload = new ArrayList();
/* 116 */     this.position = 0;
/* 117 */     this.size = 0;
/* 118 */     this.offset = 0;
/*     */     try
/*     */     {
/*     */       while (true)
/*     */       {
/* 123 */         Object obj = foreign.readObject();
/* 124 */         writeObject(obj);
/*     */       }
/*     */     }
/*     */     catch (MessageEOFException e)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte getType()
/*     */   {
/* 137 */     return 6;
/*     */   }
/*     */ 
/*     */   public void doBeforeSend() throws JMSException
/*     */   {
/* 142 */     reset();
/*     */   }
/*     */ 
/*     */   public void doBeforeReceive()
/*     */     throws JMSException
/*     */   {
/* 149 */     reset();
/*     */   }
/*     */ 
/*     */   public void copyPayload(Object other) throws JMSException
/*     */   {
/* 154 */     reset();
/* 155 */     this.payload = new ArrayList((List)other);
/* 156 */     this.payloadAsByteArray = null;
/*     */   }
/*     */ 
/*     */   public boolean readBoolean()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 166 */       Object value = ((List)getPayload()).get(this.position);
/* 167 */       this.offset = 0;
/*     */ 
/* 169 */       if (value == null)
/* 170 */         throw new NullPointerException("Value is null");
/* 171 */       if ((value instanceof Boolean))
/*     */       {
/* 173 */         this.position += 1;
/* 174 */         return ((Boolean)value).booleanValue();
/*     */       }
/* 176 */       if ((value instanceof String))
/*     */       {
/* 178 */         boolean result = Boolean.valueOf((String)value).booleanValue();
/* 179 */         this.position += 1;
/* 180 */         return result;
/*     */       }
/*     */ 
/* 183 */       throw new MessageFormatException("Invalid conversion");
/*     */     }
/*     */     catch (IndexOutOfBoundsException e) {
/*     */     }
/* 187 */     throw new MessageEOFException("");
/*     */   }
/*     */ 
/*     */   public byte readByte()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 196 */       Object value = ((List)getPayload()).get(this.position);
/* 197 */       this.offset = 0;
/* 198 */       if (value == null)
/* 199 */         throw new NullPointerException("Value is null");
/* 200 */       if ((value instanceof Byte))
/*     */       {
/* 202 */         this.position += 1;
/* 203 */         return ((Byte)value).byteValue();
/*     */       }
/* 205 */       if ((value instanceof String))
/*     */       {
/* 207 */         byte result = Byte.parseByte((String)value);
/* 208 */         this.position += 1;
/* 209 */         return result;
/*     */       }
/*     */ 
/* 212 */       throw new MessageFormatException("Invalid conversion");
/*     */     }
/*     */     catch (IndexOutOfBoundsException e) {
/*     */     }
/* 216 */     throw new MessageEOFException("");
/*     */   }
/*     */ 
/*     */   public short readShort()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 224 */       Object value = ((List)getPayload()).get(this.position);
/* 225 */       this.offset = 0;
/*     */ 
/* 227 */       if (value == null)
/* 228 */         throw new NullPointerException("Value is null");
/* 229 */       if ((value instanceof Byte))
/*     */       {
/* 231 */         this.position += 1;
/* 232 */         return ((Byte)value).shortValue();
/*     */       }
/* 234 */       if ((value instanceof Short))
/*     */       {
/* 236 */         this.position += 1;
/* 237 */         return ((Short)value).shortValue();
/*     */       }
/* 239 */       if ((value instanceof String))
/*     */       {
/* 241 */         short result = Short.parseShort((String)value);
/* 242 */         this.position += 1;
/* 243 */         return result;
/*     */       }
/*     */ 
/* 246 */       throw new MessageFormatException("Invalid conversion");
/*     */     }
/*     */     catch (IndexOutOfBoundsException e) {
/*     */     }
/* 250 */     throw new MessageEOFException("");
/*     */   }
/*     */ 
/*     */   public char readChar()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 258 */       Object value = ((List)getPayload()).get(this.position);
/* 259 */       this.offset = 0;
/*     */ 
/* 261 */       if (value == null)
/* 262 */         throw new NullPointerException("Value is null");
/* 263 */       if ((value instanceof Character))
/*     */       {
/* 265 */         this.position += 1;
/* 266 */         return ((Character)value).charValue();
/*     */       }
/*     */ 
/* 269 */       throw new MessageFormatException("Invalid conversion");
/*     */     }
/*     */     catch (IndexOutOfBoundsException e) {
/*     */     }
/* 273 */     throw new MessageEOFException("");
/*     */   }
/*     */ 
/*     */   public int readInt()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 281 */       Object value = ((List)getPayload()).get(this.position);
/* 282 */       this.offset = 0;
/*     */ 
/* 284 */       if (value == null)
/* 285 */         throw new NullPointerException("Value is null");
/* 286 */       if ((value instanceof Byte))
/*     */       {
/* 288 */         this.position += 1;
/* 289 */         return ((Byte)value).intValue();
/*     */       }
/* 291 */       if ((value instanceof Short))
/*     */       {
/* 293 */         this.position += 1;
/* 294 */         return ((Short)value).intValue();
/*     */       }
/* 296 */       if ((value instanceof Integer))
/*     */       {
/* 298 */         this.position += 1;
/* 299 */         return ((Integer)value).intValue();
/*     */       }
/* 301 */       if ((value instanceof String))
/*     */       {
/* 303 */         int result = Integer.parseInt((String)value);
/* 304 */         this.position += 1;
/* 305 */         return result;
/*     */       }
/*     */ 
/* 308 */       throw new MessageFormatException("Invalid conversion");
/*     */     }
/*     */     catch (IndexOutOfBoundsException e) {
/*     */     }
/* 312 */     throw new MessageEOFException("");
/*     */   }
/*     */ 
/*     */   public long readLong()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 320 */       Object value = ((List)getPayload()).get(this.position);
/* 321 */       this.offset = 0;
/*     */ 
/* 323 */       if (value == null)
/* 324 */         throw new NullPointerException("Value is null");
/* 325 */       if ((value instanceof Byte))
/*     */       {
/* 327 */         this.position += 1;
/* 328 */         return ((Byte)value).longValue();
/*     */       }
/* 330 */       if ((value instanceof Short))
/*     */       {
/* 332 */         this.position += 1;
/* 333 */         return ((Short)value).longValue();
/*     */       }
/* 335 */       if ((value instanceof Integer))
/*     */       {
/* 337 */         this.position += 1;
/* 338 */         return ((Integer)value).longValue();
/*     */       }
/* 340 */       if ((value instanceof Long))
/*     */       {
/* 342 */         this.position += 1;
/* 343 */         return ((Long)value).longValue();
/*     */       }
/* 345 */       if ((value instanceof String))
/*     */       {
/* 347 */         long result = Long.parseLong((String)value);
/* 348 */         this.position += 1;
/* 349 */         return result;
/*     */       }
/*     */ 
/* 352 */       throw new MessageFormatException("Invalid conversion");
/*     */     }
/*     */     catch (IndexOutOfBoundsException e) {
/*     */     }
/* 356 */     throw new MessageEOFException("");
/*     */   }
/*     */ 
/*     */   public float readFloat()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 364 */       Object value = ((List)getPayload()).get(this.position);
/* 365 */       this.offset = 0;
/*     */ 
/* 367 */       if (value == null)
/* 368 */         throw new NullPointerException("Value is null");
/* 369 */       if ((value instanceof Float))
/*     */       {
/* 371 */         this.position += 1;
/* 372 */         return ((Float)value).floatValue();
/*     */       }
/* 374 */       if ((value instanceof String))
/*     */       {
/* 376 */         float result = Float.parseFloat((String)value);
/* 377 */         this.position += 1;
/* 378 */         return result;
/*     */       }
/*     */ 
/* 381 */       throw new MessageFormatException("Invalid conversion");
/*     */     }
/*     */     catch (IndexOutOfBoundsException e) {
/*     */     }
/* 385 */     throw new MessageEOFException("");
/*     */   }
/*     */ 
/*     */   public double readDouble()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 393 */       Object value = ((List)getPayload()).get(this.position);
/* 394 */       this.offset = 0;
/*     */ 
/* 396 */       if (value == null)
/* 397 */         throw new NullPointerException("Value is null");
/* 398 */       if ((value instanceof Float))
/*     */       {
/* 400 */         this.position += 1;
/* 401 */         return ((Float)value).doubleValue();
/*     */       }
/* 403 */       if ((value instanceof Double))
/*     */       {
/* 405 */         this.position += 1;
/* 406 */         return ((Double)value).doubleValue();
/*     */       }
/* 408 */       if ((value instanceof String))
/*     */       {
/* 410 */         double result = Double.parseDouble((String)value);
/* 411 */         this.position += 1;
/* 412 */         return result;
/*     */       }
/*     */ 
/* 415 */       throw new MessageFormatException("Invalid conversion");
/*     */     }
/*     */     catch (IndexOutOfBoundsException e) {
/*     */     }
/* 419 */     throw new MessageEOFException("");
/*     */   }
/*     */ 
/*     */   public String readString()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 427 */       Object value = ((List)getPayload()).get(this.position);
/* 428 */       this.offset = 0;
/*     */ 
/* 430 */       if (value == null)
/*     */       {
/* 432 */         this.position += 1;
/* 433 */         return null;
/*     */       }
/* 435 */       if ((value instanceof Boolean))
/*     */       {
/* 437 */         this.position += 1;
/* 438 */         return ((Boolean)value).toString();
/*     */       }
/* 440 */       if ((value instanceof Byte))
/*     */       {
/* 442 */         this.position += 1;
/* 443 */         return ((Byte)value).toString();
/*     */       }
/* 445 */       if ((value instanceof Short))
/*     */       {
/* 447 */         this.position += 1;
/* 448 */         return ((Short)value).toString();
/*     */       }
/* 450 */       if ((value instanceof Character))
/*     */       {
/* 452 */         this.position += 1;
/* 453 */         return ((Character)value).toString();
/*     */       }
/* 455 */       if ((value instanceof Integer))
/*     */       {
/* 457 */         this.position += 1;
/* 458 */         return ((Integer)value).toString();
/*     */       }
/* 460 */       if ((value instanceof Long))
/*     */       {
/* 462 */         this.position += 1;
/* 463 */         return ((Long)value).toString();
/*     */       }
/* 465 */       if ((value instanceof Float))
/*     */       {
/* 467 */         this.position += 1;
/* 468 */         return ((Float)value).toString();
/*     */       }
/* 470 */       if ((value instanceof Double))
/*     */       {
/* 472 */         this.position += 1;
/* 473 */         return ((Double)value).toString();
/*     */       }
/* 475 */       if ((value instanceof String))
/*     */       {
/* 477 */         this.position += 1;
/* 478 */         return (String)value;
/*     */       }
/*     */ 
/* 481 */       throw new MessageFormatException("Invalid conversion");
/*     */     }
/*     */     catch (IndexOutOfBoundsException e) {
/*     */     }
/* 485 */     throw new MessageEOFException("");
/*     */   }
/*     */ 
/*     */   public int readBytes(byte[] value)
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 493 */       Object myObj = ((List)getPayload()).get(this.position);
/* 494 */       if (myObj == null)
/* 495 */         throw new NullPointerException("Value is null");
/* 496 */       if (!(myObj instanceof byte[]))
/* 497 */         throw new MessageFormatException("Invalid conversion");
/* 498 */       byte[] obj = (byte[])(byte[])myObj;
/*     */ 
/* 500 */       if (obj.length == 0)
/*     */       {
/* 502 */         this.position += 1;
/* 503 */         this.offset = 0;
/* 504 */         return 0;
/*     */       }
/*     */ 
/* 507 */       if (this.offset >= obj.length)
/*     */       {
/* 509 */         this.position += 1;
/* 510 */         this.offset = 0;
/* 511 */         return -1;
/*     */       }
/*     */ 
/* 514 */       if (obj.length - this.offset < value.length)
/*     */       {
/* 516 */         for (int i = 0; i < obj.length; i++) {
/* 517 */           value[i] = obj[(i + this.offset)];
/*     */         }
/* 519 */         this.position += 1;
/* 520 */         this.offset = 0;
/*     */ 
/* 522 */         return obj.length - this.offset;
/*     */       }
/*     */ 
/* 526 */       for (int i = 0; i < value.length; i++)
/* 527 */         value[i] = obj[(i + this.offset)];
/* 528 */       this.offset += value.length;
/*     */ 
/* 530 */       return value.length;
/*     */     }
/*     */     catch (IndexOutOfBoundsException e)
/*     */     {
/*     */     }
/*     */ 
/* 536 */     throw new MessageEOFException("");
/*     */   }
/*     */ 
/*     */   public Object readObject()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 544 */       Object value = ((List)getPayload()).get(this.position);
/* 545 */       this.position += 1;
/* 546 */       this.offset = 0;
/*     */ 
/* 548 */       return value;
/*     */     }
/*     */     catch (IndexOutOfBoundsException e) {
/*     */     }
/* 552 */     throw new MessageEOFException("");
/*     */   }
/*     */ 
/*     */   public void writeBoolean(boolean value)
/*     */     throws JMSException
/*     */   {
/* 559 */     ((List)getPayload()).add(Primitives.valueOf(value));
/*     */   }
/*     */ 
/*     */   public void writeByte(byte value) throws JMSException
/*     */   {
/* 564 */     ((List)getPayload()).add(new Byte(value));
/*     */   }
/*     */ 
/*     */   public void writeShort(short value) throws JMSException
/*     */   {
/* 569 */     ((List)getPayload()).add(new Short(value));
/*     */   }
/*     */ 
/*     */   public void writeChar(char value) throws JMSException
/*     */   {
/* 574 */     ((List)getPayload()).add(new Character(value));
/*     */   }
/*     */ 
/*     */   public void writeInt(int value) throws JMSException
/*     */   {
/* 579 */     ((List)getPayload()).add(new Integer(value));
/*     */   }
/*     */ 
/*     */   public void writeLong(long value) throws JMSException
/*     */   {
/* 584 */     ((List)getPayload()).add(new Long(value));
/*     */   }
/*     */ 
/*     */   public void writeFloat(float value) throws JMSException
/*     */   {
/* 589 */     ((List)getPayload()).add(new Float(value));
/*     */   }
/*     */ 
/*     */   public void writeDouble(double value) throws JMSException
/*     */   {
/* 594 */     ((List)getPayload()).add(new Double(value));
/*     */   }
/*     */ 
/*     */   public void writeString(String value) throws JMSException
/*     */   {
/* 599 */     if (value == null)
/*     */     {
/* 601 */       ((List)getPayload()).add(null);
/*     */     }
/*     */     else
/*     */     {
/* 605 */       ((List)getPayload()).add(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeBytes(byte[] value) throws JMSException
/*     */   {
/* 611 */     ((List)getPayload()).add(value.clone());
/*     */   }
/*     */ 
/*     */   public void writeBytes(byte[] value, int offset, int length) throws JMSException
/*     */   {
/* 616 */     if (offset + length > value.length)
/* 617 */       throw new JMSException("Array is too small");
/* 618 */     byte[] temp = new byte[length];
/* 619 */     for (int i = 0; i < length; i++) {
/* 620 */       temp[i] = value[(i + offset)];
/*     */     }
/* 622 */     ((List)getPayload()).add(temp);
/*     */   }
/*     */ 
/*     */   public void writeObject(Object value) throws JMSException
/*     */   {
/* 627 */     if (value == null)
/* 628 */       ((List)getPayload()).add(null);
/* 629 */     else if ((value instanceof Boolean))
/* 630 */       ((List)getPayload()).add(value);
/* 631 */     else if ((value instanceof Byte))
/* 632 */       ((List)getPayload()).add(value);
/* 633 */     else if ((value instanceof Short))
/* 634 */       ((List)getPayload()).add(value);
/* 635 */     else if ((value instanceof Character))
/* 636 */       ((List)getPayload()).add(value);
/* 637 */     else if ((value instanceof Integer))
/* 638 */       ((List)getPayload()).add(value);
/* 639 */     else if ((value instanceof Long))
/* 640 */       ((List)getPayload()).add(value);
/* 641 */     else if ((value instanceof Float))
/* 642 */       ((List)getPayload()).add(value);
/* 643 */     else if ((value instanceof Double))
/* 644 */       ((List)getPayload()).add(value);
/* 645 */     else if ((value instanceof String))
/* 646 */       ((List)getPayload()).add(value);
/* 647 */     else if ((value instanceof byte[]))
/* 648 */       ((List)getPayload()).add(((byte[])(byte[])value).clone());
/*     */     else
/* 650 */       throw new MessageFormatException("Invalid object type");
/*     */   }
/*     */ 
/*     */   public void reset() throws JMSException
/*     */   {
/* 655 */     this.position = 0;
/* 656 */     this.size = ((List)getPayload()).size();
/* 657 */     this.offset = 0;
/*     */   }
/*     */ 
/*     */   public void clearBody()
/*     */     throws JMSException
/*     */   {
/* 664 */     super.clearBody();
/*     */ 
/* 666 */     this.payload = new ArrayList();
/* 667 */     this.payloadAsByteArray = null;
/* 668 */     this.position = 0;
/* 669 */     this.offset = 0;
/* 670 */     this.size = 0;
/*     */   }
/*     */ 
/*     */   public JBossMessage doCopy()
/*     */   {
/* 676 */     return new JBossStreamMessage(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.message.JBossStreamMessage
 * JD-Core Version:    0.6.0
 */