/*     */ package org.jboss.jms.message;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.EOFException;
/*     */ import java.io.IOException;
/*     */ import java.util.Map;
/*     */ import javax.jms.BytesMessage;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.MessageEOFException;
/*     */ import javax.jms.MessageFormatException;
/*     */ import org.jboss.jms.exception.MessagingJMSException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JBossBytesMessage extends JBossMessage
/*     */   implements BytesMessage
/*     */ {
/*     */   private static final long serialVersionUID = 5914561890366707664L;
/*  58 */   private static final Logger log = Logger.getLogger(JBossBytesMessage.class);
/*     */   public static final byte TYPE = 4;
/*  64 */   private boolean trace = log.isTraceEnabled();
/*     */   private transient ByteArrayOutputStream baos;
/*     */   private transient DataOutputStream dos;
/*     */   private transient ByteArrayInputStream bais;
/*     */   private transient DataInputStream dis;
/*     */ 
/*     */   public JBossBytesMessage()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JBossBytesMessage(long messageID)
/*     */   {
/*  86 */     super(messageID);
/*     */   }
/*     */ 
/*     */   public JBossBytesMessage(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map coreHeaders, byte[] payloadAsByteArray)
/*     */   {
/* 100 */     super(messageID, reliable, expiration, timestamp, priority, coreHeaders, payloadAsByteArray);
/*     */   }
/*     */ 
/*     */   public JBossBytesMessage(JBossBytesMessage other)
/*     */   {
/* 111 */     super(other);
/*     */ 
/* 113 */     if (this.trace) log.trace("Creating new JBossBytesMessage from other JBossBytesMessage"); 
/*     */   }
/*     */ 
/*     */   public JBossBytesMessage(BytesMessage foreign, long id)
/*     */     throws JMSException
/*     */   {
/* 118 */     super(foreign, id);
/*     */ 
/* 120 */     foreign.reset();
/*     */ 
/* 122 */     this.baos = new ByteArrayOutputStream();
/* 123 */     this.dos = new DataOutputStream(this.baos);
/*     */ 
/* 125 */     byte[] buffer = new byte[1024];
/* 126 */     int n = foreign.readBytes(buffer);
/* 127 */     while (n != -1)
/*     */     {
/* 129 */       writeBytes(buffer, 0, n);
/* 130 */       n = foreign.readBytes(buffer);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in)
/*     */     throws Exception
/*     */   {
/* 138 */     super.read(in);
/*     */   }
/*     */ 
/*     */   public boolean readBoolean()
/*     */     throws JMSException
/*     */   {
/* 145 */     checkRead();
/*     */     try
/*     */     {
/* 148 */       return this.dis.readBoolean();
/*     */     }
/*     */     catch (EOFException e)
/*     */     {
/* 152 */       throw new MessageEOFException("");
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 156 */     throw new MessagingJMSException("IOException", e);
/*     */   }
/*     */ 
/*     */   public byte readByte()
/*     */     throws JMSException
/*     */   {
/* 162 */     checkRead();
/*     */     try
/*     */     {
/* 165 */       return this.dis.readByte();
/*     */     }
/*     */     catch (EOFException e)
/*     */     {
/* 169 */       throw new MessageEOFException("");
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 173 */     throw new MessagingJMSException("IOException", e);
/*     */   }
/*     */ 
/*     */   public int readUnsignedByte()
/*     */     throws JMSException
/*     */   {
/* 179 */     checkRead();
/*     */     try
/*     */     {
/* 182 */       return this.dis.readUnsignedByte();
/*     */     }
/*     */     catch (EOFException e)
/*     */     {
/* 186 */       throw new MessageEOFException("");
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 190 */     throw new MessagingJMSException("IOException", e);
/*     */   }
/*     */ 
/*     */   public short readShort()
/*     */     throws JMSException
/*     */   {
/* 196 */     checkRead();
/*     */     try
/*     */     {
/* 199 */       return this.dis.readShort();
/*     */     }
/*     */     catch (EOFException e)
/*     */     {
/* 203 */       throw new MessageEOFException("");
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 207 */     throw new MessagingJMSException("IOException", e);
/*     */   }
/*     */ 
/*     */   public int readUnsignedShort()
/*     */     throws JMSException
/*     */   {
/* 213 */     checkRead();
/*     */     try
/*     */     {
/* 216 */       return this.dis.readUnsignedShort();
/*     */     }
/*     */     catch (EOFException e)
/*     */     {
/* 220 */       throw new MessageEOFException("");
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 224 */     throw new MessagingJMSException("IOException", e);
/*     */   }
/*     */ 
/*     */   public char readChar()
/*     */     throws JMSException
/*     */   {
/* 230 */     checkRead();
/*     */     try
/*     */     {
/* 233 */       return this.dis.readChar();
/*     */     }
/*     */     catch (EOFException e)
/*     */     {
/* 237 */       throw new MessageEOFException("");
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 241 */     throw new MessagingJMSException("IOException", e);
/*     */   }
/*     */ 
/*     */   public int readInt()
/*     */     throws JMSException
/*     */   {
/* 247 */     checkRead();
/*     */     try
/*     */     {
/* 250 */       return this.dis.readInt();
/*     */     }
/*     */     catch (EOFException e)
/*     */     {
/* 254 */       throw new MessageEOFException("");
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 258 */     throw new MessagingJMSException("IOException", e);
/*     */   }
/*     */ 
/*     */   public long readLong()
/*     */     throws JMSException
/*     */   {
/* 264 */     checkRead();
/*     */     try
/*     */     {
/* 267 */       return this.dis.readLong();
/*     */     }
/*     */     catch (EOFException e)
/*     */     {
/* 271 */       throw new MessageEOFException("");
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 275 */     throw new MessagingJMSException("IOException", e);
/*     */   }
/*     */ 
/*     */   public float readFloat()
/*     */     throws JMSException
/*     */   {
/* 281 */     checkRead();
/*     */     try
/*     */     {
/* 284 */       return this.dis.readFloat();
/*     */     }
/*     */     catch (EOFException e)
/*     */     {
/* 288 */       throw new MessageEOFException("");
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 292 */     throw new MessagingJMSException("IOException", e);
/*     */   }
/*     */ 
/*     */   public double readDouble()
/*     */     throws JMSException
/*     */   {
/* 298 */     checkRead();
/*     */     try
/*     */     {
/* 301 */       return this.dis.readDouble();
/*     */     }
/*     */     catch (EOFException e)
/*     */     {
/* 305 */       throw new MessageEOFException("");
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 309 */     throw new MessagingJMSException("IOException", e);
/*     */   }
/*     */ 
/*     */   public String readUTF()
/*     */     throws JMSException
/*     */   {
/* 315 */     checkRead();
/*     */     try
/*     */     {
/* 318 */       return this.dis.readUTF();
/*     */     }
/*     */     catch (EOFException e)
/*     */     {
/* 322 */       throw new MessageEOFException("");
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 326 */     throw new MessagingJMSException("IOException", e);
/*     */   }
/*     */ 
/*     */   public int readBytes(byte[] value)
/*     */     throws JMSException
/*     */   {
/* 332 */     checkRead();
/*     */     try
/*     */     {
/* 335 */       return this.dis.read(value);
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 339 */     throw new MessagingJMSException("IOException", e);
/*     */   }
/*     */ 
/*     */   public int readBytes(byte[] value, int length)
/*     */     throws JMSException
/*     */   {
/* 345 */     checkRead();
/*     */     try
/*     */     {
/* 348 */       return this.dis.read(value, 0, length);
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 352 */     throw new MessagingJMSException("IOException", e);
/*     */   }
/*     */ 
/*     */   public void writeBoolean(boolean value)
/*     */     throws JMSException
/*     */   {
/* 358 */     checkWrite();
/*     */     try
/*     */     {
/* 361 */       this.dos.writeBoolean(value);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 365 */       throw new MessagingJMSException("IOException", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeByte(byte value) throws JMSException
/*     */   {
/* 371 */     checkWrite();
/*     */     try
/*     */     {
/* 374 */       this.dos.writeByte(value);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 378 */       throw new MessagingJMSException("IOException", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeShort(short value) throws JMSException
/*     */   {
/* 384 */     checkWrite();
/*     */     try
/*     */     {
/* 387 */       this.dos.writeShort(value);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 391 */       throw new MessagingJMSException("IOException", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeChar(char value) throws JMSException
/*     */   {
/* 397 */     checkWrite();
/*     */     try
/*     */     {
/* 400 */       this.dos.writeChar(value);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 404 */       throw new MessagingJMSException("IOException", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeInt(int value) throws JMSException
/*     */   {
/* 410 */     checkWrite();
/*     */     try
/*     */     {
/* 413 */       this.dos.writeInt(value);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 417 */       throw new MessagingJMSException("IOException", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeLong(long value) throws JMSException
/*     */   {
/* 423 */     checkWrite();
/*     */     try
/*     */     {
/* 426 */       this.dos.writeLong(value);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 430 */       throw new MessagingJMSException("IOException", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeFloat(float value) throws JMSException
/*     */   {
/* 436 */     checkWrite();
/*     */     try
/*     */     {
/* 439 */       this.dos.writeFloat(value);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 443 */       throw new MessagingJMSException("IOException", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeDouble(double value) throws JMSException
/*     */   {
/* 449 */     checkWrite();
/*     */     try
/*     */     {
/* 452 */       this.dos.writeDouble(value);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 456 */       throw new MessagingJMSException("IOException", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeUTF(String value) throws JMSException
/*     */   {
/* 462 */     checkWrite();
/*     */     try
/*     */     {
/* 465 */       this.dos.writeUTF(value);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 469 */       throw new MessagingJMSException("IOException", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeBytes(byte[] value) throws JMSException
/*     */   {
/* 475 */     checkWrite();
/*     */     try
/*     */     {
/* 478 */       this.dos.write(value, 0, value.length);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 482 */       throw new MessagingJMSException("IOException", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeBytes(byte[] value, int offset, int length) throws JMSException
/*     */   {
/* 488 */     checkWrite();
/*     */     try
/*     */     {
/* 491 */       this.dos.write(value, offset, length);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 495 */       throw new MessagingJMSException("IOException", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeObject(Object value) throws JMSException
/*     */   {
/* 501 */     checkWrite();
/*     */     try
/*     */     {
/* 504 */       if (value == null)
/*     */       {
/* 506 */         throw new NullPointerException("Attempt to write a new value");
/*     */       }
/* 508 */       if ((value instanceof String))
/*     */       {
/* 510 */         this.dos.writeUTF((String)value);
/*     */       }
/* 512 */       else if ((value instanceof Boolean))
/*     */       {
/* 514 */         this.dos.writeBoolean(((Boolean)value).booleanValue());
/*     */       }
/* 516 */       else if ((value instanceof Byte))
/*     */       {
/* 518 */         this.dos.writeByte(((Byte)value).byteValue());
/*     */       }
/* 520 */       else if ((value instanceof Short))
/*     */       {
/* 522 */         this.dos.writeShort(((Short)value).shortValue());
/*     */       }
/* 524 */       else if ((value instanceof Integer))
/*     */       {
/* 526 */         this.dos.writeInt(((Integer)value).intValue());
/*     */       }
/* 528 */       else if ((value instanceof Long))
/*     */       {
/* 530 */         this.dos.writeLong(((Long)value).longValue());
/*     */       }
/* 532 */       else if ((value instanceof Float))
/*     */       {
/* 534 */         this.dos.writeFloat(((Float)value).floatValue());
/*     */       }
/* 536 */       else if ((value instanceof Double))
/*     */       {
/* 538 */         this.dos.writeDouble(((Double)value).doubleValue());
/*     */       }
/* 540 */       else if ((value instanceof byte[]))
/*     */       {
/* 542 */         this.dos.write((byte[])(byte[])value, 0, ((byte[])(byte[])value).length);
/*     */       }
/*     */       else
/*     */       {
/* 546 */         throw new MessageFormatException("Invalid object for properties");
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 551 */       throw new MessagingJMSException("IOException", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void reset() throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 559 */       if (this.baos != null)
/*     */       {
/* 561 */         this.dos.flush();
/*     */ 
/* 563 */         this.payload = this.baos.toByteArray();
/*     */ 
/* 565 */         this.payloadAsByteArray = ((byte[])(byte[])this.payload);
/*     */ 
/* 567 */         this.baos.close();
/*     */       }
/* 569 */       this.baos = null;
/* 570 */       this.bais = null;
/* 571 */       this.dis = null;
/* 572 */       this.dos = null;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 576 */       JMSException e2 = new JMSException(e.getMessage());
/* 577 */       e2.setStackTrace(e.getStackTrace());
/* 578 */       throw e2;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getPayload()
/*     */   {
/* 586 */     return this.payload;
/*     */   }
/*     */ 
/*     */   public byte[] getPayloadAsByteArray()
/*     */   {
/* 591 */     return this.payloadAsByteArray;
/*     */   }
/*     */ 
/*     */   public void doBeforeSend()
/*     */     throws JMSException
/*     */   {
/* 598 */     reset();
/*     */   }
/*     */ 
/*     */   public void doBeforeReceive()
/*     */     throws JMSException
/*     */   {
/* 605 */     reset();
/*     */   }
/*     */ 
/*     */   public void clearBody() throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 612 */       if (this.baos != null)
/*     */       {
/* 614 */         this.baos.close();
/*     */       }
/* 618 */       else if (this.bais != null)
/*     */       {
/* 620 */         this.bais.close();
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*     */     }
/*     */ 
/* 629 */     this.baos = new ByteArrayOutputStream();
/* 630 */     this.dos = new DataOutputStream(this.baos);
/* 631 */     this.payload = null;
/* 632 */     this.payloadAsByteArray = null;
/* 633 */     this.bais = null;
/* 634 */     this.dis = null;
/*     */   }
/*     */ 
/*     */   public long getBodyLength() throws JMSException
/*     */   {
/* 639 */     checkRead();
/* 640 */     return this.payloadAsByteArray.length;
/*     */   }
/*     */ 
/*     */   public byte getType()
/*     */   {
/* 647 */     return 4;
/*     */   }
/*     */ 
/*     */   public JBossMessage doCopy() throws JMSException
/*     */   {
/* 652 */     reset();
/*     */ 
/* 654 */     return new JBossBytesMessage(this);
/*     */   }
/*     */ 
/*     */   public void copyPayload(Object payload) throws JMSException
/*     */   {
/* 659 */     byte[] otherBytes = (byte[])(byte[])payload;
/* 660 */     if (otherBytes == null)
/*     */     {
/* 662 */       payload = null;
/*     */     }
/*     */     else
/*     */     {
/* 666 */       payload = new byte[otherBytes.length];
/*     */ 
/* 668 */       System.arraycopy(otherBytes, 0, payload, 0, otherBytes.length);
/*     */ 
/* 670 */       this.payloadAsByteArray = ((byte[])(byte[])payload);
/*     */     }
/*     */   }
/*     */ 
/*     */   void checkRead()
/*     */   {
/* 684 */     if (this.bais == null)
/*     */     {
/* 686 */       this.bais = new ByteArrayInputStream(this.payloadAsByteArray);
/* 687 */       this.dis = new DataInputStream(this.bais);
/*     */     }
/*     */   }
/*     */ 
/*     */   void checkWrite()
/*     */   {
/* 693 */     if (this.baos == null)
/*     */     {
/* 695 */       this.baos = new ByteArrayOutputStream();
/* 696 */       this.dos = new DataOutputStream(this.baos);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.message.JBossBytesMessage
 * JD-Core Version:    0.6.0
 */