/*     */ package org.jboss.jms.message;
/*     */ 
/*     */ import javax.jms.BytesMessage;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.MessageNotReadableException;
/*     */ import javax.jms.MessageNotWriteableException;
/*     */ 
/*     */ public class BytesMessageProxy extends MessageProxy
/*     */   implements BytesMessage
/*     */ {
/*     */   private static final long serialVersionUID = -9121097962625801946L;
/*     */ 
/*     */   public BytesMessageProxy(long deliveryId, JBossBytesMessage message, int deliveryCount)
/*     */   {
/*  43 */     super(deliveryId, message, deliveryCount);
/*     */   }
/*     */ 
/*     */   public BytesMessageProxy(JBossBytesMessage message)
/*     */   {
/*  48 */     super(message);
/*     */   }
/*     */ 
/*     */   public long getBodyLength() throws JMSException
/*     */   {
/*  53 */     if (!this.bodyReadOnly)
/*     */     {
/*  55 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/*  57 */     return ((BytesMessage)this.message).getBodyLength();
/*     */   }
/*     */ 
/*     */   public boolean readBoolean() throws JMSException
/*     */   {
/*  62 */     if (!this.bodyReadOnly)
/*     */     {
/*  64 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/*  66 */     return ((BytesMessage)this.message).readBoolean();
/*     */   }
/*     */ 
/*     */   public byte readByte() throws JMSException
/*     */   {
/*  71 */     if (!this.bodyReadOnly)
/*     */     {
/*  73 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/*  75 */     return ((BytesMessage)this.message).readByte();
/*     */   }
/*     */ 
/*     */   public int readUnsignedByte() throws JMSException
/*     */   {
/*  80 */     if (!this.bodyReadOnly)
/*     */     {
/*  82 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/*  84 */     return ((BytesMessage)this.message).readUnsignedByte();
/*     */   }
/*     */ 
/*     */   public short readShort() throws JMSException
/*     */   {
/*  89 */     if (!this.bodyReadOnly)
/*     */     {
/*  91 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/*  93 */     return ((BytesMessage)this.message).readShort();
/*     */   }
/*     */ 
/*     */   public int readUnsignedShort() throws JMSException
/*     */   {
/*  98 */     if (!this.bodyReadOnly)
/*     */     {
/* 100 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 102 */     return ((BytesMessage)this.message).readUnsignedShort();
/*     */   }
/*     */ 
/*     */   public char readChar() throws JMSException
/*     */   {
/* 107 */     if (!this.bodyReadOnly)
/*     */     {
/* 109 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 111 */     return ((BytesMessage)this.message).readChar();
/*     */   }
/*     */ 
/*     */   public int readInt() throws JMSException
/*     */   {
/* 116 */     if (!this.bodyReadOnly)
/*     */     {
/* 118 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 120 */     return ((BytesMessage)this.message).readInt();
/*     */   }
/*     */ 
/*     */   public long readLong() throws JMSException
/*     */   {
/* 125 */     if (!this.bodyReadOnly)
/*     */     {
/* 127 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 129 */     return ((BytesMessage)this.message).readLong();
/*     */   }
/*     */ 
/*     */   public float readFloat() throws JMSException
/*     */   {
/* 134 */     if (!this.bodyReadOnly)
/*     */     {
/* 136 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 138 */     return ((BytesMessage)this.message).readFloat();
/*     */   }
/*     */ 
/*     */   public double readDouble() throws JMSException
/*     */   {
/* 143 */     if (!this.bodyReadOnly)
/*     */     {
/* 145 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 147 */     return ((BytesMessage)this.message).readDouble();
/*     */   }
/*     */ 
/*     */   public String readUTF() throws JMSException
/*     */   {
/* 152 */     if (!this.bodyReadOnly)
/*     */     {
/* 154 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 156 */     return ((BytesMessage)this.message).readUTF();
/*     */   }
/*     */ 
/*     */   public int readBytes(byte[] value) throws JMSException
/*     */   {
/* 161 */     if (!this.bodyReadOnly)
/*     */     {
/* 163 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 165 */     return ((BytesMessage)this.message).readBytes(value);
/*     */   }
/*     */ 
/*     */   public int readBytes(byte[] value, int length) throws JMSException
/*     */   {
/* 170 */     if (!this.bodyReadOnly)
/*     */     {
/* 172 */       throw new MessageNotReadableException("The message body is writeonly");
/*     */     }
/* 174 */     return ((BytesMessage)this.message).readBytes(value, length);
/*     */   }
/*     */ 
/*     */   public void writeBoolean(boolean value) throws JMSException
/*     */   {
/* 179 */     if (this.bodyReadOnly)
/*     */     {
/* 181 */       throw new MessageNotWriteableException("the message body is read-only");
/*     */     }
/* 183 */     bodyChange();
/* 184 */     ((BytesMessage)this.message).writeBoolean(value);
/*     */   }
/*     */ 
/*     */   public void writeByte(byte value) throws JMSException
/*     */   {
/* 189 */     if (this.bodyReadOnly)
/*     */     {
/* 191 */       throw new MessageNotWriteableException("the message body is read-only");
/*     */     }
/* 193 */     bodyChange();
/* 194 */     ((BytesMessage)this.message).writeByte(value);
/*     */   }
/*     */ 
/*     */   public void writeShort(short value) throws JMSException
/*     */   {
/* 199 */     if (this.bodyReadOnly)
/*     */     {
/* 201 */       throw new MessageNotWriteableException("the message body is read-only");
/*     */     }
/* 203 */     bodyChange();
/* 204 */     ((BytesMessage)this.message).writeShort(value);
/*     */   }
/*     */ 
/*     */   public void writeChar(char value) throws JMSException
/*     */   {
/* 209 */     if (this.bodyReadOnly)
/*     */     {
/* 211 */       throw new MessageNotWriteableException("the message body is read-only");
/*     */     }
/* 213 */     bodyChange();
/* 214 */     ((BytesMessage)this.message).writeChar(value);
/*     */   }
/*     */ 
/*     */   public void writeInt(int value) throws JMSException
/*     */   {
/* 219 */     if (this.bodyReadOnly)
/*     */     {
/* 221 */       throw new MessageNotWriteableException("the message body is read-only");
/*     */     }
/* 223 */     bodyChange();
/* 224 */     ((BytesMessage)this.message).writeInt(value);
/*     */   }
/*     */ 
/*     */   public void writeLong(long value) throws JMSException
/*     */   {
/* 229 */     if (this.bodyReadOnly)
/*     */     {
/* 231 */       throw new MessageNotWriteableException("the message body is read-only");
/*     */     }
/* 233 */     bodyChange();
/* 234 */     ((BytesMessage)this.message).writeLong(value);
/*     */   }
/*     */ 
/*     */   public void writeFloat(float value) throws JMSException
/*     */   {
/* 239 */     if (this.bodyReadOnly)
/*     */     {
/* 241 */       throw new MessageNotWriteableException("the message body is read-only");
/*     */     }
/* 243 */     bodyChange();
/* 244 */     ((BytesMessage)this.message).writeFloat(value);
/*     */   }
/*     */ 
/*     */   public void writeDouble(double value) throws JMSException
/*     */   {
/* 249 */     if (this.bodyReadOnly)
/*     */     {
/* 251 */       throw new MessageNotWriteableException("the message body is read-only");
/*     */     }
/* 253 */     bodyChange();
/* 254 */     ((BytesMessage)this.message).writeDouble(value);
/*     */   }
/*     */ 
/*     */   public void writeUTF(String value) throws JMSException
/*     */   {
/* 259 */     if (this.bodyReadOnly)
/*     */     {
/* 261 */       throw new MessageNotWriteableException("the message body is read-only");
/*     */     }
/* 263 */     bodyChange();
/* 264 */     ((BytesMessage)this.message).writeUTF(value);
/*     */   }
/*     */ 
/*     */   public void writeBytes(byte[] value) throws JMSException
/*     */   {
/* 269 */     if (this.bodyReadOnly)
/*     */     {
/* 271 */       throw new MessageNotWriteableException("the message body is read-only");
/*     */     }
/* 273 */     bodyChange();
/* 274 */     ((BytesMessage)this.message).writeBytes(value);
/*     */   }
/*     */ 
/*     */   public void writeBytes(byte[] value, int offset, int length) throws JMSException
/*     */   {
/* 279 */     if (this.bodyReadOnly)
/*     */     {
/* 281 */       throw new MessageNotWriteableException("the message body is read-only");
/*     */     }
/* 283 */     bodyChange();
/* 284 */     ((BytesMessage)this.message).writeBytes(value, offset, length);
/*     */   }
/*     */ 
/*     */   public void writeObject(Object value) throws JMSException
/*     */   {
/* 289 */     if (this.bodyReadOnly)
/*     */     {
/* 291 */       throw new MessageNotWriteableException("the message body is read-only");
/*     */     }
/* 293 */     bodyChange();
/* 294 */     ((BytesMessage)this.message).writeObject(value);
/*     */   }
/*     */ 
/*     */   public void reset() throws JMSException
/*     */   {
/* 299 */     ((BytesMessage)this.message).reset();
/* 300 */     this.bodyReadOnly = true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.message.BytesMessageProxy
 * JD-Core Version:    0.6.0
 */