/*     */ package org.jboss.jms.jndi;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Properties;
/*     */ 
/*     */ public abstract class AbstractJMSProviderAdapter
/*     */   implements JMSProviderAdapter, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 3573606612665654983L;
/*     */   protected String name;
/*     */   protected Properties properties;
/*     */   protected String factoryRef;
/*     */   protected String queueFactoryRef;
/*     */   protected String topicFactoryRef;
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  60 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public final String getName()
/*     */   {
/*  65 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setProperties(Properties properties)
/*     */   {
/*  70 */     this.properties = properties;
/*     */   }
/*     */ 
/*     */   public final Properties getProperties()
/*     */   {
/*  75 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public String getFactoryRef()
/*     */   {
/*  80 */     if (this.factoryRef == null)
/*  81 */       throw new IllegalStateException("Combined ConnectionFactory 'FactoryRef' not configured.");
/*  82 */     return this.factoryRef;
/*     */   }
/*     */ 
/*     */   public String getQueueFactoryRef()
/*     */   {
/*  87 */     if (this.queueFactoryRef == null)
/*  88 */       throw new IllegalStateException("Queue ConnectionFactory 'QueueFactoryRef' not configured.");
/*  89 */     return this.queueFactoryRef;
/*     */   }
/*     */ 
/*     */   public String getTopicFactoryRef()
/*     */   {
/*  94 */     if (this.topicFactoryRef == null)
/*  95 */       throw new IllegalStateException("Topic ConnectionFactory 'TopicFactoryRef' not configured.");
/*  96 */     return this.topicFactoryRef;
/*     */   }
/*     */ 
/*     */   public void setFactoryRef(String newFactoryRef)
/*     */   {
/* 101 */     this.factoryRef = newFactoryRef;
/*     */   }
/*     */ 
/*     */   public void setQueueFactoryRef(String newQueueFactoryRef)
/*     */   {
/* 106 */     this.queueFactoryRef = newQueueFactoryRef;
/*     */   }
/*     */ 
/*     */   public void setTopicFactoryRef(String newTopicFactoryRef)
/*     */   {
/* 111 */     this.topicFactoryRef = newTopicFactoryRef;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.jndi.AbstractJMSProviderAdapter
 * JD-Core Version:    0.6.0
 */