/*    */ package org.jboss.jms.destination;
/*    */ 
/*    */ import javax.jms.JMSException;
/*    */ import javax.jms.TemporaryQueue;
/*    */ import org.jboss.jms.delegate.SessionDelegate;
/*    */ import org.jboss.messaging.util.GUIDGenerator;
/*    */ 
/*    */ public class JBossTemporaryQueue extends JBossQueue
/*    */   implements TemporaryQueue
/*    */ {
/*    */   private static final long serialVersionUID = 4250425221695034957L;
/*    */   private transient SessionDelegate delegate;
/*    */ 
/*    */   public JBossTemporaryQueue(SessionDelegate delegate)
/*    */   {
/* 54 */     super(GUIDGenerator.generateGUID());
/* 55 */     this.delegate = delegate;
/*    */   }
/*    */ 
/*    */   public JBossTemporaryQueue(String name)
/*    */   {
/* 60 */     super(name);
/*    */   }
/*    */ 
/*    */   public void delete()
/*    */     throws JMSException
/*    */   {
/* 67 */     if (this.delegate != null)
/*    */     {
/* 69 */       this.delegate.deleteTemporaryDestination(this);
/*    */     }
/*    */   }
/*    */ 
/*    */   public boolean isTemporary()
/*    */   {
/* 77 */     return true;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 84 */     return "JBossTemporaryQueue[" + this.name + "]";
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.destination.JBossTemporaryQueue
 * JD-Core Version:    0.6.0
 */