/*     */ package org.jboss.jms.destination;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import javax.jms.Destination;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Reference;
/*     */ import org.jboss.jms.referenceable.SerializableObjectRefAddr;
/*     */ 
/*     */ public abstract class JBossDestination
/*     */   implements Destination, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -3483274922186827576L;
/*     */   private static final byte NULL = 0;
/*     */   private static final byte QUEUE = 1;
/*     */   private static final byte TOPIC = 2;
/*     */   private static final byte TEMP_QUEUE = 3;
/*     */   private static final byte TEMP_TOPIC = 4;
/*     */   protected String name;
/*     */   protected boolean direct;
/*     */   private int hash;
/*     */ 
/*     */   public static void writeDestination(DataOutputStream out, Destination dest)
/*     */     throws IOException
/*     */   {
/*  62 */     JBossDestination jb = (JBossDestination)dest;
/*     */ 
/*  64 */     if (dest == null)
/*     */     {
/*  66 */       out.writeByte(0);
/*     */     }
/*     */     else
/*     */     {
/*  70 */       if (!jb.isTemporary())
/*     */       {
/*  72 */         if (jb.isQueue())
/*     */         {
/*  74 */           out.writeByte(1);
/*     */         }
/*     */         else
/*     */         {
/*  78 */           out.writeByte(2);
/*     */         }
/*     */ 
/*     */       }
/*  83 */       else if (jb.isQueue())
/*     */       {
/*  85 */         out.writeByte(3);
/*     */       }
/*     */       else
/*     */       {
/*  89 */         out.writeByte(4);
/*     */       }
/*     */ 
/*  92 */       out.writeUTF(jb.getName());
/*  93 */       out.writeBoolean(jb.direct);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static JBossDestination readDestination(DataInputStream in) throws IOException
/*     */   {
/*  99 */     byte b = in.readByte();
/*     */ 
/* 101 */     if (b == 0)
/*     */     {
/* 103 */       return null;
/*     */     }
/*     */ 
/* 107 */     String name = in.readUTF();
/*     */ 
/* 109 */     boolean direct = in.readBoolean();
/*     */     JBossDestination dest;
/* 113 */     if (b == 1)
/*     */     {
/* 115 */       dest = new JBossQueue(name);
/*     */     }
/*     */     else
/*     */     {
/*     */       JBossDestination dest;
/* 117 */       if (b == 2)
/*     */       {
/* 119 */         dest = new JBossTopic(name);
/*     */       }
/*     */       else
/*     */       {
/*     */         JBossDestination dest;
/* 121 */         if (b == 3)
/*     */         {
/* 123 */           dest = new JBossTemporaryQueue(name);
/*     */         }
/*     */         else
/*     */         {
/*     */           JBossDestination dest;
/* 125 */           if (b == 4)
/*     */           {
/* 127 */             dest = new JBossTemporaryTopic(name);
/*     */           }
/*     */           else
/*     */           {
/* 131 */             throw new IllegalStateException("Invalid value:" + b);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     JBossDestination dest;
/* 134 */     dest.direct = direct;
/*     */ 
/* 136 */     return dest;
/*     */   }
/*     */ 
/*     */   public JBossDestination(String name)
/*     */   {
/* 151 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public Reference getReference()
/*     */     throws NamingException
/*     */   {
/* 158 */     return new Reference("org.jboss.jms.destination.JBossDestination", new SerializableObjectRefAddr("JBM-DEST", this), "org.jboss.jms.referenceable.DestinationObjectFactory", null);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 168 */     return this.name;
/*     */   }
/*     */   public abstract boolean isTopic();
/*     */ 
/*     */   public abstract boolean isQueue();
/*     */ 
/* 176 */   public boolean isTemporary() { return false;
/*     */   }
/*     */ 
/*     */   public boolean isDirect()
/*     */   {
/* 181 */     return this.direct;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 186 */     if (this == o)
/*     */     {
/* 188 */       return true;
/*     */     }
/* 190 */     if (!(o instanceof JBossDestination))
/*     */     {
/* 192 */       return false;
/*     */     }
/* 194 */     JBossDestination that = (JBossDestination)o;
/* 195 */     if (this.name == null)
/*     */     {
/* 197 */       return (isTopic() == that.isTopic()) && (that.name == null);
/*     */     }
/* 199 */     return (isTopic() == that.isTopic()) && (this.name.equals(that.name));
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 207 */     if (this.hash != 0)
/*     */     {
/* 209 */       return this.hash;
/*     */     }
/*     */ 
/* 213 */     int code = 0;
/* 214 */     if (this.name != null)
/*     */     {
/* 216 */       code = this.name.hashCode();
/*     */     }
/* 218 */     this.hash = (code + (isTopic() ? 37 : 71));
/* 219 */     return this.hash;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.destination.JBossDestination
 * JD-Core Version:    0.6.0
 */