/*     */ package org.jboss.jms.delegate;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
/*     */ import org.jboss.messaging.util.Streamable;
/*     */ 
/*     */ public class TopologyResult
/*     */   implements Streamable
/*     */ {
/*     */   private ClientConnectionFactoryDelegate[] delegates;
/*     */   private Map failoverMap;
/*     */   String uniqueName;
/*     */ 
/*     */   public TopologyResult()
/*     */   {
/*     */   }
/*     */ 
/*     */   public TopologyResult(String uniqueName, ClientConnectionFactoryDelegate[] delegates, Map failoverMap)
/*     */   {
/*  63 */     this.uniqueName = uniqueName;
/*     */ 
/*  65 */     this.delegates = delegates;
/*     */ 
/*  67 */     this.failoverMap = failoverMap;
/*     */   }
/*     */ 
/*     */   public ClientConnectionFactoryDelegate[] getDelegates()
/*     */   {
/*  77 */     return this.delegates;
/*     */   }
/*     */ 
/*     */   public void setDelegates(ClientConnectionFactoryDelegate[] delegates)
/*     */   {
/*  82 */     this.delegates = delegates;
/*     */   }
/*     */ 
/*     */   public Map getFailoverMap()
/*     */   {
/*  87 */     return this.failoverMap;
/*     */   }
/*     */ 
/*     */   public void setFailoverMap(Map failoverMap)
/*     */   {
/*  92 */     this.failoverMap = failoverMap;
/*     */   }
/*     */ 
/*     */   public String getUniqueName()
/*     */   {
/*  97 */     return this.uniqueName;
/*     */   }
/*     */ 
/*     */   public void setUniqueName(String uniqueName)
/*     */   {
/* 102 */     this.uniqueName = uniqueName;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream is) throws Exception
/*     */   {
/* 107 */     this.uniqueName = is.readUTF();
/*     */ 
/* 109 */     int len = is.readInt();
/*     */ 
/* 111 */     this.delegates = new ClientConnectionFactoryDelegate[len];
/*     */ 
/* 113 */     for (int i = 0; i < len; i++)
/*     */     {
/* 115 */       this.delegates[i] = new ClientConnectionFactoryDelegate();
/*     */ 
/* 117 */       this.delegates[i].read(is);
/*     */     }
/*     */ 
/* 120 */     len = is.readInt();
/*     */ 
/* 122 */     this.failoverMap = new HashMap(len);
/*     */ 
/* 124 */     for (int c = 0; c < len; c++)
/*     */     {
/* 126 */       Integer i = new Integer(is.readInt());
/*     */ 
/* 128 */       Integer j = new Integer(is.readInt());
/*     */ 
/* 130 */       this.failoverMap.put(i, j);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream os) throws Exception
/*     */   {
/* 136 */     os.writeUTF(this.uniqueName);
/*     */ 
/* 138 */     int len = this.delegates.length;
/*     */ 
/* 140 */     os.writeInt(len);
/*     */ 
/* 142 */     for (int i = 0; i < len; i++)
/*     */     {
/* 144 */       this.delegates[i].write(os);
/*     */     }
/*     */ 
/* 147 */     os.writeInt(this.failoverMap.size());
/*     */ 
/* 149 */     Iterator iter = this.failoverMap.entrySet().iterator();
/*     */ 
/* 151 */     while (iter.hasNext())
/*     */     {
/* 153 */       Map.Entry entry = (Map.Entry)iter.next();
/*     */ 
/* 155 */       Integer i = (Integer)entry.getKey();
/*     */ 
/* 157 */       Integer j = (Integer)entry.getValue();
/*     */ 
/* 159 */       os.writeInt(i.intValue());
/*     */ 
/* 161 */       os.writeInt(j.intValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 169 */     StringBuffer sb = new StringBuffer("UpdateConnectionFactoryResult[");
/*     */ 
/* 171 */     if (this.delegates != null)
/*     */     {
/* 173 */       for (int i = 0; i < this.delegates.length; i++)
/*     */       {
/* 175 */         sb.append(this.delegates[i]);
/* 176 */         if (i >= this.delegates.length - 1)
/*     */           continue;
/* 178 */         sb.append(',');
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 183 */     sb.append("]");
/*     */ 
/* 185 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.delegate.TopologyResult
 * JD-Core Version:    0.6.0
 */