/*     */ package org.jboss.jms.delegate;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import org.jboss.jms.client.delegate.ClientConnectionDelegate;
/*     */ import org.jboss.messaging.util.Streamable;
/*     */ 
/*     */ public class CreateConnectionResult
/*     */   implements Streamable
/*     */ {
/*     */   private static final int NULL = 0;
/*     */   private static final int NOT_NULL = 1;
/*     */   private ClientConnectionDelegate delegate;
/*     */   private int actualFailoverNodeID;
/*     */ 
/*     */   public CreateConnectionResult()
/*     */   {
/*     */   }
/*     */ 
/*     */   public CreateConnectionResult(ClientConnectionDelegate delegate)
/*     */   {
/*  64 */     this(delegate, -2147483648);
/*     */   }
/*     */ 
/*     */   public CreateConnectionResult(int actualFailoverNodeID)
/*     */   {
/*  69 */     this(null, actualFailoverNodeID);
/*     */   }
/*     */ 
/*     */   private CreateConnectionResult(ClientConnectionDelegate delegate, int actualFailoverNodeId)
/*     */   {
/*  75 */     this.delegate = delegate;
/*  76 */     this.actualFailoverNodeID = actualFailoverNodeId;
/*     */   }
/*     */ 
/*     */   public ClientConnectionDelegate getDelegate()
/*     */   {
/*  83 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public int getActualFailoverNodeID()
/*     */   {
/*  88 */     return this.actualFailoverNodeID;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  93 */     return "CreateConnectionResult[" + this.delegate + ", failover node " + this.actualFailoverNodeID + "]";
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in)
/*     */     throws Exception
/*     */   {
/* 100 */     this.actualFailoverNodeID = in.readInt();
/*     */ 
/* 102 */     int b = in.readByte();
/*     */ 
/* 104 */     if (b == 1)
/*     */     {
/* 106 */       this.delegate = new ClientConnectionDelegate();
/*     */ 
/* 108 */       this.delegate.read(in);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/* 114 */     out.writeInt(this.actualFailoverNodeID);
/*     */ 
/* 116 */     if (this.delegate == null)
/*     */     {
/* 118 */       out.writeByte(0);
/*     */     }
/*     */     else
/*     */     {
/* 122 */       out.writeByte(1);
/*     */ 
/* 124 */       this.delegate.write(out);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.delegate.CreateConnectionResult
 * JD-Core Version:    0.6.0
 */