/*     */ package org.jboss.jms.client.state;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
/*     */ import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.jms.MessageListener;
/*     */ import org.jboss.jms.client.container.ClientConsumer;
/*     */ import org.jboss.jms.client.delegate.ClientBrowserDelegate;
/*     */ import org.jboss.jms.client.delegate.ClientConsumerDelegate;
/*     */ import org.jboss.jms.client.delegate.ClientProducerDelegate;
/*     */ import org.jboss.jms.client.delegate.ClientSessionDelegate;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.delegate.DeliveryInfo;
/*     */ import org.jboss.jms.delegate.DeliveryRecovery;
/*     */ import org.jboss.jms.delegate.SessionDelegate;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.jms.message.JBossMessage;
/*     */ import org.jboss.jms.message.MessageProxy;
/*     */ import org.jboss.jms.tx.MessagingXAResource;
/*     */ import org.jboss.jms.tx.ResourceManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.util.ClearableQueuedExecutor;
/*     */ import org.jboss.messaging.util.Version;
/*     */ 
/*     */ public class SessionState extends HierarchicalStateSupport
/*     */ {
/*  70 */   protected static Logger log = Logger.getLogger(SessionState.class);
/*     */   private ConnectionState parent;
/*     */   private SessionDelegate delegate;
/*     */   private String sessionID;
/*     */   private int acknowledgeMode;
/*     */   private boolean transacted;
/*     */   private boolean xa;
/*     */   private MessagingXAResource xaResource;
/*     */   private Object currentTxId;
/*     */   private ClearableQueuedExecutor executor;
/*     */   private boolean recoverCalled;
/*     */   private List clientAckList;
/*     */   private DeliveryInfo autoAckInfo;
/*     */   private Map callbackHandlers;
/*     */   private int dupsOKBatchSize;
/* 100 */   private LinkedList asfMessages = new LinkedList();
/*     */   private MessageListener sessionListener;
/* 110 */   private boolean treatAsNonTransactedWhenNotEnlisted = true;
/*     */   private long npSendSequence;
/*     */ 
/*     */   public SessionState(ConnectionState parent, ClientSessionDelegate delegate, boolean transacted, int ackMode, boolean xa, int dupsOKBatchSize)
/*     */   {
/* 120 */     super(parent, delegate);
/*     */ 
/* 122 */     this.sessionID = delegate.getID();
/*     */ 
/* 124 */     this.children = new HashSet();
/* 125 */     this.acknowledgeMode = ackMode;
/* 126 */     this.transacted = transacted;
/* 127 */     this.xa = xa;
/*     */ 
/* 129 */     this.dupsOKBatchSize = dupsOKBatchSize;
/*     */ 
/* 131 */     if (xa)
/*     */     {
/* 134 */       this.xaResource = new MessagingXAResource(parent.getResourceManager(), this);
/*     */     }
/*     */ 
/* 140 */     if (transacted)
/*     */     {
/* 143 */       this.currentTxId = parent.getResourceManager().createLocalTx();
/*     */     }
/*     */ 
/* 146 */     this.executor = new ClearableQueuedExecutor(new LinkedQueue());
/*     */ 
/* 148 */     this.clientAckList = new ArrayList();
/*     */ 
/* 152 */     this.callbackHandlers = new HashMap();
/*     */   }
/*     */ 
/*     */   public DelegateSupport getDelegate()
/*     */   {
/* 159 */     return (DelegateSupport)this.delegate;
/*     */   }
/*     */ 
/*     */   public void setDelegate(DelegateSupport delegate)
/*     */   {
/* 164 */     this.delegate = ((SessionDelegate)delegate);
/*     */   }
/*     */ 
/*     */   public HierarchicalState getParent()
/*     */   {
/* 169 */     return this.parent;
/*     */   }
/*     */ 
/*     */   public void setParent(HierarchicalState parent)
/*     */   {
/* 174 */     this.parent = ((ConnectionState)parent);
/*     */   }
/*     */ 
/*     */   public Version getVersionToUse()
/*     */   {
/* 179 */     return this.parent.getVersionToUse();
/*     */   }
/*     */ 
/*     */   public int getDupsOKBatchSize()
/*     */   {
/* 184 */     return this.dupsOKBatchSize;
/*     */   }
/*     */ 
/*     */   public MessageListener getDistinguishedListener()
/*     */   {
/* 189 */     return this.sessionListener;
/*     */   }
/*     */ 
/*     */   public void setDistinguishedListener(MessageListener listener)
/*     */   {
/* 194 */     this.sessionListener = listener;
/*     */   }
/*     */ 
/*     */   public LinkedList getASFMessages()
/*     */   {
/* 199 */     return this.asfMessages;
/*     */   }
/*     */ 
/*     */   public void synchronizeWith(HierarchicalState ns)
/*     */     throws Exception
/*     */   {
/* 206 */     SessionState newState = (SessionState)ns;
/*     */ 
/* 208 */     String oldSessionID = this.sessionID;
/* 209 */     this.sessionID = newState.sessionID;
/*     */ 
/* 211 */     this.npSendSequence = 0L;
/*     */ 
/* 216 */     this.executor.clearAllExceptCurrentTask();
/*     */ 
/* 218 */     ClientSessionDelegate newDelegate = (ClientSessionDelegate)newState.getDelegate();
/*     */ 
/* 220 */     for (Iterator i = getChildren().iterator(); i.hasNext(); )
/*     */     {
/* 222 */       HierarchicalState child = (HierarchicalState)i.next();
/*     */ 
/* 224 */       if ((child instanceof ConsumerState))
/*     */       {
/* 226 */         ConsumerState consState = (ConsumerState)child;
/* 227 */         ClientConsumerDelegate consDelegate = (ClientConsumerDelegate)consState.getDelegate();
/*     */ 
/* 230 */         ClientConsumerDelegate newConsDelegate = (ClientConsumerDelegate)newDelegate.createConsumerDelegate(consState.getDestination(), consState.getSelector(), consState.isNoLocal(), consState.getSubscriptionName(), consState.isConnectionConsumer(), true);
/*     */ 
/* 236 */         log.trace(this + " created new consumer " + newConsDelegate);
/*     */ 
/* 238 */         consDelegate.synchronizeWith(newConsDelegate);
/* 239 */         log.trace(this + " synchronized failover consumer " + consDelegate);
/*     */       }
/* 241 */       else if ((child instanceof ProducerState))
/*     */       {
/* 243 */         ProducerState prodState = (ProducerState)child;
/* 244 */         ClientProducerDelegate prodDelegate = (ClientProducerDelegate)prodState.getDelegate();
/*     */ 
/* 247 */         ClientProducerDelegate newProdDelegate = (ClientProducerDelegate)newDelegate.createProducerDelegate((JBossDestination)prodState.getDestination());
/*     */ 
/* 249 */         log.trace(this + " created new producer " + newProdDelegate);
/*     */ 
/* 251 */         prodDelegate.synchronizeWith(newProdDelegate);
/* 252 */         log.trace(this + " synchronized failover producer " + prodDelegate);
/*     */       }
/* 254 */       else if ((child instanceof BrowserState))
/*     */       {
/* 256 */         BrowserState browserState = (BrowserState)child;
/* 257 */         ClientBrowserDelegate browserDelegate = (ClientBrowserDelegate)browserState.getDelegate();
/*     */ 
/* 261 */         ClientBrowserDelegate newBrowserDelegate = (ClientBrowserDelegate)newDelegate.createBrowserDelegate(browserState.getJmsDestination(), browserState.getMessageSelector());
/*     */ 
/* 264 */         log.trace(this + " created new browser " + newBrowserDelegate);
/*     */ 
/* 266 */         browserDelegate.synchronizeWith(newBrowserDelegate);
/* 267 */         log.trace(this + " synchronized failover browser " + browserDelegate);
/*     */       }
/*     */     }
/*     */ 
/* 271 */     ConnectionState connState = (ConnectionState)getParent();
/* 272 */     ResourceManager rm = connState.getResourceManager();
/*     */ 
/* 275 */     rm.handleFailover(connState.getServerID(), oldSessionID, newState.sessionID);
/*     */ 
/* 277 */     List ackInfos = Collections.EMPTY_LIST;
/*     */ 
/* 279 */     if ((!isTransacted()) || ((isXA()) && (getCurrentTxId() == null)))
/*     */     {
/* 287 */       log.trace(this + " is not transacted (or XA with no transaction set), " + "retrieving deliveries from session state");
/*     */ 
/* 293 */       if (this.acknowledgeMode == 2)
/*     */       {
/* 295 */         for (Iterator i = getClientAckList().iterator(); i.hasNext(); )
/*     */         {
/* 297 */           DeliveryInfo info = (DeliveryInfo)i.next();
/* 298 */           if (!info.getMessageProxy().getMessage().isReliable())
/*     */           {
/* 300 */             i.remove();
/* 301 */             log.trace("removed non persistent delivery " + info);
/*     */           }
/*     */         }
/*     */ 
/* 305 */         ackInfos = getClientAckList();
/*     */       }
/*     */       else
/*     */       {
/* 309 */         DeliveryInfo autoAck = getAutoAckInfo();
/* 310 */         if (autoAck != null)
/*     */         {
/* 312 */           if (!autoAck.getMessageProxy().getMessage().isReliable())
/*     */           {
/* 315 */             setAutoAckInfo(null);
/*     */           }
/*     */           else
/*     */           {
/* 320 */             ackInfos = new ArrayList();
/* 321 */             ackInfos.add(autoAck);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 326 */       log.trace(this + " retrieved " + ackInfos.size() + " deliveries");
/*     */     }
/*     */     else
/*     */     {
/* 333 */       ackInfos = rm.getDeliveriesForSession(getSessionID());
/*     */     }
/*     */ 
/* 336 */     List recoveryInfos = new ArrayList();
/*     */     Iterator i;
/* 337 */     if (!ackInfos.isEmpty())
/*     */     {
/* 339 */       for (i = ackInfos.iterator(); i.hasNext(); )
/*     */       {
/* 341 */         DeliveryInfo del = (DeliveryInfo)i.next();
/* 342 */         DeliveryRecovery recInfo = new DeliveryRecovery(del.getMessageProxy().getDeliveryId(), del.getMessageProxy().getMessage().getMessageID(), del.getQueueName());
/*     */ 
/* 347 */         recoveryInfos.add(recInfo);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 354 */     log.trace(this + " sending delivery recovery " + recoveryInfos + " on failover");
/*     */ 
/* 357 */     if ((this.transacted) || (this.xa) || (this.acknowledgeMode == 2))
/*     */     {
/* 359 */       newDelegate.recoverDeliveries(recoveryInfos, oldSessionID);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setTreatAsNonTransactedWhenNotEnlisted(boolean b)
/*     */   {
/* 367 */     this.treatAsNonTransactedWhenNotEnlisted = b;
/*     */   }
/*     */ 
/*     */   public boolean getTreatAsNonTransactedWhenNotEnlisted()
/*     */   {
/* 372 */     return this.treatAsNonTransactedWhenNotEnlisted;
/*     */   }
/*     */ 
/*     */   public List getClientAckList()
/*     */   {
/* 380 */     return this.clientAckList;
/*     */   }
/*     */ 
/*     */   public void setClientAckList(List list)
/*     */   {
/* 385 */     this.clientAckList = list;
/*     */   }
/*     */ 
/*     */   public DeliveryInfo getAutoAckInfo()
/*     */   {
/* 390 */     return this.autoAckInfo;
/*     */   }
/*     */ 
/*     */   public void setAutoAckInfo(DeliveryInfo info)
/*     */   {
/* 395 */     if ((info != null) && (this.autoAckInfo != null))
/*     */     {
/* 397 */       throw new IllegalStateException("There is already a delivery set for auto ack " + System.identityHashCode(this) + " xa: " + this.xa);
/*     */     }
/*     */ 
/* 400 */     this.autoAckInfo = info;
/*     */   }
/*     */ 
/*     */   public int getAcknowledgeMode()
/*     */   {
/* 405 */     return this.acknowledgeMode;
/*     */   }
/*     */ 
/*     */   public boolean isTransacted()
/*     */   {
/* 410 */     return this.transacted;
/*     */   }
/*     */ 
/*     */   public boolean isXA()
/*     */   {
/* 415 */     return this.xa;
/*     */   }
/*     */ 
/*     */   public MessagingXAResource getXAResource()
/*     */   {
/* 420 */     return this.xaResource;
/*     */   }
/*     */ 
/*     */   public QueuedExecutor getExecutor()
/*     */   {
/* 425 */     return this.executor;
/*     */   }
/*     */ 
/*     */   public Object getCurrentTxId()
/*     */   {
/* 430 */     return this.currentTxId;
/*     */   }
/*     */ 
/*     */   public boolean isRecoverCalled()
/*     */   {
/* 435 */     return this.recoverCalled;
/*     */   }
/*     */ 
/*     */   public void setCurrentTxId(Object id)
/*     */   {
/* 440 */     this.currentTxId = id;
/*     */   }
/*     */ 
/*     */   public void setRecoverCalled(boolean recoverCalled)
/*     */   {
/* 445 */     this.recoverCalled = recoverCalled;
/*     */   }
/*     */ 
/*     */   public ClientConsumer getCallbackHandler(String consumerID)
/*     */   {
/* 450 */     return (ClientConsumer)this.callbackHandlers.get(consumerID);
/*     */   }
/*     */ 
/*     */   public void addCallbackHandler(ClientConsumer handler)
/*     */   {
/* 455 */     this.callbackHandlers.put(handler.getConsumerId(), handler);
/*     */   }
/*     */ 
/*     */   public void removeCallbackHandler(ClientConsumer handler)
/*     */   {
/* 460 */     this.callbackHandlers.remove(handler.getConsumerId());
/*     */   }
/*     */ 
/*     */   public String getSessionID()
/*     */   {
/* 465 */     return this.sessionID;
/*     */   }
/*     */ 
/*     */   public long getNPSendSequence()
/*     */   {
/* 470 */     return this.npSendSequence;
/*     */   }
/*     */ 
/*     */   public void incNpSendSequence()
/*     */   {
/* 475 */     this.npSendSequence += 1L;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 480 */     return "SessionState[" + this.sessionID + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.state.SessionState
 * JD-Core Version:    0.6.0
 */