/*     */ package org.jboss.jms.client.state;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import javax.jms.Destination;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.delegate.ProducerDelegate;
/*     */ import org.jboss.messaging.util.Version;
/*     */ 
/*     */ public class ProducerState extends HierarchicalStateSupport
/*     */ {
/*     */   private Destination destination;
/*  54 */   private boolean disableMessageID = false;
/*  55 */   private boolean disableMessageTimestamp = false;
/*  56 */   private int priority = 4;
/*  57 */   private long timeToLive = 0L;
/*  58 */   private int deliveryMode = 2;
/*     */   private int strictTCK;
/*     */   private SessionState parent;
/*     */   private ProducerDelegate delegate;
/*     */ 
/*     */   public ProducerState(SessionState parent, ProducerDelegate delegate, Destination dest)
/*     */   {
/*  68 */     super(parent, (DelegateSupport)delegate);
/*  69 */     this.children = Collections.EMPTY_SET;
/*  70 */     this.destination = dest;
/*     */   }
/*     */ 
/*     */   public DelegateSupport getDelegate()
/*     */   {
/*  77 */     return (DelegateSupport)this.delegate;
/*     */   }
/*     */ 
/*     */   public void setDelegate(DelegateSupport delegate)
/*     */   {
/*  82 */     this.delegate = ((ProducerDelegate)delegate);
/*     */   }
/*     */ 
/*     */   public void setParent(HierarchicalState parent)
/*     */   {
/*  87 */     this.parent = ((SessionState)parent);
/*     */   }
/*     */ 
/*     */   public HierarchicalState getParent()
/*     */   {
/*  92 */     return this.parent;
/*     */   }
/*     */ 
/*     */   public Version getVersionToUse()
/*     */   {
/*  97 */     return this.parent.getVersionToUse();
/*     */   }
/*     */ 
/*     */   public void synchronizeWith(HierarchicalState newState)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public Destination getDestination()
/*     */   {
/* 111 */     return this.destination;
/*     */   }
/*     */ 
/*     */   public void setDestination(Destination dest)
/*     */   {
/* 116 */     this.destination = dest;
/*     */   }
/*     */ 
/*     */   public boolean isDisableMessageID()
/*     */   {
/* 121 */     return this.disableMessageID;
/*     */   }
/*     */ 
/*     */   public void setDisableMessageID(boolean disableMessageID)
/*     */   {
/* 126 */     this.disableMessageID = disableMessageID;
/*     */   }
/*     */ 
/*     */   public boolean isDisableMessageTimestamp()
/*     */   {
/* 131 */     return this.disableMessageTimestamp;
/*     */   }
/*     */ 
/*     */   public void setDisableMessageTimestamp(boolean disableMessageTimestamp)
/*     */   {
/* 136 */     this.disableMessageTimestamp = disableMessageTimestamp;
/*     */   }
/*     */ 
/*     */   public int getPriority()
/*     */   {
/* 141 */     return this.priority;
/*     */   }
/*     */ 
/*     */   public void setPriority(int priority)
/*     */   {
/* 146 */     this.priority = priority;
/*     */   }
/*     */ 
/*     */   public long getTimeToLive()
/*     */   {
/* 151 */     return this.timeToLive;
/*     */   }
/*     */ 
/*     */   public void setTimeToLive(long timeToLive)
/*     */   {
/* 156 */     this.timeToLive = timeToLive;
/*     */   }
/*     */ 
/*     */   public int getDeliveryMode()
/*     */   {
/* 161 */     return this.deliveryMode;
/*     */   }
/*     */ 
/*     */   public void setDeliveryMode(int deliveryMode)
/*     */   {
/* 166 */     this.deliveryMode = deliveryMode;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.state.ProducerState
 * JD-Core Version:    0.6.0
 */