/*     */ package org.jboss.jms.client.state;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.SyncSet;
/*     */ import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.jms.client.FailoverCommandCenter;
/*     */ import org.jboss.jms.client.delegate.ClientConnectionDelegate;
/*     */ import org.jboss.jms.client.delegate.ClientSessionDelegate;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.client.remoting.ConsolidatedRemotingConnectionListener;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.delegate.ConnectionDelegate;
/*     */ import org.jboss.jms.delegate.ConnectionFactoryDelegate;
/*     */ import org.jboss.jms.message.MessageIdGenerator;
/*     */ import org.jboss.jms.tx.ResourceManager;
/*     */ import org.jboss.jms.tx.ResourceManagerFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.util.Version;
/*     */ 
/*     */ public class ConnectionState extends HierarchicalStateSupport
/*     */ {
/*  58 */   private static final Logger log = Logger.getLogger(ConnectionState.class);
/*     */   private int serverID;
/*     */   private Version versionToUse;
/*     */   private ConnectionDelegate delegate;
/*     */   protected boolean started;
/*  72 */   private boolean justCreated = true;
/*     */   private String clientID;
/*     */   private JMSRemotingConnection remotingConnection;
/*     */   private ResourceManager resourceManager;
/*     */   private MessageIdGenerator idGenerator;
/*     */   private transient String username;
/*     */   private transient String password;
/*     */   private ConnectionFactoryDelegate clusteredConnectionFactoryDelegate;
/*     */   private FailoverCommandCenter fcc;
/*     */ 
/*     */   public ConnectionState(int serverID, ConnectionDelegate delegate, JMSRemotingConnection remotingConnection, Version versionToUse, MessageIdGenerator gen)
/*     */     throws Exception
/*     */   {
/* 101 */     super(null, (DelegateSupport)delegate);
/*     */ 
/* 103 */     if (log.isTraceEnabled()) log.trace(this + " constructing connection state");
/*     */ 
/* 105 */     this.children = new SyncSet(new HashSet(), new WriterPreferenceReadWriteLock());
/*     */ 
/* 107 */     this.remotingConnection = remotingConnection;
/* 108 */     this.versionToUse = versionToUse;
/*     */ 
/* 113 */     this.resourceManager = ResourceManagerFactory.instance.checkOutResourceManager(serverID);
/*     */ 
/* 115 */     this.idGenerator = gen;
/* 116 */     this.serverID = serverID;
/*     */   }
/*     */ 
/*     */   public DelegateSupport getDelegate()
/*     */   {
/* 123 */     return (DelegateSupport)this.delegate;
/*     */   }
/*     */ 
/*     */   public void setDelegate(DelegateSupport delegate)
/*     */   {
/* 128 */     this.delegate = ((ConnectionDelegate)delegate);
/*     */   }
/*     */ 
/*     */   public HierarchicalState getParent()
/*     */   {
/* 134 */     return null;
/*     */   }
/*     */ 
/*     */   public void setParent(HierarchicalState parent)
/*     */   {
/*     */   }
/*     */ 
/*     */   public Version getVersionToUse()
/*     */   {
/* 144 */     return this.versionToUse;
/*     */   }
/*     */ 
/*     */   public void synchronizeWith(HierarchicalState ns) throws Exception
/*     */   {
/* 149 */     ConnectionState newState = (ConnectionState)ns;
/*     */ 
/* 151 */     this.remotingConnection = newState.remotingConnection;
/* 152 */     this.idGenerator = newState.idGenerator;
/* 153 */     this.serverID = newState.serverID;
/* 154 */     this.versionToUse = newState.versionToUse;
/*     */ 
/* 158 */     this.remotingConnection.getConnectionListener().setConnectionState(this);
/*     */ 
/* 160 */     ConnectionDelegate newDelegate = (ConnectionDelegate)newState.getDelegate();
/*     */ 
/* 162 */     for (Iterator i = getChildren().iterator(); i.hasNext(); )
/*     */     {
/* 164 */       SessionState sessionState = (SessionState)i.next();
/*     */ 
/* 166 */       ClientSessionDelegate sessionDelegate = (ClientSessionDelegate)sessionState.getDelegate();
/*     */ 
/* 169 */       ClientSessionDelegate newSessionDelegate = (ClientSessionDelegate)newDelegate.createSessionDelegate(sessionState.isTransacted(), sessionState.getAcknowledgeMode(), sessionState.isXA());
/*     */ 
/* 174 */       sessionDelegate.synchronizeWith(newSessionDelegate);
/*     */     }
/*     */ 
/* 178 */     this.fcc = newState.fcc;
/* 179 */     this.fcc.setState(this);
/*     */   }
/*     */ 
/*     */   public ResourceManager getResourceManager()
/*     */   {
/* 186 */     return this.resourceManager;
/*     */   }
/*     */ 
/*     */   public MessageIdGenerator getIdGenerator()
/*     */   {
/* 191 */     return this.idGenerator;
/*     */   }
/*     */ 
/*     */   public JMSRemotingConnection getRemotingConnection()
/*     */   {
/* 196 */     return this.remotingConnection;
/*     */   }
/*     */ 
/*     */   public int getServerID()
/*     */   {
/* 201 */     return this.serverID;
/*     */   }
/*     */ 
/*     */   public boolean isStarted()
/*     */   {
/* 206 */     return this.started;
/*     */   }
/*     */ 
/*     */   public void setStarted(boolean started)
/*     */   {
/* 211 */     this.started = started;
/*     */   }
/*     */ 
/*     */   public String getPassword()
/*     */   {
/* 216 */     return this.password;
/*     */   }
/*     */ 
/*     */   public void setPassword(String password)
/*     */   {
/* 221 */     this.password = password;
/*     */   }
/*     */ 
/*     */   public String getUsername()
/*     */   {
/* 226 */     return this.username;
/*     */   }
/*     */ 
/*     */   public void setUsername(String username)
/*     */   {
/* 231 */     this.username = username;
/*     */   }
/*     */ 
/*     */   public String getClientID()
/*     */   {
/* 236 */     return this.clientID;
/*     */   }
/*     */ 
/*     */   public void setClientID(String clientID)
/*     */   {
/* 241 */     this.clientID = clientID;
/*     */   }
/*     */ 
/*     */   public boolean isJustCreated()
/*     */   {
/* 246 */     return this.justCreated;
/*     */   }
/*     */ 
/*     */   public void setJustCreated(boolean justCreated)
/*     */   {
/* 251 */     this.justCreated = justCreated;
/*     */   }
/*     */ 
/*     */   public void setClusteredConnectionFactoryDeleage(ConnectionFactoryDelegate d)
/*     */   {
/* 256 */     this.clusteredConnectionFactoryDelegate = d;
/*     */   }
/*     */ 
/*     */   public ConnectionFactoryDelegate getClusteredConnectionFactoryDelegate()
/*     */   {
/* 261 */     return this.clusteredConnectionFactoryDelegate;
/*     */   }
/*     */ 
/*     */   public FailoverCommandCenter getFailoverCommandCenter()
/*     */   {
/* 266 */     return this.fcc;
/*     */   }
/*     */ 
/*     */   public void initializeFailoverCommandCenter()
/*     */   {
/* 271 */     this.fcc = new FailoverCommandCenter(this);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 276 */     return "ConnectionState[" + ((ClientConnectionDelegate)this.delegate).getID() + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.state.ConnectionState
 * JD-Core Version:    0.6.0
 */