/*     */ package org.jboss.jms.client.remoting;
/*     */ 
/*     */ import javax.jms.ExceptionListener;
/*     */ import javax.jms.JMSException;
/*     */ import org.jboss.jms.client.container.ConnectionFailureListener;
/*     */ import org.jboss.jms.client.state.ConnectionState;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.ConnectionListener;
/*     */ 
/*     */ public class ConsolidatedRemotingConnectionListener
/*     */   implements ConnectionListener
/*     */ {
/*  34 */   private static final Logger log = Logger.getLogger(ConsolidatedRemotingConnectionListener.class);
/*     */   private ConnectionState state;
/*     */   private ExceptionListener jmsExceptionListener;
/*     */   private ConnectionFailureListener remotingListener;
/*     */ 
/*     */   public void handleConnectionException(Throwable throwable, Client client)
/*     */   {
/*     */     ExceptionListener jmsExceptionListenerCopy;
/*     */     ConnectionFailureListener remotingListenerCopy;
/*  63 */     synchronized (this)
/*     */     {
/*  65 */       jmsExceptionListenerCopy = this.jmsExceptionListener;
/*     */ 
/*  67 */       remotingListenerCopy = this.remotingListener;
/*     */     }
/*     */ 
/*  70 */     boolean forwardToJMSListener = true;
/*     */ 
/*  72 */     if (remotingListenerCopy != null)
/*     */     {
/*     */       try
/*     */       {
/*  76 */         log.trace(this + " forwarding remoting failure \"" + throwable + "\" to " + remotingListenerCopy);
/*     */ 
/*  81 */         forwardToJMSListener = !remotingListenerCopy.handleConnectionException(throwable, client);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  85 */         log.warn("Failed to forward " + throwable + " to " + remotingListenerCopy, e);
/*     */       }
/*     */     }
/*     */ 
/*  89 */     if ((forwardToJMSListener) && (jmsExceptionListenerCopy != null))
/*     */     {
/*  91 */       JMSException jmsException = null;
/*     */ 
/*  93 */       if ((throwable instanceof Error))
/*     */       {
/*  95 */         String msg = "Caught Error on underlying remoting connection";
/*  96 */         log.error(this + ": " + "Caught Error on underlying remoting connection", throwable);
/*  97 */         jmsException = new JMSException("Caught Error on underlying remoting connection: " + throwable.getMessage());
/*     */       }
/*  99 */       else if ((throwable instanceof Exception))
/*     */       {
/* 101 */         Exception e = (Exception)throwable;
/* 102 */         jmsException = new JMSException("Failure on underlying remoting connection");
/* 103 */         jmsException.setLinkedException(e);
/*     */       }
/*     */       else
/*     */       {
/* 108 */         String msg = "Caught Throwable on underlying remoting connection";
/* 109 */         log.error(this + ": " + "Caught Throwable on underlying remoting connection", throwable);
/* 110 */         jmsException = new JMSException("Caught Throwable on underlying remoting connection: " + throwable.getMessage());
/*     */       }
/*     */ 
/* 113 */       jmsExceptionListenerCopy.onException(jmsException);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void setDelegateListener(ConnectionFailureListener l)
/*     */   {
/* 121 */     log.trace(this + " setting delegate listener " + l);
/*     */ 
/* 123 */     if (this.remotingListener != null)
/*     */     {
/* 125 */       throw new IllegalStateException("There is already a connection listener for the connection");
/*     */     }
/*     */ 
/* 128 */     this.remotingListener = l;
/*     */   }
/*     */ 
/*     */   public synchronized void addJMSExceptionListener(ExceptionListener jmsExceptionListener)
/*     */   {
/* 133 */     log.trace(this + " adding JMS exception listener " + jmsExceptionListener);
/* 134 */     this.jmsExceptionListener = jmsExceptionListener;
/*     */   }
/*     */ 
/*     */   public synchronized ExceptionListener getJMSExceptionListener()
/*     */   {
/* 139 */     return this.jmsExceptionListener;
/*     */   }
/*     */ 
/*     */   public synchronized void clear()
/*     */   {
/* 147 */     this.jmsExceptionListener = null;
/* 148 */     this.remotingListener = null;
/* 149 */     log.trace(this + " cleared");
/*     */   }
/*     */ 
/*     */   public void setConnectionState(ConnectionState state)
/*     */   {
/* 154 */     this.state = state;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 159 */     if (this.state == null)
/*     */     {
/* 161 */       return "ConsolidatedListener(UNINITIALIZED)";
/*     */     }
/* 163 */     return this.state + ".ConsolidatedListener";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.remoting.ConsolidatedRemotingConnectionListener
 * JD-Core Version:    0.6.0
 */