/*     */ package org.jboss.jms.client.remoting;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import org.jboss.jms.client.delegate.ClientClusteredConnectionFactoryDelegate;
/*     */ import org.jboss.jms.delegate.TopologyResult;
/*     */ import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.ConnectionListener;
/*     */ 
/*     */ public class ConnectionFactoryCallbackHandler
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(ConnectionFactoryCallbackHandler.class);
/*     */   private WeakReference<ClientClusteredConnectionFactoryDelegate> delegateRef;
/*     */   private JMSRemotingConnection remotingConnection;
/*  53 */   private static boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public ConnectionFactoryCallbackHandler(ClientClusteredConnectionFactoryDelegate cfDelegate, JMSRemotingConnection remotingConnection)
/*     */   {
/*  60 */     this.delegateRef = new WeakReference(cfDelegate);
/*  61 */     this.remotingConnection = remotingConnection;
/*  62 */     this.remotingConnection.addPlainConnectionListener(new CallbackConnectionListener());
/*     */   }
/*     */ 
/*     */   public void handleMessage(Object message)
/*     */   {
/*  69 */     if (trace) log.trace(this + " handling " + message);
/*     */ 
/*  71 */     ConnectionFactoryUpdate viewChange = (ConnectionFactoryUpdate)message;
/*     */ 
/*  73 */     ClientClusteredConnectionFactoryDelegate delegate = (ClientClusteredConnectionFactoryDelegate)this.delegateRef.get();
/*     */ 
/*  75 */     if (delegate != null)
/*     */     {
/*  77 */       delegate.updateFailoverInfo(viewChange.getTopology().getDelegates(), viewChange.getTopology().getFailoverMap());
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  85 */     return "ConnectionFactoryCallbackHandler[" + this.delegateRef.get() + "]";
/*     */   }
/*     */ 
/*     */   class CallbackConnectionListener
/*     */     implements ConnectionListener
/*     */   {
/*     */     CallbackConnectionListener()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void handleConnectionException(Throwable throwable, Client client)
/*     */     {
/* 101 */       ClientClusteredConnectionFactoryDelegate delegate = (ClientClusteredConnectionFactoryDelegate)ConnectionFactoryCallbackHandler.this.delegateRef.get();
/*     */ 
/* 103 */       if (delegate != null)
/*     */       {
/* 105 */         delegate.establishCallback();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.remoting.ConnectionFactoryCallbackHandler
 * JD-Core Version:    0.6.0
 */