/*     */ package org.jboss.jms.client.remoting;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.jms.client.container.ClientConsumer;
/*     */ import org.jboss.jms.message.JBossMessage;
/*     */ import org.jboss.jms.message.MessageProxy;
/*     */ import org.jboss.jms.wireformat.ClientDelivery;
/*     */ import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Message;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.HandleCallbackException;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ 
/*     */ public class CallbackManager
/*     */   implements InvokerCallbackHandler
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(CallbackManager.class);
/*     */   public static final String JMS_CALLBACK_SUBSYSTEM = "CALLBACK";
/*  63 */   private static boolean trace = log.isTraceEnabled();
/*     */   protected Map<String, ClientConsumer> callbackHandlers;
/*     */   protected ConnectionFactoryCallbackHandler connectionfactoryCallbackHandler;
/*     */ 
/*     */   public CallbackManager()
/*     */   {
/*  74 */     this.callbackHandlers = new ConcurrentReaderHashMap();
/*     */   }
/*     */ 
/*     */   public void handleCallback(Callback callback)
/*     */     throws HandleCallbackException
/*     */   {
/*  81 */     Object parameter = callback.getParameter();
/*     */ 
/*  83 */     if ((parameter instanceof ClientDelivery))
/*     */     {
/*  85 */       ClientDelivery dr = (ClientDelivery)parameter;
/*     */ 
/*  87 */       Message msg = dr.getMessage();
/*     */ 
/*  89 */       MessageProxy proxy = JBossMessage.createThinDelegate(dr.getDeliveryId(), (JBossMessage)msg, dr.getDeliveryCount());
/*     */ 
/*  92 */       ClientConsumer handler = (ClientConsumer)this.callbackHandlers.get(dr.getConsumerId());
/*     */ 
/*  95 */       if (handler == null)
/*     */       {
/* 100 */         throw new IllegalStateException(this + " callback handler not found, message arrived after consumer is closed.");
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 105 */         handler.handleMessage(proxy);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 109 */         log.error("Failed to handle message", e);
/* 110 */         throw new HandleCallbackException(e.getMessage(), e);
/*     */       }
/*     */     }
/* 113 */     else if ((parameter instanceof ConnectionFactoryUpdate))
/*     */     {
/* 115 */       if (this.connectionfactoryCallbackHandler == null)
/*     */       {
/* 117 */         log.warn("ConnectionFactoryUpdate was received but there is no callbackHandler set");
/*     */       }
/*     */       else
/*     */       {
/* 121 */         ConnectionFactoryUpdate viewChange = (ConnectionFactoryUpdate)parameter;
/*     */ 
/* 123 */         if (trace) log.trace(this + " receiving cluster view change " + viewChange);
/*     */ 
/* 125 */         this.connectionfactoryCallbackHandler.handleMessage(viewChange);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 130 */       throw new HandleCallbackException("Unknow callback type: " + callback);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void registerHandler(String consumerID, ClientConsumer handler)
/*     */   {
/* 138 */     this.callbackHandlers.put(consumerID, handler);
/*     */   }
/*     */ 
/*     */   public ClientConsumer unregisterHandler(String consumerID)
/*     */   {
/* 143 */     return (ClientConsumer)this.callbackHandlers.remove(consumerID);
/*     */   }
/*     */ 
/*     */   public ConnectionFactoryCallbackHandler getConnectionfactoryCallbackHandler()
/*     */   {
/* 149 */     return this.connectionfactoryCallbackHandler;
/*     */   }
/*     */ 
/*     */   public void setConnectionfactoryCallbackHandler(ConnectionFactoryCallbackHandler connectionfactoryCallbackHandler)
/*     */   {
/* 154 */     this.connectionfactoryCallbackHandler = connectionfactoryCallbackHandler;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 159 */     return "CallbackManager[" + Integer.toHexString(hashCode()) + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.remoting.CallbackManager
 * JD-Core Version:    0.6.0
 */