/*    */ package org.jboss.jms.client.plugin;
/*    */ 
/*    */ import java.util.Random;
/*    */ import org.jboss.jms.delegate.ConnectionFactoryDelegate;
/*    */ 
/*    */ public class RoundRobinLoadBalancingPolicy
/*    */   implements LoadBalancingPolicy
/*    */ {
/*    */   private static final long serialVersionUID = 5215940403016586462L;
/* 29 */   private static final Random random = new Random();
/*    */   private int next;
/*    */   private ConnectionFactoryDelegate[] delegates;
/*    */ 
/*    */   public RoundRobinLoadBalancingPolicy(ConnectionFactoryDelegate[] delegates)
/*    */   {
/* 40 */     this.next = -1;
/* 41 */     this.delegates = delegates;
/*    */   }
/*    */ 
/*    */   public synchronized ConnectionFactoryDelegate getNext()
/*    */   {
/* 48 */     if (this.next >= this.delegates.length)
/*    */     {
/* 50 */       this.next = 0;
/*    */     }
/*    */ 
/* 53 */     if (this.next < 0)
/*    */     {
/* 55 */       this.next = random.nextInt(this.delegates.length);
/*    */     }
/*    */ 
/* 58 */     return this.delegates[(this.next++)];
/*    */   }
/*    */ 
/*    */   public synchronized void updateView(ConnectionFactoryDelegate[] delegates)
/*    */   {
/* 63 */     this.next = -1;
/* 64 */     this.delegates = delegates;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.plugin.RoundRobinLoadBalancingPolicy
 * JD-Core Version:    0.6.0
 */