/*     */ package org.jboss.jms.client.container;
/*     */ 
/*     */ import javax.jms.Destination;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.client.delegate.ClientBrowserDelegate;
/*     */ import org.jboss.jms.client.delegate.ClientConnectionDelegate;
/*     */ import org.jboss.jms.client.delegate.ClientConsumerDelegate;
/*     */ import org.jboss.jms.client.delegate.ClientProducerDelegate;
/*     */ import org.jboss.jms.client.delegate.ClientSessionDelegate;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.client.remoting.ConsolidatedRemotingConnectionListener;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.client.state.BrowserState;
/*     */ import org.jboss.jms.client.state.ConnectionState;
/*     */ import org.jboss.jms.client.state.ConsumerState;
/*     */ import org.jboss.jms.client.state.HierarchicalState;
/*     */ import org.jboss.jms.client.state.ProducerState;
/*     */ import org.jboss.jms.client.state.SessionState;
/*     */ import org.jboss.jms.delegate.CreateConnectionResult;
/*     */ import org.jboss.jms.delegate.ProducerDelegate;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.jms.message.MessageIdGenerator;
/*     */ import org.jboss.jms.message.MessageIdGeneratorFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.util.Version;
/*     */ 
/*     */ public class StateCreationAspect
/*     */ {
/*  69 */   private static final Logger log = Logger.getLogger(StateCreationAspect.class);
/*     */ 
/*  73 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public Object handleCreateConnectionDelegate(Invocation inv)
/*     */     throws Throwable
/*     */   {
/*  83 */     CreateConnectionResult res = (CreateConnectionResult)inv.invokeNext();
/*     */ 
/*  85 */     ClientConnectionDelegate connectionDelegate = res.getDelegate();
/*     */ 
/*  87 */     if ((connectionDelegate != null) && (connectionDelegate.getState() == null))
/*     */     {
/*  91 */       if (this.trace) log.trace(connectionDelegate + " not configured, configuring ...");
/*     */ 
/*  93 */       int serverID = connectionDelegate.getServerID();
/*  94 */       Version versionToUse = connectionDelegate.getVersionToUse();
/*  95 */       JMSRemotingConnection remotingConnection = connectionDelegate.getRemotingConnection();
/*     */ 
/* 100 */       ConsolidatedRemotingConnectionListener listener = new ConsolidatedRemotingConnectionListener();
/*     */ 
/* 103 */       remotingConnection.addConnectionListener(listener);
/*     */ 
/* 105 */       if (versionToUse == null)
/*     */       {
/* 107 */         throw new IllegalStateException("Connection version is null");
/*     */       }
/*     */ 
/* 111 */       MessageIdGenerator idGenerator = MessageIdGeneratorFactory.instance.checkOutGenerator(serverID);
/*     */ 
/* 114 */       ConnectionState connectionState = new ConnectionState(serverID, connectionDelegate, remotingConnection, versionToUse, idGenerator);
/*     */ 
/* 118 */       listener.setConnectionState(connectionState);
/*     */ 
/* 120 */       connectionDelegate.setState(connectionState);
/*     */     }
/*     */ 
/* 123 */     return res;
/*     */   }
/*     */ 
/*     */   public Object handleCreateSessionDelegate(Invocation invocation) throws Throwable
/*     */   {
/* 128 */     ClientSessionDelegate sessionDelegate = (ClientSessionDelegate)invocation.invokeNext();
/* 129 */     DelegateSupport delegate = sessionDelegate;
/*     */ 
/* 131 */     ConnectionState connectionState = (ConnectionState)getState(invocation);
/*     */ 
/* 133 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 134 */     boolean transacted = ((Boolean)mi.getArguments()[0]).booleanValue();
/* 135 */     int ackMode = ((Integer)mi.getArguments()[1]).intValue();
/* 136 */     boolean xa = ((Boolean)mi.getArguments()[2]).booleanValue();
/*     */ 
/* 138 */     SessionState sessionState = new SessionState(connectionState, sessionDelegate, transacted, ackMode, xa, sessionDelegate.getDupsOKBatchSize());
/*     */ 
/* 142 */     delegate.setState(sessionState);
/* 143 */     return delegate;
/*     */   }
/*     */ 
/*     */   public Object handleCreateConsumerDelegate(Invocation invocation) throws Throwable
/*     */   {
/* 148 */     ClientConsumerDelegate consumerDelegate = (ClientConsumerDelegate)invocation.invokeNext();
/* 149 */     DelegateSupport delegate = consumerDelegate;
/*     */ 
/* 151 */     SessionState sessionState = (SessionState)getState(invocation);
/*     */ 
/* 153 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 154 */     JBossDestination dest = (JBossDestination)mi.getArguments()[0];
/* 155 */     String selector = (String)mi.getArguments()[1];
/* 156 */     boolean noLocal = ((Boolean)mi.getArguments()[2]).booleanValue();
/* 157 */     String subscriptionName = (String)mi.getArguments()[3];
/* 158 */     boolean connectionConsumer = ((Boolean)mi.getArguments()[4]).booleanValue();
/*     */ 
/* 160 */     String consumerID = consumerDelegate.getID();
/* 161 */     int bufferSize = consumerDelegate.getBufferSize();
/* 162 */     int maxDeliveries = consumerDelegate.getMaxDeliveries();
/* 163 */     long redeliveryDelay = consumerDelegate.getRedeliveryDelay();
/*     */ 
/* 165 */     ConsumerState consumerState = new ConsumerState(sessionState, consumerDelegate, dest, selector, noLocal, subscriptionName, consumerID, connectionConsumer, bufferSize, maxDeliveries, redeliveryDelay);
/*     */ 
/* 170 */     delegate.setState(consumerState);
/* 171 */     return consumerDelegate;
/*     */   }
/*     */ 
/*     */   public Object handleCreateProducerDelegate(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 178 */     ProducerDelegate producerDelegate = new ClientProducerDelegate();
/* 179 */     DelegateSupport delegate = (DelegateSupport)producerDelegate;
/*     */ 
/* 181 */     SessionState sessionState = (SessionState)getState(invocation);
/*     */ 
/* 183 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 184 */     Destination dest = (Destination)mi.getArguments()[0];
/*     */ 
/* 186 */     ProducerState producerState = new ProducerState(sessionState, producerDelegate, dest);
/*     */ 
/* 188 */     delegate.setState(producerState);
/*     */ 
/* 193 */     producerDelegate.getDeliveryMode();
/*     */ 
/* 195 */     return producerDelegate;
/*     */   }
/*     */ 
/*     */   public Object handleCreateBrowserDelegate(Invocation invocation) throws Throwable
/*     */   {
/* 200 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 202 */     ClientBrowserDelegate browserDelegate = (ClientBrowserDelegate)invocation.invokeNext();
/* 203 */     DelegateSupport delegate = browserDelegate;
/*     */ 
/* 205 */     SessionState sessionState = (SessionState)getState(invocation);
/*     */ 
/* 207 */     JBossDestination destination = (JBossDestination)mi.getArguments()[0];
/* 208 */     String selector = (String)mi.getArguments()[1];
/*     */ 
/* 210 */     BrowserState state = new BrowserState(sessionState, browserDelegate, destination, selector);
/*     */ 
/* 213 */     delegate.setState(state);
/* 214 */     return browserDelegate;
/*     */   }
/*     */ 
/*     */   private HierarchicalState getState(Invocation inv)
/*     */   {
/* 225 */     return ((DelegateSupport)inv.getTargetObject()).getState();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.StateCreationAspect
 * JD-Core Version:    0.6.0
 */