/*     */ package org.jboss.jms.client.container;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.client.FailoverCommandCenter;
/*     */ import org.jboss.jms.client.FailoverValve2;
/*     */ import org.jboss.jms.client.FailureDetector;
/*     */ import org.jboss.jms.client.delegate.ClientConnectionDelegate;
/*     */ import org.jboss.jms.client.delegate.ClientSessionDelegate;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.client.state.ConnectionState;
/*     */ import org.jboss.jms.client.state.HierarchicalState;
/*     */ import org.jboss.jms.exception.MessagingNetworkFailureException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class FailoverValveInterceptor
/*     */   implements Interceptor, FailureDetector
/*     */ {
/*  46 */   private static final Logger log = Logger.getLogger(FailoverValveInterceptor.class);
/*     */ 
/*  50 */   private static boolean trace = log.isTraceEnabled();
/*     */   private DelegateSupport delegate;
/*     */   private ConnectionState connectionState;
/*     */ 
/*     */   public String getName()
/*     */   {
/*  67 */     return "FailoverValveInterceptor";
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  74 */     if (this.connectionState == null)
/*     */     {
/*  76 */       this.delegate = ((DelegateSupport)invocation.getTargetObject());
/*     */ 
/*  78 */       HierarchicalState hs = this.delegate.getState();
/*  79 */       while ((hs != null) && (!(hs instanceof ConnectionState)))
/*     */       {
/*  81 */         hs = hs.getParent();
/*     */       }
/*     */ 
/*  84 */       this.connectionState = ((ConnectionState)hs);
/*     */     }
/*     */ 
/*  87 */     FailoverCommandCenter fcc = this.connectionState.getFailoverCommandCenter();
/*     */ 
/*  90 */     if (fcc == null)
/*     */     {
/*  92 */       return invocation.invokeNext();
/*     */     }
/*     */ 
/*  95 */     FailoverValve2 valve = fcc.getValve();
/*     */ 
/*  97 */     JMSRemotingConnection remotingConnection = null;
/*  98 */     String methodName = ((MethodInvocation)invocation).getMethod().getName();
/*     */ 
/* 100 */     if (methodName.equals("startAfterFailover"))
/*     */     {
/* 103 */       return invocation.invokeNext();
/*     */     }
/*     */ 
/* 106 */     boolean left = false;
/*     */     try
/*     */     {
/* 110 */       valve.enter();
/*     */ 
/* 113 */       remotingConnection = fcc.getRemotingConnection();
/* 114 */       Object localObject1 = invocation.invokeNext();
/*     */       return localObject1;
/*     */     }
/*     */     catch (MessagingNetworkFailureException e)
/*     */     {
/* 118 */       valve.leave();
/* 119 */       left = true;
/*     */ 
/* 121 */       log.debug(this + " detected network failure, putting " + methodName + "() on hold until failover completes");
/*     */ 
/* 124 */       fcc.failureDetected(e, this, remotingConnection);
/*     */ 
/* 129 */       if ((((invocation.getTargetObject() instanceof ClientSessionDelegate)) && (methodName.equals("send"))) || (((invocation.getTargetObject() instanceof ClientConnectionDelegate)) && (methodName.equals("sendTransaction"))))
/*     */       {
/* 132 */         log.trace(this + " caught " + methodName + "() invocation, enabling check for duplicates");
/*     */ 
/* 134 */         arguments = ((MethodInvocation)invocation).getArguments();
/* 135 */         arguments[1] = Boolean.TRUE;
/* 136 */         ((MethodInvocation)invocation).setArguments(arguments);
/*     */       }
/*     */ 
/* 143 */       if ((methodName.equals("cancelDelivery")) || (methodName.equals("cancelDeliveries")))
/*     */       {
/* 146 */         log.trace(this + " NOT resuming " + methodName + "(), let it wither and die");
/*     */ 
/* 148 */         arguments = null;
/*     */         return arguments;
/*     */       }
/* 152 */       log.trace(this + " resuming " + methodName + "()");
/*     */ 
/* 154 */       Object[] arguments = invocation.invokeNext();
/*     */       return arguments;
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 160 */       if (trace) log.trace(this + " caught not failover-triggering throwable, rethrowing " + e);
/* 161 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 165 */       if (!left)
/*     */       {
/* 167 */         valve.leave();
/*     */       }
/*     */     }
/* 169 */     throw localObject2;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 176 */     return "FailoverValveInterceptor." + (this.delegate == null ? "UNITIALIZED" : this.delegate.toString());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.FailoverValveInterceptor
 * JD-Core Version:    0.6.0
 */