/*     */ package org.jboss.jms.client.container;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
/*     */ import javax.jms.MessageListener;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.client.remoting.CallbackManager;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.client.state.ConnectionState;
/*     */ import org.jboss.jms.client.state.ConsumerState;
/*     */ import org.jboss.jms.client.state.HierarchicalState;
/*     */ import org.jboss.jms.client.state.SessionState;
/*     */ import org.jboss.jms.delegate.ConnectionDelegate;
/*     */ import org.jboss.jms.delegate.ConsumerDelegate;
/*     */ import org.jboss.jms.delegate.SessionDelegate;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.jms.exception.MessagingShutdownException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.util.MessageQueueNameHelper;
/*     */ 
/*     */ public class ConsumerAspect
/*     */ {
/*  58 */   private static final Logger log = Logger.getLogger(ConsumerAspect.class);
/*     */ 
/*     */   public Object handleCreateConsumerDelegate(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  71 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/*  73 */     ConsumerDelegate consumerDelegate = (ConsumerDelegate)invocation.invokeNext();
/*     */ 
/*  75 */     boolean isCC = ((Boolean)mi.getArguments()[4]).booleanValue();
/*     */ 
/*  78 */     SessionState sessionState = (SessionState)((DelegateSupport)invocation.getTargetObject()).getState();
/*     */ 
/*  80 */     ConnectionState connectionState = (ConnectionState)sessionState.getParent();
/*  81 */     SessionDelegate sessionDelegate = (SessionDelegate)invocation.getTargetObject();
/*  82 */     ConsumerState consumerState = (ConsumerState)((DelegateSupport)consumerDelegate).getState();
/*  83 */     String consumerID = consumerState.getConsumerID();
/*  84 */     int prefetchSize = consumerState.getBufferSize();
/*  85 */     QueuedExecutor sessionExecutor = sessionState.getExecutor();
/*  86 */     int maxDeliveries = consumerState.getMaxDeliveries();
/*  87 */     long redeliveryDelay = consumerState.getRedeliveryDelay();
/*     */ 
/*  90 */     String queueName = null;
/*  91 */     if (consumerState.getSubscriptionName() != null)
/*     */     {
/*  98 */       queueName = MessageQueueNameHelper.createSubscriptionName(((ConnectionDelegate)connectionState.getDelegate()).getClientID(), consumerState.getSubscriptionName());
/*     */     }
/* 102 */     else if (consumerState.getDestination().isQueue())
/*     */     {
/* 104 */       queueName = consumerState.getDestination().getName();
/*     */     }
/*     */ 
/* 107 */     boolean autoFlowControl = ((Boolean)mi.getArguments()[5]).booleanValue();
/*     */ 
/* 109 */     ClientConsumer messageHandler = new ClientConsumer(isCC, sessionState.getAcknowledgeMode(), sessionDelegate, consumerDelegate, consumerID, queueName, prefetchSize, sessionExecutor, maxDeliveries, consumerState.isShouldAck(), autoFlowControl, redeliveryDelay);
/*     */ 
/* 115 */     sessionState.addCallbackHandler(messageHandler);
/*     */ 
/* 117 */     CallbackManager cm = connectionState.getRemotingConnection().getCallbackManager();
/* 118 */     cm.registerHandler(consumerID, messageHandler);
/*     */ 
/* 120 */     consumerState.setClientConsumer(messageHandler);
/*     */ 
/* 122 */     if (autoFlowControl)
/*     */     {
/* 126 */       consumerDelegate.changeRate(1.0F);
/*     */     }
/*     */ 
/* 129 */     return consumerDelegate;
/*     */   }
/*     */ 
/*     */   public Object handleClosing(Invocation invocation) throws Throwable
/*     */   {
/* 134 */     ConsumerState consumerState = getState(invocation);
/*     */     try
/*     */     {
/* 141 */       Long l = (Long)invocation.invokeNext();
/*     */ 
/* 143 */       long lastDeliveryId = l.longValue();
/*     */ 
/* 147 */       consumerState.getClientConsumer().close(lastDeliveryId);
/*     */ 
/* 149 */       SessionState sessionState = (SessionState)consumerState.getParent();
/* 150 */       ConnectionState connectionState = (ConnectionState)sessionState.getParent();
/*     */ 
/* 152 */       sessionState.removeCallbackHandler(consumerState.getClientConsumer());
/*     */ 
/* 154 */       CallbackManager cm = connectionState.getRemotingConnection().getCallbackManager();
/* 155 */       cm.unregisterHandler(consumerState.getConsumerID());
/*     */ 
/* 158 */       consumerState.getClientConsumer().cancelBuffer();
/*     */ 
/* 160 */       return l;
/*     */     }
/*     */     catch (Exception proxiedException)
/*     */     {
/* 165 */       ConnectionState connectionState = (ConnectionState)(ConnectionState)consumerState.getParent().getParent();
/*     */ 
/* 168 */       if (((proxiedException instanceof MessagingShutdownException)) || (connectionState.getFailoverCommandCenter() == null))
/*     */       {
/* 173 */         if (!consumerState.getClientConsumer().isClosed())
/*     */         {
/* 175 */           consumerState.getClientConsumer().close(-1L);
/*     */         }
/*     */       }
/*     */     }
/* 178 */     throw proxiedException;
/*     */   }
/*     */ 
/*     */   public Object handleReceive(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 185 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 186 */     Object[] args = mi.getArguments();
/* 187 */     long timeout = (args == null) || (args.length == 0) ? 0L : ((Long)args[0]).longValue();
/*     */ 
/* 189 */     return getClientConsumer(invocation).receive(timeout);
/*     */   }
/*     */ 
/*     */   public Object handleReceiveNoWait(Invocation invocation) throws Throwable
/*     */   {
/* 194 */     return getClientConsumer(invocation).receive(-1L);
/*     */   }
/*     */ 
/*     */   public Object handleSetMessageListener(Invocation invocation) throws Throwable
/*     */   {
/* 199 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 200 */     Object[] args = mi.getArguments();
/* 201 */     MessageListener l = (MessageListener)args[0];
/*     */ 
/* 203 */     getClientConsumer(invocation).setMessageListener(l);
/*     */ 
/* 205 */     return null;
/*     */   }
/*     */ 
/*     */   public MessageListener handleGetMessageListener(Invocation invocation) throws Throwable
/*     */   {
/* 210 */     return getClientConsumer(invocation).getMessageListener();
/*     */   }
/*     */ 
/*     */   public Object handleGetDestination(Invocation invocation) throws Throwable
/*     */   {
/* 215 */     return getState(invocation).getDestination();
/*     */   }
/*     */ 
/*     */   public Object handleGetNoLocal(Invocation invocation) throws Throwable
/*     */   {
/* 220 */     return getState(invocation).isNoLocal() ? Boolean.TRUE : Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object handleGetMessageSelector(Invocation invocation) throws Throwable
/*     */   {
/* 225 */     return getState(invocation).getSelector();
/*     */   }
/*     */ 
/*     */   private ConsumerState getState(Invocation inv)
/*     */   {
/* 236 */     return (ConsumerState)((DelegateSupport)inv.getTargetObject()).getState();
/*     */   }
/*     */ 
/*     */   private ClientConsumer getClientConsumer(Invocation inv)
/*     */   {
/* 241 */     ConsumerState state = (ConsumerState)((DelegateSupport)inv.getTargetObject()).getState();
/* 242 */     return state.getClientConsumer();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.ConsumerAspect
 * JD-Core Version:    0.6.0
 */