/*     */ package org.jboss.jms.client.container;
/*     */ 
/*     */ import javax.jms.ExceptionListener;
/*     */ import javax.jms.IllegalStateException;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.client.FailoverCommandCenter;
/*     */ import org.jboss.jms.client.FailoverListener;
/*     */ import org.jboss.jms.client.JBossConnectionMetaData;
/*     */ import org.jboss.jms.client.delegate.ClientConnectionDelegate;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.client.remoting.ConsolidatedRemotingConnectionListener;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.client.state.ConnectionState;
/*     */ import org.jboss.jms.message.MessageIdGeneratorFactory;
/*     */ import org.jboss.jms.tx.ResourceManagerFactory;
/*     */ 
/*     */ public class ConnectionAspect
/*     */ {
/*     */   protected JBossConnectionMetaData connMetaData;
/*     */   protected ConnectionState state;
/*     */   private String id;
/*     */ 
/*     */   public Object handleGetClientID(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  73 */     ConnectionState currentState = getConnectionState(invocation);
/*     */ 
/*  75 */     currentState.setJustCreated(false);
/*     */ 
/*  77 */     if (currentState.getClientID() == null)
/*     */     {
/*  80 */       currentState.setClientID((String)invocation.invokeNext());
/*     */     }
/*  82 */     return currentState.getClientID();
/*     */   }
/*     */ 
/*     */   public Object handleSetClientID(Invocation invocation) throws Throwable
/*     */   {
/*  87 */     ConnectionState currentState = getConnectionState(invocation);
/*     */ 
/*  89 */     if (currentState.getClientID() != null)
/*     */     {
/*  91 */       throw new IllegalStateException("Client id has already been set");
/*     */     }
/*  93 */     if (!currentState.isJustCreated())
/*     */     {
/*  95 */       throw new IllegalStateException("setClientID can only be called directly after the connection is created");
/*     */     }
/*     */ 
/*  98 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 100 */     currentState.setClientID((String)mi.getArguments()[0]);
/*     */ 
/* 102 */     currentState.setJustCreated(false);
/*     */ 
/* 105 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object handleGetExceptionListener(Invocation invocation) throws Throwable
/*     */   {
/* 110 */     ConnectionState state = getConnectionState(invocation);
/* 111 */     state.setJustCreated(false);
/*     */ 
/* 113 */     return state.getRemotingConnection().getConnectionListener().getJMSExceptionListener();
/*     */   }
/*     */ 
/*     */   public Object handleSetExceptionListener(Invocation invocation) throws Throwable
/*     */   {
/* 118 */     ConnectionState state = getConnectionState(invocation);
/* 119 */     state.setJustCreated(false);
/*     */ 
/* 121 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 122 */     ExceptionListener exceptionListener = (ExceptionListener)mi.getArguments()[0];
/* 123 */     state.getRemotingConnection().getConnectionListener().addJMSExceptionListener(exceptionListener);
/*     */ 
/* 126 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleGetConnectionMetaData(Invocation invocation) throws Throwable
/*     */   {
/* 131 */     ConnectionState currentState = getConnectionState(invocation);
/* 132 */     currentState.setJustCreated(false);
/*     */ 
/* 134 */     if (this.connMetaData == null)
/*     */     {
/* 136 */       ClientConnectionDelegate delegate = (ClientConnectionDelegate)invocation.getTargetObject();
/* 137 */       this.connMetaData = new JBossConnectionMetaData(((ConnectionState)delegate.getState()).getVersionToUse());
/*     */     }
/*     */ 
/* 140 */     return this.connMetaData;
/*     */   }
/*     */ 
/*     */   public Object handleStart(Invocation invocation) throws Throwable
/*     */   {
/* 145 */     ConnectionState currentState = getConnectionState(invocation);
/* 146 */     currentState.setStarted(true);
/* 147 */     currentState.setJustCreated(false);
/* 148 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object handleStop(Invocation invocation) throws Throwable
/*     */   {
/* 153 */     ConnectionState currentState = getConnectionState(invocation);
/* 154 */     currentState.setStarted(false);
/* 155 */     currentState.setJustCreated(false);
/* 156 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object handleCreateSessionDelegate(Invocation invocation) throws Throwable
/*     */   {
/* 161 */     ConnectionState currentState = getConnectionState(invocation);
/* 162 */     currentState.setJustCreated(false);
/* 163 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object handleClose(Invocation invocation) throws Throwable
/*     */   {
/*     */     try
/*     */     {
/* 170 */       Object ret = invocation.invokeNext();
/*     */ 
/* 172 */       Object localObject1 = ret;
/*     */       ConnectionState state;
/*     */       JMSRemotingConnection remotingConnection;
/*     */       ConsolidatedRemotingConnectionListener l;
/*     */       return localObject1;
/*     */     }
/*     */     finally
/*     */     {
/* 178 */       ConnectionState state = getConnectionState(invocation);
/*     */ 
/* 180 */       JMSRemotingConnection remotingConnection = state.getRemotingConnection();
/*     */ 
/* 184 */       ConsolidatedRemotingConnectionListener l = remotingConnection.removeConnectionListener();
/* 185 */       if (l != null)
/*     */       {
/* 187 */         l.clear();
/*     */       }
/*     */ 
/* 191 */       remotingConnection.stop();
/*     */ 
/* 194 */       MessageIdGeneratorFactory.instance.checkInGenerator(state.getServerID());
/*     */ 
/* 197 */       ResourceManagerFactory.instance.checkInResourceManager(state.getServerID());
/* 198 */     }throw localObject2;
/*     */   }
/*     */ 
/*     */   public Object handleRegisterFailoverListener(Invocation invocation) throws Throwable
/*     */   {
/* 203 */     ConnectionState state = getConnectionState(invocation);
/*     */ 
/* 205 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 206 */     FailoverListener listener = (FailoverListener)mi.getArguments()[0];
/*     */ 
/* 208 */     state.getFailoverCommandCenter().registerFailoverListener(listener);
/*     */ 
/* 210 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleUnregisterFailoverListener(Invocation invocation) throws Throwable
/*     */   {
/* 215 */     ConnectionState state = getConnectionState(invocation);
/*     */ 
/* 217 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 218 */     FailoverListener listener = (FailoverListener)mi.getArguments()[0];
/*     */ 
/* 220 */     boolean result = state.getFailoverCommandCenter().unregisterFailoverListener(listener);
/*     */ 
/* 222 */     return new Boolean(result);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 227 */     StringBuffer sb = new StringBuffer("ConnectionAspect[");
/*     */ 
/* 229 */     if (this.id == null)
/*     */     {
/* 231 */       sb.append("UNINITIALIZED]");
/*     */     }
/*     */     else
/*     */     {
/* 235 */       sb.append(this.id).append("]");
/*     */     }
/* 237 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   private ConnectionState getConnectionState(Invocation invocation)
/*     */   {
/* 248 */     if (this.state == null)
/*     */     {
/* 250 */       ClientConnectionDelegate currentDelegate = (ClientConnectionDelegate)invocation.getTargetObject();
/*     */ 
/* 253 */       this.state = ((ConnectionState)currentDelegate.getState());
/* 254 */       this.id = this.state.getDelegate().getID();
/*     */     }
/*     */ 
/* 257 */     return this.state;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.ConnectionAspect
 * JD-Core Version:    0.6.0
 */