/*     */ package org.jboss.jms.client.container;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.jms.JMSException;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.client.FailoverCommandCenter;
/*     */ import org.jboss.jms.client.delegate.ClientClusteredConnectionFactoryDelegate;
/*     */ import org.jboss.jms.client.delegate.ClientConnectionDelegate;
/*     */ import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.client.plugin.LoadBalancingPolicy;
/*     */ import org.jboss.jms.client.remoting.ConsolidatedRemotingConnectionListener;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.client.state.ConnectionState;
/*     */ import org.jboss.jms.delegate.CreateConnectionResult;
/*     */ import org.jboss.jms.exception.MessagingNetworkFailureException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClusteringAspect
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(ClusteringAspect.class);
/*     */ 
/*  54 */   private boolean trace = log.isTraceEnabled();
/*     */   public static final int MAX_RECONNECT_HOP_COUNT = 10;
/*     */   private ClientClusteredConnectionFactoryDelegate clusteredDelegate;
/*     */ 
/*     */   public CreateConnectionResult handleCreateConnectionDelegate(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  76 */     if (this.trace)
/*     */     {
/*  78 */       log.trace(this + " handleCreateConnectionDelegate");
/*     */     }
/*     */ 
/*  83 */     if (this.clusteredDelegate == null)
/*     */     {
/*  85 */       this.clusteredDelegate = ((ClientClusteredConnectionFactoryDelegate)invocation.getTargetObject());
/*     */     }
/*     */ 
/*  88 */     boolean supportsFailover = this.clusteredDelegate.isSupportsFailover();
/*     */ 
/*  93 */     MethodInvocation mi = (MethodInvocation)invocation;
/*  94 */     String username = (String)mi.getArguments()[0];
/*  95 */     String password = (String)mi.getArguments()[1];
/*  96 */     Integer failedNodeID = (Integer)mi.getArguments()[2];
/*     */ 
/* 101 */     int attemptCount = 0;
/* 102 */     ClientConnectionFactoryDelegate delegate = null;
/*     */ 
/* 104 */     while (attemptCount < 10)
/*     */     {
/* 108 */       attemptCount++;
/*     */ 
/* 110 */       int nextHopingServer = -1;
/*     */       try
/*     */       {
/* 113 */         int failedNodeIDToServer = -1;
/* 114 */         if (delegate == null)
/*     */         {
/* 116 */           if ((failedNodeID != null) && (failedNodeID.intValue() >= 0))
/*     */           {
/* 119 */             delegate = getFailoverDelegateForNode(failedNodeID);
/* 120 */             failedNodeIDToServer = failedNodeID.intValue();
/* 121 */             nextHopingServer = delegate.getServerID();
/*     */           }
/*     */           else
/*     */           {
/* 126 */             LoadBalancingPolicy loadBalancingPolicy = this.clusteredDelegate.getLoadBalancingPolicy();
/* 127 */             delegate = (ClientConnectionFactoryDelegate)loadBalancingPolicy.getNext();
/*     */           }
/*     */         }
/*     */ 
/* 131 */         log.trace(this + " has chosen " + delegate + " as target, " + (attemptCount == 0 ? "first connection attempt" : new StringBuilder().append(attemptCount).append(" connection attempts").toString()));
/*     */ 
/* 134 */         CreateConnectionResult res = delegate.createConnectionDelegate(username, password, failedNodeIDToServer);
/*     */ 
/* 137 */         ClientConnectionDelegate cd = res.getDelegate();
/*     */ 
/* 139 */         if (cd != null)
/*     */         {
/* 143 */           log.trace(this + " got local connection delegate " + cd);
/*     */ 
/* 145 */           if (supportsFailover)
/*     */           {
/* 147 */             ConnectionState state = (ConnectionState)cd.getState();
/*     */ 
/* 149 */             state.initializeFailoverCommandCenter();
/*     */ 
/* 151 */             FailoverCommandCenter fcc = state.getFailoverCommandCenter();
/*     */ 
/* 155 */             state.getRemotingConnection().getConnectionListener().setDelegateListener(new ConnectionFailureListener(fcc, state.getRemotingConnection()));
/*     */ 
/* 158 */             log.trace(this + " installed failure listener on " + cd);
/*     */ 
/* 162 */             state.setUsername(username);
/* 163 */             state.setPassword(password);
/*     */ 
/* 167 */             state.setClusteredConnectionFactoryDeleage(this.clusteredDelegate);
/*     */ 
/* 169 */             log.trace("Successfully initialised new connection");
/*     */           }
/*     */ 
/* 172 */           return res;
/*     */         }
/*     */ 
/* 177 */         if (!supportsFailover)
/*     */         {
/* 179 */           throw new IllegalStateException("Doesn't support failover so must return a connection delegate");
/*     */         }
/*     */ 
/* 184 */         int actualServerID = res.getActualFailoverNodeID();
/*     */ 
/* 186 */         if (actualServerID == -1)
/*     */         {
/* 194 */           log.debug("Client attempted failover, but no failover attempt has been detected on the server side. We will now try again on the original server in case there was a temporary glitch on the client--server network");
/*     */ 
/* 198 */           delegate = getDelegateForNode(failedNodeID.intValue());
/*     */ 
/* 203 */           Thread.sleep(2000L);
/*     */         }
/*     */         else
/*     */         {
/* 210 */           log.trace("Server side failover occurred, but we were non the wrong node! Actual node = " + actualServerID);
/*     */ 
/* 212 */           delegate = getDelegateForNode(actualServerID);
/*     */         }
/*     */ 
/* 215 */         if (delegate == null)
/*     */         {
/* 220 */           throw new JMSException("Cannot find a cached connection factory delegate for node " + actualServerID);
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (MessagingNetworkFailureException e)
/*     */       {
/* 229 */         failedNodeID = new Integer(nextHopingServer);
/* 230 */         delegate = null;
/* 231 */         log.warn("Exception captured on createConnection... hopping to a new connection factory on server (" + failedNodeID + ")", e);
/*     */ 
/* 233 */         Thread.sleep(2000L);
/*     */       }
/*     */     }
/*     */ 
/* 237 */     throw new JMSException("Maximum number of failover attempts exceeded. Cannot find a server to failover onto.");
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 243 */     return "ClusteringAspect[" + this.clusteredDelegate + "]";
/*     */   }
/*     */ 
/*     */   private synchronized ClientConnectionFactoryDelegate getFailoverDelegateForNode(Integer nodeID)
/*     */   {
/* 254 */     log.trace("Getting failover delegate for node id " + nodeID);
/*     */ 
/* 256 */     ClientConnectionFactoryDelegate[] delegates = this.clusteredDelegate.getDelegates();
/*     */ 
/* 258 */     if (nodeID.intValue() < 0)
/*     */     {
/* 260 */       throw new IllegalArgumentException("nodeID must be 0 or positive");
/*     */     }
/*     */ 
/* 263 */     Map failoverMap = this.clusteredDelegate.getFailoverMap();
/*     */ 
/* 265 */     if (this.trace) dumpFailoverMap(failoverMap);
/*     */ 
/* 267 */     Integer failoverNodeID = (Integer)failoverMap.get(nodeID);
/*     */ 
/* 269 */     log.trace("Found failover node id = " + failoverNodeID);
/*     */ 
/* 274 */     if (failoverNodeID == null)
/*     */     {
/* 276 */       log.trace("Couldn't find failover node id on map so guessing it");
/* 277 */       failoverNodeID = guessFailoverID(failoverMap, nodeID);
/* 278 */       log.trace("Guess is " + failoverNodeID);
/*     */     }
/*     */ 
/* 281 */     for (int i = 0; i < delegates.length; i++)
/*     */     {
/* 283 */       if (delegates[i].getServerID() == failoverNodeID.intValue())
/*     */       {
/* 285 */         return delegates[i];
/*     */       }
/*     */     }
/*     */ 
/* 289 */     return null;
/*     */   }
/*     */ 
/*     */   private void dumpFailoverMap(Map failoverMap)
/*     */   {
/* 294 */     log.trace("Dumping failover map");
/* 295 */     Iterator iter = failoverMap.entrySet().iterator();
/* 296 */     while (iter.hasNext())
/*     */     {
/* 298 */       Map.Entry entry = (Map.Entry)iter.next();
/* 299 */       log.trace(entry.getKey() + "-->" + entry.getValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   private static Integer guessFailoverID(Map failoverMap, Integer nodeID)
/*     */   {
/* 313 */     log.trace("Guessing failover id for node " + nodeID);
/* 314 */     Integer failoverNodeID = null;
/* 315 */     Integer[] nodes = (Integer[])(Integer[])failoverMap.keySet().toArray(new Integer[failoverMap.size()]);
/*     */ 
/* 318 */     Arrays.sort(nodes);
/*     */ 
/* 320 */     for (int i = 0; i < nodes.length; i++)
/*     */     {
/* 322 */       if (nodeID.intValue() >= nodes[i].intValue())
/*     */         continue;
/* 324 */       failoverNodeID = nodes[i];
/* 325 */       break;
/*     */     }
/*     */ 
/* 330 */     if (failoverNodeID == null)
/*     */     {
/* 332 */       failoverNodeID = nodes[0];
/*     */     }
/*     */ 
/* 335 */     log.trace("Returning guess " + failoverNodeID);
/*     */ 
/* 337 */     return failoverNodeID;
/*     */   }
/*     */ 
/*     */   private synchronized ClientConnectionFactoryDelegate getDelegateForNode(int nodeID)
/*     */   {
/* 342 */     log.trace("Getting delegate for node id " + nodeID);
/*     */ 
/* 344 */     ClientConnectionFactoryDelegate[] delegates = this.clusteredDelegate.getDelegates();
/*     */ 
/* 346 */     for (int i = 0; i < delegates.length; i++)
/*     */     {
/* 348 */       if (delegates[i].getServerID() != nodeID)
/*     */         continue;
/* 350 */       log.trace("Found " + delegates[i]);
/* 351 */       return delegates[i];
/*     */     }
/*     */ 
/* 355 */     log.trace("Didn't find any delegate");
/* 356 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.ClusteringAspect
 * JD-Core Version:    0.6.0
 */