/*    */ package org.jboss.jms.client.container;
/*    */ 
/*    */ import javax.jms.JMSException;
/*    */ import javax.jms.Message;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.jms.delegate.BrowserDelegate;
/*    */ 
/*    */ public class BrowserAspect
/*    */ {
/*    */   private static final boolean BATCH_MESSAGES = false;
/*    */   private static final int MSG_BLOCK_SIZE = 5;
/*    */   private Message[] cache;
/*    */   private int pos;
/*    */ 
/*    */   public Object handleNextMessage(Invocation invocation)
/*    */     throws Throwable
/*    */   {
/* 68 */     return invocation.invokeNext();
/*    */   }
/*    */ 
/*    */   public Object handleHasNextMessage(Invocation invocation)
/*    */     throws Throwable
/*    */   {
/* 82 */     if (this.cache != null)
/*    */     {
/* 84 */       return Boolean.TRUE;
/*    */     }
/* 86 */     return invocation.invokeNext();
/*    */   }
/*    */ 
/*    */   private void checkCache(Invocation invocation)
/*    */     throws JMSException
/*    */   {
/* 99 */     if (this.cache == null)
/*    */     {
/* 101 */       BrowserDelegate bd = (BrowserDelegate)invocation.getTargetObject();
/* 102 */       this.cache = bd.nextMessageBlock(5);
/* 103 */       this.pos = 0;
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.BrowserAspect
 * JD-Core Version:    0.6.0
 */