/*     */ package org.jboss.jms.client;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Enumeration;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Queue;
/*     */ import javax.jms.QueueBrowser;
/*     */ import org.jboss.jms.delegate.BrowserDelegate;
/*     */ 
/*     */ public class JBossQueueBrowser
/*     */   implements QueueBrowser, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 4245650830082712281L;
/*     */   private BrowserDelegate delegate;
/*     */   private Queue queue;
/*     */   private String messageSelector;
/*     */ 
/*     */   JBossQueueBrowser(Queue queue, String messageSelector, BrowserDelegate delegate)
/*     */   {
/*  56 */     this.delegate = delegate;
/*  57 */     this.queue = queue;
/*  58 */     this.messageSelector = messageSelector;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws JMSException
/*     */   {
/*  65 */     this.delegate.closing(-1L);
/*  66 */     this.delegate.close();
/*     */   }
/*     */ 
/*     */   public Enumeration getEnumeration() throws JMSException
/*     */   {
/*  71 */     this.delegate.reset();
/*  72 */     return new BrowserEnumeration(null);
/*     */   }
/*     */ 
/*     */   public String getMessageSelector() throws JMSException
/*     */   {
/*  77 */     return this.messageSelector;
/*     */   }
/*     */ 
/*     */   public Queue getQueue() throws JMSException
/*     */   {
/*  82 */     return this.queue;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  89 */     return "JBossQueueBrowser->" + this.delegate;
/*     */   }
/*     */ 
/*     */   public BrowserDelegate getDelegate()
/*     */   {
/*  94 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   private class BrowserEnumeration
/*     */     implements Enumeration
/*     */   {
/*     */     private BrowserEnumeration()
/*     */     {
/*     */     }
/*     */ 
/*     */     public boolean hasMoreElements()
/*     */     {
/*     */       try
/*     */       {
/* 111 */         return JBossQueueBrowser.this.delegate.hasNextMessage();
/*     */       }
/*     */       catch (JMSException e) {
/*     */       }
/* 115 */       throw new IllegalStateException(e.getMessage());
/*     */     }
/*     */ 
/*     */     public Object nextElement()
/*     */     {
/*     */       try
/*     */       {
/* 123 */         return JBossQueueBrowser.this.delegate.nextMessage();
/*     */       }
/*     */       catch (JMSException e) {
/*     */       }
/* 127 */       throw new IllegalStateException(e.getMessage());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.JBossQueueBrowser
 * JD-Core Version:    0.6.0
 */