/*     */ package org.jboss.jms.client;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.InvalidDestinationException;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.MessageProducer;
/*     */ import javax.jms.Queue;
/*     */ import javax.jms.QueueSender;
/*     */ import javax.jms.Topic;
/*     */ import javax.jms.TopicPublisher;
/*     */ import org.jboss.jms.delegate.ProducerDelegate;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JBossMessageProducer
/*     */   implements MessageProducer, QueueSender, TopicPublisher, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1080736785725023015L;
/*  55 */   private static final Logger log = Logger.getLogger(JBossMessageProducer.class);
/*     */   protected ProducerDelegate delegate;
/*     */ 
/*     */   public JBossMessageProducer(ProducerDelegate delegate)
/*     */   {
/*  65 */     this.delegate = delegate;
/*     */   }
/*     */ 
/*     */   public void setDisableMessageID(boolean value)
/*     */     throws JMSException
/*     */   {
/*  72 */     log.warn("JBoss Messaging does not support disabling message ID generation");
/*     */ 
/*  74 */     this.delegate.setDisableMessageID(value);
/*     */   }
/*     */ 
/*     */   public boolean getDisableMessageID() throws JMSException
/*     */   {
/*  79 */     return this.delegate.getDisableMessageID();
/*     */   }
/*     */ 
/*     */   public void setDisableMessageTimestamp(boolean value) throws JMSException
/*     */   {
/*  84 */     this.delegate.setDisableMessageTimestamp(value);
/*     */   }
/*     */ 
/*     */   public boolean getDisableMessageTimestamp() throws JMSException
/*     */   {
/*  89 */     return this.delegate.getDisableMessageTimestamp();
/*     */   }
/*     */ 
/*     */   public void setDeliveryMode(int deliveryMode) throws JMSException
/*     */   {
/*  94 */     this.delegate.setDeliveryMode(deliveryMode);
/*     */   }
/*     */ 
/*     */   public int getDeliveryMode() throws JMSException
/*     */   {
/*  99 */     return this.delegate.getDeliveryMode();
/*     */   }
/*     */ 
/*     */   public void setPriority(int defaultPriority) throws JMSException
/*     */   {
/* 104 */     this.delegate.setPriority(defaultPriority);
/*     */   }
/*     */ 
/*     */   public int getPriority() throws JMSException
/*     */   {
/* 109 */     return this.delegate.getPriority();
/*     */   }
/*     */ 
/*     */   public void setTimeToLive(long timeToLive) throws JMSException
/*     */   {
/* 114 */     this.delegate.setTimeToLive(timeToLive);
/*     */   }
/*     */ 
/*     */   public long getTimeToLive() throws JMSException
/*     */   {
/* 119 */     return this.delegate.getTimeToLive();
/*     */   }
/*     */ 
/*     */   public Destination getDestination() throws JMSException
/*     */   {
/* 124 */     return this.delegate.getDestination();
/*     */   }
/*     */ 
/*     */   public void close() throws JMSException
/*     */   {
/* 129 */     this.delegate.closing(-1L);
/* 130 */     this.delegate.close();
/*     */   }
/*     */ 
/*     */   public void send(Message message)
/*     */     throws JMSException
/*     */   {
/* 136 */     send(message, -1, -1, -9223372036854775808L);
/*     */   }
/*     */ 
/*     */   public void send(Message message, int deliveryMode, int priority, long timeToLive)
/*     */     throws JMSException
/*     */   {
/* 145 */     send(null, message, deliveryMode, priority, timeToLive);
/*     */   }
/*     */ 
/*     */   public void send(Destination destination, Message message) throws JMSException
/*     */   {
/* 150 */     send(destination, message, -1, -1, -9223372036854775808L);
/*     */   }
/*     */ 
/*     */   public void send(Destination destination, Message m, int deliveryMode, int priority, long timeToLive)
/*     */     throws JMSException
/*     */   {
/* 159 */     if ((destination != null) && (!(destination instanceof JBossDestination)))
/*     */     {
/* 161 */       throw new InvalidDestinationException("Not a JBossDestination:" + destination);
/*     */     }
/*     */ 
/* 164 */     this.delegate.send((JBossDestination)destination, m, deliveryMode, priority, timeToLive);
/*     */   }
/*     */ 
/*     */   public Topic getTopic()
/*     */     throws JMSException
/*     */   {
/* 172 */     return (Topic)getDestination();
/*     */   }
/*     */ 
/*     */   public void publish(Message message) throws JMSException
/*     */   {
/* 177 */     send(message);
/*     */   }
/*     */ 
/*     */   public void publish(Topic topic, Message message) throws JMSException
/*     */   {
/* 182 */     send(topic, message);
/*     */   }
/*     */ 
/*     */   public void publish(Message message, int deliveryMode, int priority, long timeToLive)
/*     */     throws JMSException
/*     */   {
/* 188 */     send(message, deliveryMode, priority, timeToLive);
/*     */   }
/*     */ 
/*     */   public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive)
/*     */     throws JMSException
/*     */   {
/* 194 */     send(topic, message, deliveryMode, priority, timeToLive);
/*     */   }
/*     */ 
/*     */   public void send(Queue queue, Message message)
/*     */     throws JMSException
/*     */   {
/* 201 */     send(queue, message);
/*     */   }
/*     */ 
/*     */   public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive)
/*     */     throws JMSException
/*     */   {
/* 207 */     send(queue, message, deliveryMode, priority, timeToLive);
/*     */   }
/*     */ 
/*     */   public Queue getQueue() throws JMSException
/*     */   {
/* 212 */     return (Queue)getDestination();
/*     */   }
/*     */ 
/*     */   public ProducerDelegate getDelegate()
/*     */   {
/* 219 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 224 */     return "JBossMessageProducer->" + this.delegate;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.JBossMessageProducer
 * JD-Core Version:    0.6.0
 */