/*     */ package org.jboss.jms.client;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.MessageConsumer;
/*     */ import javax.jms.MessageListener;
/*     */ import javax.jms.Queue;
/*     */ import javax.jms.QueueReceiver;
/*     */ import javax.jms.Topic;
/*     */ import javax.jms.TopicSubscriber;
/*     */ import org.jboss.jms.delegate.ConsumerDelegate;
/*     */ 
/*     */ public class JBossMessageConsumer
/*     */   implements MessageConsumer, QueueReceiver, TopicSubscriber, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -8776908463975467851L;
/*     */   protected ConsumerDelegate delegate;
/*     */ 
/*     */   public JBossMessageConsumer(ConsumerDelegate delegate)
/*     */   {
/*  59 */     this.delegate = delegate;
/*     */   }
/*     */ 
/*     */   public String getMessageSelector()
/*     */     throws JMSException
/*     */   {
/*  66 */     return this.delegate.getMessageSelector();
/*     */   }
/*     */ 
/*     */   public MessageListener getMessageListener() throws JMSException
/*     */   {
/*  71 */     return this.delegate.getMessageListener();
/*     */   }
/*     */ 
/*     */   public void setMessageListener(MessageListener listener) throws JMSException
/*     */   {
/*  76 */     this.delegate.setMessageListener(listener);
/*     */   }
/*     */ 
/*     */   public Message receive() throws JMSException
/*     */   {
/*  81 */     return this.delegate.receive(0L);
/*     */   }
/*     */ 
/*     */   public Message receive(long timeout) throws JMSException
/*     */   {
/*  86 */     return this.delegate.receive(timeout);
/*     */   }
/*     */ 
/*     */   public Message receiveNoWait() throws JMSException
/*     */   {
/*  91 */     return this.delegate.receive(-1L);
/*     */   }
/*     */ 
/*     */   public void close() throws JMSException
/*     */   {
/*  96 */     this.delegate.closing(-1L);
/*  97 */     this.delegate.close();
/*     */   }
/*     */ 
/*     */   public Queue getQueue()
/*     */     throws JMSException
/*     */   {
/* 105 */     return (Queue)this.delegate.getDestination();
/*     */   }
/*     */ 
/*     */   public Topic getTopic()
/*     */     throws JMSException
/*     */   {
/* 112 */     return (Topic)this.delegate.getDestination();
/*     */   }
/*     */ 
/*     */   public boolean getNoLocal()
/*     */     throws JMSException
/*     */   {
/* 118 */     return this.delegate.getNoLocal();
/*     */   }
/*     */ 
/*     */   public ConsumerDelegate getDelegate()
/*     */   {
/* 123 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 130 */     return "JBossMessageConsumer->" + this.delegate;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.JBossMessageConsumer
 * JD-Core Version:    0.6.0
 */