/*     */ package org.jboss.jms.client;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Vector;
/*     */ import javax.jms.ConnectionMetaData;
/*     */ import javax.jms.JMSException;
/*     */ import org.jboss.messaging.util.Version;
/*     */ 
/*     */ public class JBossConnectionMetaData
/*     */   implements Serializable, ConnectionMetaData
/*     */ {
/*     */   private static final long serialVersionUID = 327633302671160939L;
/*     */   protected Version serverVersion;
/*     */ 
/*     */   public JBossConnectionMetaData(Version serverVersion)
/*     */   {
/*  61 */     this.serverVersion = serverVersion;
/*     */   }
/*     */ 
/*     */   public String getJMSVersion()
/*     */     throws JMSException
/*     */   {
/*  68 */     return this.serverVersion.getJMSVersion();
/*     */   }
/*     */ 
/*     */   public int getJMSMajorVersion() throws JMSException
/*     */   {
/*  73 */     return this.serverVersion.getJMSMajorVersion();
/*     */   }
/*     */ 
/*     */   public int getJMSMinorVersion() throws JMSException
/*     */   {
/*  78 */     return this.serverVersion.getJMSMinorVersion();
/*     */   }
/*     */ 
/*     */   public String getJMSProviderName() throws JMSException
/*     */   {
/*  83 */     return this.serverVersion.getJMSProviderName();
/*     */   }
/*     */ 
/*     */   public String getProviderVersion() throws JMSException
/*     */   {
/*  88 */     return this.serverVersion.getProviderVersion();
/*     */   }
/*     */ 
/*     */   public int getProviderMajorVersion() throws JMSException
/*     */   {
/*  93 */     return this.serverVersion.getProviderMajorVersion();
/*     */   }
/*     */ 
/*     */   public int getProviderMinorVersion() throws JMSException
/*     */   {
/*  98 */     return this.serverVersion.getProviderMinorVersion();
/*     */   }
/*     */ 
/*     */   public Enumeration getJMSXPropertyNames() throws JMSException
/*     */   {
/* 103 */     Vector v = new Vector();
/* 104 */     v.add("JMSXGroupID");
/* 105 */     v.add("JMSXGroupSeq");
/* 106 */     v.add("JMSXDeliveryCount");
/* 107 */     return v.elements();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.JBossConnectionMetaData
 * JD-Core Version:    0.6.0
 */