/*     */ package org.jboss.jms.client;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class FailoverValve2
/*     */ {
/*  40 */   private static final Logger log = Logger.getLogger(FailoverValve2.class);
/*     */ 
/*  45 */   private static boolean trace = log.isTraceEnabled();
/*     */   private Set threads;
/*     */   private int count;
/*     */   private boolean locked;
/*     */ 
/*     */   public FailoverValve2()
/*     */   {
/*  60 */     trace = log.isTraceEnabled();
/*     */ 
/*  62 */     if (trace)
/*     */     {
/*  64 */       this.threads = new HashSet();
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void enter()
/*     */   {
/*  72 */     if (trace) log.trace(this + " entering");
/*     */ 
/*  74 */     while (this.locked)
/*     */     {
/*     */       try
/*     */       {
/*  78 */         wait();
/*     */       }
/*     */       catch (InterruptedException ignore)
/*     */       {
/*     */       }
/*     */     }
/*  84 */     this.count += 1;
/*     */ 
/*  86 */     if (trace)
/*     */     {
/*  88 */       this.threads.add(Thread.currentThread());
/*  89 */       log.trace(this + " entered");
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void leave()
/*     */   {
/*  95 */     if (trace) log.trace(this + " leaving");
/*     */ 
/*  97 */     this.count -= 1;
/*     */ 
/*  99 */     if (trace) this.threads.remove(Thread.currentThread());
/*     */ 
/* 101 */     notifyAll();
/*     */ 
/* 103 */     if (trace) log.trace(this + " left");
/*     */   }
/*     */ 
/*     */   public synchronized void close()
/*     */   {
/* 108 */     if (trace) log.trace(this + " close " + (this.locked ? "LOCKED" : "UNLOCKED") + " valve");
/*     */ 
/* 110 */     if ((trace) && (this.threads.contains(Thread.currentThread())))
/*     */     {
/* 113 */       throw new IllegalStateException("Cannot close valve from inside valve");
/*     */     }
/*     */ 
/* 119 */     while (this.locked)
/*     */     {
/* 121 */       if (trace) log.trace(this + " is already closed, blocking until its opened");
/*     */ 
/*     */       try
/*     */       {
/* 125 */         wait();
/*     */       }
/*     */       catch (InterruptedException ignore)
/*     */       {
/*     */       }
/*     */ 
/* 131 */       if (!this.locked)
/*     */       {
/* 134 */         return;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 139 */     this.locked = true;
/*     */ 
/* 141 */     while (this.count > 0)
/*     */     {
/*     */       try
/*     */       {
/* 145 */         wait();
/*     */       }
/*     */       catch (InterruptedException ignore)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 152 */     if (trace) log.trace(this + " closed");
/*     */   }
/*     */ 
/*     */   public synchronized void open()
/*     */   {
/* 157 */     if (trace) log.trace(this + " opening " + (this.locked ? "LOCKED" : "UNLOCKED") + " valve");
/*     */ 
/* 159 */     if (!this.locked)
/*     */     {
/* 161 */       return;
/*     */     }
/*     */ 
/* 164 */     this.locked = false;
/*     */ 
/* 166 */     notifyAll();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 171 */     return "FailoverValve[" + System.identityHashCode(this) + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.FailoverValve2
 * JD-Core Version:    0.6.0
 */