/*    */ package org.jboss.jms.client;
/*    */ 
/*    */ import java.util.EventObject;
/*    */ 
/*    */ public class FailoverEvent extends EventObject
/*    */ {
/*    */   private static final long serialVersionUID = 8451706459791859231L;
/*    */   public static final int FAILURE_DETECTED = 10;
/*    */   public static final int FAILOVER_STARTED = 20;
/*    */   public static final int FAILOVER_COMPLETED = 30;
/*    */   public static final int FAILOVER_ALREADY_COMPLETED = 40;
/*    */   public static final int FAILOVER_FAILED = 100;
/*    */   private int type;
/*    */ 
/*    */   public FailoverEvent(int type, Object source)
/*    */   {
/* 39 */     super(source);
/* 40 */     checkType(type);
/* 41 */     this.type = type;
/*    */   }
/*    */ 
/*    */   public int getType()
/*    */   {
/* 48 */     return this.type;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 53 */     return this.type == 100 ? "FAILOVER_FAILED" : this.type == 40 ? "FAILOVER_ALREADY_COMPLETED" : this.type == 30 ? "FAILOVER_COMPLETED" : this.type == 20 ? "FAILOVER_STARTED" : this.type == 10 ? "FAILURE_DETECTED" : "UNKNOWN_FAILOVER_EVENT";
/*    */   }
/*    */ 
/*    */   private void checkType(int type)
/*    */     throws IllegalArgumentException
/*    */   {
/* 69 */     if ((type != 10) && (type != 20) && (type != 30) && (type != 100) && (type != 40))
/*    */     {
/* 75 */       throw new IllegalArgumentException("Illegal failover event type: " + type);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.FailoverEvent
 * JD-Core Version:    0.6.0
 */