/*     */ package org.jboss.jms.client;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.client.state.ConnectionState;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class FailoverCommandCenter
/*     */ {
/*  32 */   private static final Logger log = Logger.getLogger(FailoverCommandCenter.class);
/*     */ 
/*  36 */   private static boolean trace = log.isTraceEnabled();
/*     */   private ConnectionState state;
/*     */   private FailoverValve2 valve;
/*     */   private List failoverListeners;
/*     */ 
/*     */   public FailoverCommandCenter(ConnectionState state)
/*     */   {
/*  50 */     this.state = state;
/*  51 */     this.failoverListeners = new ArrayList();
/*     */ 
/*  53 */     this.valve = new FailoverValve2();
/*     */   }
/*     */ 
/*     */   public void setState(ConnectionState state)
/*     */   {
/*  60 */     this.state = state; } 
/*     */   // ERROR //
/*     */   public boolean failureDetected(java.lang.Throwable reason, FailureDetector source, JMSRemotingConnection remotingConnection) throws Exception { // Byte code:
/*     */     //   0: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   3: new 10	java/lang/StringBuilder
/*     */     //   6: dup
/*     */     //   7: invokespecial 11	java/lang/StringBuilder:<init>	()V
/*     */     //   10: ldc 12
/*     */     //   12: invokevirtual 13	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   15: aload_2
/*     */     //   16: invokevirtual 14	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*     */     //   19: invokevirtual 15	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   22: aload_1
/*     */     //   23: invokevirtual 16	org/jboss/logging/Logger:debug	(Ljava/lang/Object;Ljava/lang/Throwable;)V
/*     */     //   26: aload_0
/*     */     //   27: new 17	org/jboss/jms/client/FailoverEvent
/*     */     //   30: dup
/*     */     //   31: bipush 10
/*     */     //   33: aload_2
/*     */     //   34: invokespecial 18	org/jboss/jms/client/FailoverEvent:<init>	(ILjava/lang/Object;)V
/*     */     //   37: invokespecial 19	org/jboss/jms/client/FailoverCommandCenter:broadcastFailoverEvent	(Lorg/jboss/jms/client/FailoverEvent;)V
/*     */     //   40: aconst_null
/*     */     //   41: astore 4
/*     */     //   43: iconst_0
/*     */     //   44: istore 5
/*     */     //   46: iconst_0
/*     */     //   47: istore 6
/*     */     //   49: bipush 30
/*     */     //   51: istore 7
/*     */     //   53: aload_0
/*     */     //   54: getfield 8	org/jboss/jms/client/FailoverCommandCenter:valve	Lorg/jboss/jms/client/FailoverValve2;
/*     */     //   57: invokevirtual 20	org/jboss/jms/client/FailoverValve2:close	()V
/*     */     //   60: aload_0
/*     */     //   61: dup
/*     */     //   62: astore 8
/*     */     //   64: monitorenter
/*     */     //   65: aload_3
/*     */     //   66: invokevirtual 21	org/jboss/jms/client/remoting/JMSRemotingConnection:isFailed	()Z
/*     */     //   69: ifeq +52 -> 121
/*     */     //   72: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   75: new 10	java/lang/StringBuilder
/*     */     //   78: dup
/*     */     //   79: invokespecial 11	java/lang/StringBuilder:<init>	()V
/*     */     //   82: aload_0
/*     */     //   83: invokevirtual 14	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*     */     //   86: ldc 22
/*     */     //   88: invokevirtual 13	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   91: ldc 23
/*     */     //   93: invokevirtual 13	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   96: invokevirtual 15	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   99: invokevirtual 24	org/jboss/logging/Logger:debug	(Ljava/lang/Object;)V
/*     */     //   102: iconst_1
/*     */     //   103: istore 5
/*     */     //   105: bipush 40
/*     */     //   107: istore 7
/*     */     //   109: iconst_1
/*     */     //   110: istore 9
/*     */     //   112: aload 8
/*     */     //   114: monitorexit
/*     */     //   115: jsr +268 -> 383
/*     */     //   118: iload 9
/*     */     //   120: ireturn
/*     */     //   121: aload_3
/*     */     //   122: invokevirtual 25	org/jboss/jms/client/remoting/JMSRemotingConnection:setFailed	()V
/*     */     //   125: aload 8
/*     */     //   127: monitorexit
/*     */     //   128: goto +11 -> 139
/*     */     //   131: astore 10
/*     */     //   133: aload 8
/*     */     //   135: monitorexit
/*     */     //   136: aload 10
/*     */     //   138: athrow
/*     */     //   139: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   142: ldc 26
/*     */     //   144: invokevirtual 27	org/jboss/logging/Logger:info	(Ljava/lang/Object;)V
/*     */     //   147: aload_0
/*     */     //   148: new 17	org/jboss/jms/client/FailoverEvent
/*     */     //   151: dup
/*     */     //   152: bipush 20
/*     */     //   154: aload_0
/*     */     //   155: invokespecial 18	org/jboss/jms/client/FailoverEvent:<init>	(ILjava/lang/Object;)V
/*     */     //   158: invokespecial 19	org/jboss/jms/client/FailoverCommandCenter:broadcastFailoverEvent	(Lorg/jboss/jms/client/FailoverEvent;)V
/*     */     //   161: aload_0
/*     */     //   162: getfield 2	org/jboss/jms/client/FailoverCommandCenter:state	Lorg/jboss/jms/client/state/ConnectionState;
/*     */     //   165: invokevirtual 28	org/jboss/jms/client/state/ConnectionState:getServerID	()I
/*     */     //   168: istore 8
/*     */     //   170: aload_0
/*     */     //   171: getfield 2	org/jboss/jms/client/FailoverCommandCenter:state	Lorg/jboss/jms/client/state/ConnectionState;
/*     */     //   174: invokevirtual 29	org/jboss/jms/client/state/ConnectionState:getClusteredConnectionFactoryDelegate	()Lorg/jboss/jms/delegate/ConnectionFactoryDelegate;
/*     */     //   177: astore 9
/*     */     //   179: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   182: ldc 30
/*     */     //   184: invokevirtual 31	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   187: aload 9
/*     */     //   189: aload_0
/*     */     //   190: getfield 2	org/jboss/jms/client/FailoverCommandCenter:state	Lorg/jboss/jms/client/state/ConnectionState;
/*     */     //   193: invokevirtual 32	org/jboss/jms/client/state/ConnectionState:getUsername	()Ljava/lang/String;
/*     */     //   196: aload_0
/*     */     //   197: getfield 2	org/jboss/jms/client/FailoverCommandCenter:state	Lorg/jboss/jms/client/state/ConnectionState;
/*     */     //   200: invokevirtual 33	org/jboss/jms/client/state/ConnectionState:getPassword	()Ljava/lang/String;
/*     */     //   203: iload 8
/*     */     //   205: invokeinterface 34 4 0
/*     */     //   210: astore 4
/*     */     //   212: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   215: ldc 35
/*     */     //   217: invokevirtual 31	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   220: aload 4
/*     */     //   222: ifnonnull +17 -> 239
/*     */     //   225: iconst_0
/*     */     //   226: istore 5
/*     */     //   228: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   231: ldc 36
/*     */     //   233: invokevirtual 31	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   236: goto +106 -> 342
/*     */     //   239: aload 4
/*     */     //   241: invokevirtual 37	org/jboss/jms/delegate/CreateConnectionResult:getDelegate	()Lorg/jboss/jms/client/delegate/ClientConnectionDelegate;
/*     */     //   244: astore 10
/*     */     //   246: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   249: ldc 38
/*     */     //   251: invokevirtual 31	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   254: aload_0
/*     */     //   255: getfield 2	org/jboss/jms/client/FailoverCommandCenter:state	Lorg/jboss/jms/client/state/ConnectionState;
/*     */     //   258: invokevirtual 39	org/jboss/jms/client/state/ConnectionState:getDelegate	()Lorg/jboss/jms/client/delegate/DelegateSupport;
/*     */     //   261: aload 10
/*     */     //   263: invokevirtual 40	org/jboss/jms/client/delegate/DelegateSupport:synchronizeWith	(Lorg/jboss/jms/client/delegate/DelegateSupport;)V
/*     */     //   266: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   269: ldc 41
/*     */     //   271: invokevirtual 31	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   274: aload_0
/*     */     //   275: getfield 2	org/jboss/jms/client/FailoverCommandCenter:state	Lorg/jboss/jms/client/state/ConnectionState;
/*     */     //   278: invokevirtual 42	org/jboss/jms/client/state/ConnectionState:isStarted	()Z
/*     */     //   281: ifeq +24 -> 305
/*     */     //   284: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   287: ldc 43
/*     */     //   289: invokevirtual 31	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   292: aload 10
/*     */     //   294: invokevirtual 44	org/jboss/jms/client/delegate/ClientConnectionDelegate:startAfterFailover	()V
/*     */     //   297: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   300: ldc 45
/*     */     //   302: invokevirtual 31	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   305: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   308: ldc 46
/*     */     //   310: invokevirtual 31	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   313: aload_0
/*     */     //   314: getfield 8	org/jboss/jms/client/FailoverCommandCenter:valve	Lorg/jboss/jms/client/FailoverValve2;
/*     */     //   317: invokevirtual 47	org/jboss/jms/client/FailoverValve2:open	()V
/*     */     //   320: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   323: ldc 48
/*     */     //   325: invokevirtual 31	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   328: iconst_1
/*     */     //   329: istore 6
/*     */     //   331: iconst_1
/*     */     //   332: istore 5
/*     */     //   334: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   337: ldc 49
/*     */     //   339: invokevirtual 27	org/jboss/logging/Logger:info	(Ljava/lang/Object;)V
/*     */     //   342: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   345: ldc 50
/*     */     //   347: invokevirtual 31	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   350: iload 5
/*     */     //   352: istore 10
/*     */     //   354: jsr +29 -> 383
/*     */     //   357: iload 10
/*     */     //   359: ireturn
/*     */     //   360: astore 8
/*     */     //   362: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   365: ldc 52
/*     */     //   367: aload 8
/*     */     //   369: invokevirtual 53	org/jboss/logging/Logger:error	(Ljava/lang/Object;Ljava/lang/Throwable;)V
/*     */     //   372: aload 8
/*     */     //   374: athrow
/*     */     //   375: astore 11
/*     */     //   377: jsr +6 -> 383
/*     */     //   380: aload 11
/*     */     //   382: athrow
/*     */     //   383: astore 12
/*     */     //   385: iload 6
/*     */     //   387: ifne +26 -> 413
/*     */     //   390: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   393: ldc 54
/*     */     //   395: invokevirtual 31	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   398: aload_0
/*     */     //   399: getfield 8	org/jboss/jms/client/FailoverCommandCenter:valve	Lorg/jboss/jms/client/FailoverValve2;
/*     */     //   402: invokevirtual 47	org/jboss/jms/client/FailoverValve2:open	()V
/*     */     //   405: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   408: ldc 55
/*     */     //   410: invokevirtual 31	org/jboss/logging/Logger:trace	(Ljava/lang/Object;)V
/*     */     //   413: iload 5
/*     */     //   415: ifeq +45 -> 460
/*     */     //   418: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   421: new 10	java/lang/StringBuilder
/*     */     //   424: dup
/*     */     //   425: invokespecial 11	java/lang/StringBuilder:<init>	()V
/*     */     //   428: aload_0
/*     */     //   429: invokevirtual 14	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*     */     //   432: ldc 56
/*     */     //   434: invokevirtual 13	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   437: invokevirtual 15	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   440: invokevirtual 24	org/jboss/logging/Logger:debug	(Ljava/lang/Object;)V
/*     */     //   443: aload_0
/*     */     //   444: new 17	org/jboss/jms/client/FailoverEvent
/*     */     //   447: dup
/*     */     //   448: iload 7
/*     */     //   450: aload_0
/*     */     //   451: invokespecial 18	org/jboss/jms/client/FailoverEvent:<init>	(ILjava/lang/Object;)V
/*     */     //   454: invokespecial 19	org/jboss/jms/client/FailoverCommandCenter:broadcastFailoverEvent	(Lorg/jboss/jms/client/FailoverEvent;)V
/*     */     //   457: goto +68 -> 525
/*     */     //   460: getstatic 9	org/jboss/jms/client/FailoverCommandCenter:log	Lorg/jboss/logging/Logger;
/*     */     //   463: new 10	java/lang/StringBuilder
/*     */     //   466: dup
/*     */     //   467: invokespecial 11	java/lang/StringBuilder:<init>	()V
/*     */     //   470: aload_0
/*     */     //   471: invokevirtual 14	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*     */     //   474: ldc 57
/*     */     //   476: invokevirtual 13	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*     */     //   479: invokevirtual 15	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*     */     //   482: invokevirtual 24	org/jboss/logging/Logger:debug	(Ljava/lang/Object;)V
/*     */     //   485: aload_0
/*     */     //   486: getfield 2	org/jboss/jms/client/FailoverCommandCenter:state	Lorg/jboss/jms/client/state/ConnectionState;
/*     */     //   489: invokevirtual 39	org/jboss/jms/client/state/ConnectionState:getDelegate	()Lorg/jboss/jms/client/delegate/DelegateSupport;
/*     */     //   492: checkcast 58	org/jboss/jms/client/delegate/ClientConnectionDelegate
/*     */     //   495: astore 13
/*     */     //   497: aload 13
/*     */     //   499: ldc2_w 59
/*     */     //   502: invokevirtual 61	org/jboss/jms/client/delegate/ClientConnectionDelegate:closing	(J)J
/*     */     //   505: pop2
/*     */     //   506: aload 13
/*     */     //   508: invokevirtual 62	org/jboss/jms/client/delegate/ClientConnectionDelegate:close	()V
/*     */     //   511: aload_0
/*     */     //   512: new 17	org/jboss/jms/client/FailoverEvent
/*     */     //   515: dup
/*     */     //   516: bipush 100
/*     */     //   518: aload_0
/*     */     //   519: invokespecial 18	org/jboss/jms/client/FailoverEvent:<init>	(ILjava/lang/Object;)V
/*     */     //   522: invokespecial 19	org/jboss/jms/client/FailoverCommandCenter:broadcastFailoverEvent	(Lorg/jboss/jms/client/FailoverEvent;)V
/*     */     //   525: ret 12
/*     */     //
/*     */     // Exception table:
/*     */     //   from	to	target	type
/*     */     //   65	115	131	finally
/*     */     //   121	128	131	finally
/*     */     //   131	136	131	finally
/*     */     //   53	118	360	java/lang/Exception
/*     */     //   121	357	360	java/lang/Exception
/*     */     //   53	118	375	finally
/*     */     //   121	357	375	finally
/*     */     //   360	380	375	finally } 
/* 212 */   public void registerFailoverListener(FailoverListener listener) { synchronized (this.failoverListeners)
/*     */     {
/* 214 */       this.failoverListeners.add(listener);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean unregisterFailoverListener(FailoverListener listener)
/*     */   {
/* 220 */     synchronized (this.failoverListeners)
/*     */     {
/* 222 */       return this.failoverListeners.remove(listener);
/*     */     }
/*     */   }
/*     */ 
/*     */   public FailoverValve2 getValve()
/*     */   {
/* 228 */     return this.valve;
/*     */   }
/*     */ 
/*     */   public JMSRemotingConnection getRemotingConnection()
/*     */   {
/* 233 */     return this.state.getRemotingConnection();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 238 */     return "FailoverCommandCenter[" + this.state + "]";
/*     */   }
/*     */ 
/*     */   ConnectionState getConnectionState()
/*     */   {
/* 245 */     return this.state;
/*     */   }
/*     */ 
/*     */   private void broadcastFailoverEvent(FailoverEvent e)
/*     */   {
/* 254 */     if (trace) log.trace(this + " broadcasting " + e);
/*     */     List listenersCopy;
/* 258 */     synchronized (this.failoverListeners)
/*     */     {
/* 260 */       listenersCopy = new ArrayList(this.failoverListeners);
/*     */     }
/*     */ 
/* 263 */     for (Iterator i = listenersCopy.iterator(); i.hasNext(); )
/*     */     {
/* 265 */       FailoverListener listener = (FailoverListener)i.next();
/*     */       try
/*     */       {
/* 269 */         listener.failoverEventOccured(e);
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 273 */         log.warn("Failover listener " + listener + " did not accept event", ex);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.FailoverCommandCenter
 * JD-Core Version:    0.6.0
 */