/*     */ package org.jboss.jms;
/*     */ 
/*     */ import javax.jms.Connection;
/*     */ import javax.jms.ConnectionFactory;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.QueueConnection;
/*     */ import javax.jms.QueueConnectionFactory;
/*     */ import javax.jms.TopicConnection;
/*     */ import javax.jms.TopicConnectionFactory;
/*     */ import javax.jms.XAConnectionFactory;
/*     */ import javax.jms.XAQueueConnectionFactory;
/*     */ import javax.jms.XATopicConnectionFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ConnectionFactoryHelper
/*     */ {
/*  47 */   private static Logger log = Logger.getLogger(ConnectionFactoryHelper.class);
/*     */ 
/*     */   public static Connection createConnection(Object factory, String username, String password)
/*     */     throws JMSException
/*     */   {
/*  66 */     if (factory == null) {
/*  67 */       throw new IllegalArgumentException("factory is null");
/*     */     }
/*  69 */     log.debug("using connection factory: " + factory);
/*  70 */     log.debug("using username/password: " + String.valueOf(username) + "/-- not shown --");
/*     */ 
/*  74 */     if ((factory instanceof XAConnectionFactory))
/*     */     {
/*  76 */       XAConnectionFactory qFactory = (XAConnectionFactory)factory;
/*     */       Connection connection;
/*     */       Connection connection;
/*  77 */       if (username != null)
/*  78 */         connection = qFactory.createXAConnection(username, password);
/*     */       else {
/*  80 */         connection = qFactory.createXAConnection();
/*     */       }
/*  82 */       log.debug("created XAConnection: " + connection);
/*     */     }
/*  84 */     else if ((factory instanceof ConnectionFactory))
/*     */     {
/*  86 */       ConnectionFactory qFactory = (ConnectionFactory)factory;
/*     */       Connection connection;
/*     */       Connection connection;
/*  87 */       if (username != null)
/*  88 */         connection = qFactory.createConnection(username, password);
/*     */       else {
/*  90 */         connection = qFactory.createConnection();
/*     */       }
/*  92 */       log.debug("created Connection: " + connection);
/*     */     }
/*     */     else
/*     */     {
/*  96 */       throw new IllegalArgumentException("factory is invalid");
/*     */     }
/*     */     Connection connection;
/*  99 */     return connection;
/*     */   }
/*     */ 
/*     */   public static Connection createConnection(Object factory)
/*     */     throws JMSException
/*     */   {
/* 115 */     return createConnection(factory, null, null);
/*     */   }
/*     */ 
/*     */   public static QueueConnection createQueueConnection(Object factory, String username, String password)
/*     */     throws JMSException
/*     */   {
/* 135 */     if (factory == null) {
/* 136 */       throw new IllegalArgumentException("factory is null");
/*     */     }
/* 138 */     log.debug("using connection factory: " + factory);
/* 139 */     log.debug("using username/password: " + String.valueOf(username) + "/-- not shown --");
/*     */ 
/* 143 */     if ((factory instanceof XAQueueConnectionFactory))
/*     */     {
/* 145 */       XAQueueConnectionFactory qFactory = (XAQueueConnectionFactory)factory;
/*     */       QueueConnection connection;
/*     */       QueueConnection connection;
/* 146 */       if (username != null)
/* 147 */         connection = qFactory.createXAQueueConnection(username, password);
/*     */       else {
/* 149 */         connection = qFactory.createXAQueueConnection();
/*     */       }
/* 151 */       log.debug("created XAQueueConnection: " + connection);
/*     */     }
/* 153 */     else if ((factory instanceof QueueConnectionFactory))
/*     */     {
/* 155 */       QueueConnectionFactory qFactory = (QueueConnectionFactory)factory;
/*     */       QueueConnection connection;
/*     */       QueueConnection connection;
/* 156 */       if (username != null)
/* 157 */         connection = qFactory.createQueueConnection(username, password);
/*     */       else {
/* 159 */         connection = qFactory.createQueueConnection();
/*     */       }
/* 161 */       log.debug("created QueueConnection: " + connection);
/*     */     }
/*     */     else {
/* 164 */       throw new IllegalArgumentException("factory is invalid");
/*     */     }
/*     */     QueueConnection connection;
/* 166 */     return connection;
/*     */   }
/*     */ 
/*     */   public static QueueConnection createQueueConnection(Object factory)
/*     */     throws JMSException
/*     */   {
/* 182 */     return createQueueConnection(factory, null, null);
/*     */   }
/*     */ 
/*     */   public static TopicConnection createTopicConnection(Object factory, String username, String password)
/*     */     throws JMSException
/*     */   {
/* 202 */     if (factory == null) {
/* 203 */       throw new IllegalArgumentException("factory is null");
/*     */     }
/* 205 */     log.debug("using connection factory: " + factory);
/* 206 */     log.debug("using username/password: " + String.valueOf(username) + "/-- not shown --");
/*     */ 
/* 210 */     if ((factory instanceof XATopicConnectionFactory))
/*     */     {
/* 212 */       XATopicConnectionFactory tFactory = (XATopicConnectionFactory)factory;
/*     */       TopicConnection connection;
/*     */       TopicConnection connection;
/* 213 */       if (username != null)
/* 214 */         connection = tFactory.createXATopicConnection(username, password);
/*     */       else {
/* 216 */         connection = tFactory.createXATopicConnection();
/*     */       }
/* 218 */       log.debug("created XATopicConnection: " + connection);
/*     */     }
/* 220 */     else if ((factory instanceof TopicConnectionFactory))
/*     */     {
/* 222 */       TopicConnectionFactory tFactory = (TopicConnectionFactory)factory;
/*     */       TopicConnection connection;
/*     */       TopicConnection connection;
/* 223 */       if (username != null)
/* 224 */         connection = tFactory.createTopicConnection(username, password);
/*     */       else {
/* 226 */         connection = tFactory.createTopicConnection();
/*     */       }
/* 228 */       log.debug("created TopicConnection: " + connection);
/*     */     }
/*     */     else {
/* 231 */       throw new IllegalArgumentException("factory is invalid");
/*     */     }
/*     */     TopicConnection connection;
/* 233 */     return connection;
/*     */   }
/*     */ 
/*     */   public static TopicConnection createTopicConnection(Object factory)
/*     */     throws JMSException
/*     */   {
/* 249 */     return createTopicConnection(factory, null, null);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.ConnectionFactoryHelper
 * JD-Core Version:    0.6.0
 */