/*     */ package org.jboss.jdbc;
/*     */ 
/*     */ import java.awt.HeadlessException;
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.sql.Connection;
/*     */ import java.sql.DriverManager;
/*     */ import java.sql.Statement;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.system.server.ServerConfig;
/*     */ import org.jboss.system.server.ServerConfigLocator;
/*     */ 
/*     */ public class HypersonicDatabase extends ServiceMBeanSupport
/*     */   implements HypersonicDatabaseMBean
/*     */ {
/*     */   private static final String DEFAULT_PASSWORD = "";
/*     */   private static final String DEFAULT_USER = "sa";
/*     */   private static final String JDBC_DRIVER_CLASS = "org.hsqldb.jdbcDriver";
/*     */   private static final String JDBC_URL_PREFIX = "jdbc:hsqldb:";
/*     */   private static final String DEFAULT_REMOTE_SHUTDOWN_COMMAND = "SHUTDOWN COMPACT";
/*     */   private static final String DEFAULT_IN_PROCESS_SHUTDOWN_COMMAND = "SHUTDOWN COMPACT";
/*     */   private static final String DEFAULT_IN_MEMORY_SHUTDOWN_COMMAND = "SHUTDOWN IMMEDIATELY";
/*     */   private static final String HYPERSONIC_DATA_DIR = "hypersonic";
/*     */   private static final int DEFAULT_PORT = 1701;
/*     */   private static final String DEFAULT_ADDRESS = "0.0.0.0";
/*     */   private static final String DEFAULT_DATABASE_NAME = "default";
/*     */   private static final String IN_MEMORY_DATABASE = ".";
/*     */   private static final String DEFAULT_DATABASE_MANAGER_CLASS = "org.hsqldb.util.DatabaseManagerSwing";
/*     */   private static final String DEFAULT_SERVER_CLASS = "org.hsqldb.Server";
/*     */   private File dbPath;
/*  97 */   private String name = "default";
/*     */ 
/* 100 */   private int port = 1701;
/*     */ 
/* 103 */   private String address = "0.0.0.0";
/*     */ 
/* 106 */   private boolean silent = true;
/*     */ 
/* 109 */   private boolean trace = false;
/*     */ 
/* 112 */   private boolean no_system_exit = true;
/*     */ 
/* 115 */   private boolean persist = true;
/*     */   private String shutdownCommand;
/* 121 */   private boolean inProcessMode = false;
/*     */ 
/* 124 */   private String user = "sa";
/*     */ 
/* 127 */   private String password = "";
/*     */ 
/* 130 */   private String databaseManagerClass = "org.hsqldb.util.DatabaseManagerSwing";
/*     */ 
/* 133 */   private String serverClass = "org.hsqldb.Server";
/*     */   private Thread serverThread;
/*     */   private Connection connection;
/*     */   private String dbDataDir;
/*     */ 
/*     */   public String getDbDataDir()
/*     */   {
/* 157 */     return this.dbDataDir;
/*     */   }
/*     */ 
/*     */   public void setDbDataDir(String dbDataDir)
/*     */   {
/* 162 */     this.dbDataDir = dbDataDir;
/*     */   }
/*     */ 
/*     */   public void setDatabase(String name)
/*     */   {
/* 172 */     if (name == null)
/*     */     {
/* 174 */       name = "default";
/*     */     }
/* 176 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getDatabase()
/*     */   {
/* 186 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setPort(int port)
/*     */   {
/* 196 */     this.port = port;
/*     */   }
/*     */ 
/*     */   public int getPort()
/*     */   {
/* 206 */     return this.port;
/*     */   }
/*     */ 
/*     */   public void setBindAddress(String address)
/*     */   {
/* 216 */     this.address = address;
/*     */   }
/*     */ 
/*     */   public String getBindAddress()
/*     */   {
/* 226 */     return this.address;
/*     */   }
/*     */ 
/*     */   public void setSilent(boolean silent)
/*     */   {
/* 236 */     this.silent = silent;
/*     */   }
/*     */ 
/*     */   public boolean getSilent()
/*     */   {
/* 246 */     return this.silent;
/*     */   }
/*     */ 
/*     */   public void setTrace(boolean trace)
/*     */   {
/* 256 */     this.trace = trace;
/*     */   }
/*     */ 
/*     */   public boolean getTrace()
/*     */   {
/* 266 */     return this.trace;
/*     */   }
/*     */ 
/*     */   public void setNo_system_exit(boolean no_system_exit)
/*     */   {
/* 276 */     this.no_system_exit = no_system_exit;
/*     */   }
/*     */ 
/*     */   public boolean getNo_system_exit()
/*     */   {
/* 286 */     return this.no_system_exit;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void setPersist(boolean persist)
/*     */   {
/* 298 */     this.persist = persist;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public boolean getPersist()
/*     */   {
/* 310 */     return this.persist;
/*     */   }
/*     */ 
/*     */   public String getDatabasePath()
/*     */   {
/* 320 */     if (this.dbPath != null)
/*     */     {
/* 322 */       return this.dbPath.toString();
/*     */     }
/*     */ 
/* 326 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean isInProcessMode()
/*     */   {
/* 337 */     return this.inProcessMode;
/*     */   }
/*     */ 
/*     */   public String getShutdownCommand()
/*     */   {
/* 347 */     return this.shutdownCommand;
/*     */   }
/*     */ 
/*     */   public void setInProcessMode(boolean b)
/*     */   {
/* 359 */     this.inProcessMode = b;
/*     */   }
/*     */ 
/*     */   public void setShutdownCommand(String string)
/*     */   {
/* 369 */     this.shutdownCommand = string;
/*     */   }
/*     */ 
/*     */   public String getPassword()
/*     */   {
/* 379 */     return this.password;
/*     */   }
/*     */ 
/*     */   public String getUser()
/*     */   {
/* 389 */     return this.user;
/*     */   }
/*     */ 
/*     */   public void setPassword(String password)
/*     */   {
/* 399 */     if (password == null)
/*     */     {
/* 401 */       password = "";
/*     */     }
/* 403 */     this.password = password;
/*     */   }
/*     */ 
/*     */   public void setUser(String user)
/*     */   {
/* 413 */     if (user == null)
/*     */     {
/* 415 */       user = "sa";
/*     */     }
/* 417 */     this.user = user;
/*     */   }
/*     */ 
/*     */   public String getDatabaseManagerClass()
/*     */   {
/* 427 */     return this.databaseManagerClass;
/*     */   }
/*     */ 
/*     */   public void setDatabaseManagerClass(String databaseManagerClass)
/*     */   {
/* 439 */     if (databaseManagerClass == null)
/*     */     {
/* 441 */       databaseManagerClass = "org.hsqldb.util.DatabaseManagerSwing";
/*     */     }
/* 443 */     this.databaseManagerClass = databaseManagerClass;
/*     */   }
/*     */ 
/*     */   public String getServerClass()
/*     */   {
/* 451 */     return this.serverClass;
/*     */   }
/*     */ 
/*     */   public void setServerClass(String serverClass)
/*     */   {
/* 461 */     if (serverClass == null)
/*     */     {
/* 463 */       serverClass = "org.hsqldb.Server";
/*     */     }
/* 465 */     this.serverClass = serverClass;
/*     */   }
/*     */ 
/*     */   public void startDatabaseManager()
/*     */   {
/* 478 */     new Thread()
/*     */     {
/*     */       public void run()
/*     */       {
/*     */         try
/*     */         {
/* 485 */           String connectHost = "0.0.0.0".equals(HypersonicDatabase.this.address) ? "localhost" : HypersonicDatabase.this.address;
/* 486 */           String driver = "org.hsqldb.jdbcDriver";
/*     */           String[] args;
/*     */           String[] args;
/* 488 */           if (!HypersonicDatabase.this.inProcessMode)
/*     */           {
/* 490 */             args = new String[] { "-noexit", "-driver", driver, "-url", "jdbc:hsqldb:hsql://" + connectHost + ":" + HypersonicDatabase.access$200(HypersonicDatabase.this), "-user", HypersonicDatabase.access$300(HypersonicDatabase.this), "-password", HypersonicDatabase.access$400(HypersonicDatabase.this), "-dir", HypersonicDatabase.this.getDatabasePath() };
/*     */           }
/*     */           else
/*     */           {
/*     */             String[] args;
/* 500 */             if (".".equals(HypersonicDatabase.this.name))
/*     */             {
/* 502 */               args = new String[] { "-noexit", "-driver", driver, "-url", "jdbc:hsqldb:.", "-user", HypersonicDatabase.access$300(HypersonicDatabase.this), "-password", HypersonicDatabase.access$400(HypersonicDatabase.this) };
/*     */             }
/*     */             else
/*     */             {
/* 513 */               args = new String[] { "-noexit", "-driver", driver, "-url", "jdbc:hsqldb:" + HypersonicDatabase.this.getDatabasePath(), "-user", HypersonicDatabase.access$300(HypersonicDatabase.this), "-password", HypersonicDatabase.access$400(HypersonicDatabase.this), "-dir", HypersonicDatabase.this.getDatabasePath() };
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/* 525 */           ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 526 */           Class clazz = Class.forName(HypersonicDatabase.this.databaseManagerClass, true, cl);
/* 527 */           Method main = clazz.getMethod("main", new Class[] { args.getClass() });
/* 528 */           main.invoke(null, new Object[] { args });
/*     */         }
/*     */         catch (HeadlessException e)
/*     */         {
/* 532 */           HypersonicDatabase.this.log.error("Failed to start database manager because this is an headless configuration (no display, mouse or keyword)");
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 536 */           HypersonicDatabase.this.log.error("Failed to start database manager", e);
/*     */         }
/*     */       }
/*     */     }
/* 478 */     .start();
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 551 */     if (!this.persist)
/*     */     {
/* 553 */       this.inProcessMode = true;
/* 554 */       this.name = ".";
/*     */     }
/*     */ 
/* 558 */     if (!this.inProcessMode)
/*     */     {
/* 560 */       startRemoteDatabase();
/*     */     }
/* 562 */     else if (".".equals(this.name))
/*     */     {
/* 564 */       startInMemoryDatabase();
/*     */     }
/*     */     else
/*     */     {
/* 568 */       startStandaloneDatabase();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/* 580 */     if (!this.inProcessMode)
/*     */     {
/* 582 */       stopRemoteDatabase();
/*     */     }
/* 584 */     else if (".".equals(this.name))
/*     */     {
/* 586 */       stopInMemoryDatabase();
/*     */     }
/*     */     else
/*     */     {
/* 590 */       stopStandaloneDatabase();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void startStandaloneDatabase()
/*     */     throws Exception
/*     */   {
/* 602 */     File dataDir = null;
/*     */ 
/* 604 */     if (this.dbDataDir == null) dataDir = ServerConfigLocator.locate().getServerDataDir(); else {
/* 605 */       dataDir = new File(this.dbDataDir);
/*     */     }
/*     */ 
/* 608 */     File hypersoniDir = new File(dataDir, "hypersonic");
/*     */ 
/* 610 */     if (!hypersoniDir.exists())
/*     */     {
/* 612 */       hypersoniDir.mkdirs();
/*     */     }
/*     */ 
/* 615 */     if (!hypersoniDir.isDirectory())
/*     */     {
/* 617 */       throw new IOException("Failed to create directory: " + hypersoniDir);
/*     */     }
/*     */ 
/* 620 */     this.dbPath = new File(hypersoniDir, this.name);
/*     */ 
/* 622 */     String dbURL = "jdbc:hsqldb:" + getDatabasePath();
/*     */ 
/* 625 */     this.connection = getConnection(dbURL);
/*     */   }
/*     */ 
/*     */   private void startInMemoryDatabase()
/*     */     throws Exception
/*     */   {
/* 633 */     String dbURL = "jdbc:hsqldb:.";
/*     */ 
/* 636 */     this.connection = getConnection(dbURL);
/*     */   }
/*     */ 
/*     */   private void startRemoteDatabase()
/*     */     throws Exception
/*     */   {
/* 645 */     File dataDir = null;
/* 646 */     if (this.dbDataDir == null) dataDir = ServerConfigLocator.locate().getServerDataDir(); else {
/* 647 */       dataDir = new File(this.dbDataDir);
/*     */     }
/*     */ 
/* 650 */     File hypersoniDir = new File(dataDir, "hypersonic");
/*     */ 
/* 652 */     if (!hypersoniDir.exists())
/*     */     {
/* 654 */       hypersoniDir.mkdirs();
/*     */     }
/*     */ 
/* 657 */     if (!hypersoniDir.isDirectory())
/*     */     {
/* 659 */       throw new IOException("Failed to create directory: " + hypersoniDir);
/*     */     }
/*     */ 
/* 662 */     this.dbPath = new File(hypersoniDir, this.name);
/*     */ 
/* 665 */     this.serverThread = new Thread("hypersonic-" + this.name)
/*     */     {
/*     */       public void run()
/*     */       {
/*     */         try
/*     */         {
/* 672 */           String[] args = { "-database", HypersonicDatabase.access$900(HypersonicDatabase.this).toString(), "-port", String.valueOf(HypersonicDatabase.access$200(HypersonicDatabase.this)), "-address", HypersonicDatabase.access$000(HypersonicDatabase.this), "-silent", String.valueOf(HypersonicDatabase.access$1000(HypersonicDatabase.this)), "-trace", String.valueOf(HypersonicDatabase.access$1100(HypersonicDatabase.this)), "-no_system_exit", String.valueOf(HypersonicDatabase.access$1200(HypersonicDatabase.this)) };
/*     */ 
/* 683 */           ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 684 */           Class clazz = Class.forName(HypersonicDatabase.this.serverClass, true, cl);
/* 685 */           Method main = clazz.getMethod("main", new Class[] { args.getClass() });
/* 686 */           main.invoke(null, new Object[] { args });
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 690 */           HypersonicDatabase.this.log.error("Failed to start database", e);
/*     */         }
/*     */       }
/*     */     };
/* 694 */     this.serverThread.start();
/*     */   }
/*     */ 
/*     */   private void stopStandaloneDatabase()
/*     */     throws Exception
/*     */   {
/* 702 */     String dbURL = "jdbc:hsqldb:" + getDatabasePath();
/*     */ 
/* 704 */     Connection connection = getConnection(dbURL);
/* 705 */     Statement statement = connection.createStatement();
/*     */ 
/* 707 */     String shutdownCommand = this.shutdownCommand;
/* 708 */     if (shutdownCommand == null)
/*     */     {
/* 710 */       shutdownCommand = "SHUTDOWN COMPACT";
/*     */     }
/*     */ 
/* 713 */     statement.executeQuery(shutdownCommand);
/* 714 */     this.connection = null;
/* 715 */     this.log.info("Database standalone closed clean");
/*     */   }
/*     */ 
/*     */   private void stopInMemoryDatabase()
/*     */     throws Exception
/*     */   {
/* 723 */     String dbURL = "jdbc:hsqldb:.";
/*     */ 
/* 725 */     Connection connection = getConnection(dbURL);
/* 726 */     Statement statement = connection.createStatement();
/*     */ 
/* 728 */     String shutdownCommand = this.shutdownCommand;
/* 729 */     if (shutdownCommand == null)
/*     */     {
/* 731 */       shutdownCommand = "SHUTDOWN IMMEDIATELY";
/*     */     }
/*     */ 
/* 734 */     statement.executeQuery(shutdownCommand);
/* 735 */     this.connection = null;
/* 736 */     this.log.info("Database in memory closed clean");
/*     */   }
/*     */ 
/*     */   private void stopRemoteDatabase()
/*     */     throws Exception
/*     */   {
/* 745 */     String connectHost = "0.0.0.0".equals(this.address) ? "localhost" : this.address;
/* 746 */     String dbURL = "jdbc:hsqldb:hsql://" + connectHost + ":" + this.port;
/*     */ 
/* 748 */     Connection connection = getConnection(dbURL);
/* 749 */     Statement statement = connection.createStatement();
/*     */ 
/* 751 */     String shutdownCommand = this.shutdownCommand;
/* 752 */     if (shutdownCommand == null)
/*     */     {
/* 754 */       shutdownCommand = "SHUTDOWN COMPACT";
/*     */     }
/*     */ 
/* 757 */     statement.executeQuery(shutdownCommand);
/*     */ 
/* 759 */     this.serverThread = null;
/* 760 */     this.connection = null;
/* 761 */     this.log.info("Database remote closed clean");
/*     */   }
/*     */ 
/*     */   private synchronized Connection getConnection(String dbURL)
/*     */     throws Exception
/*     */   {
/* 773 */     if (this.connection == null)
/*     */     {
/* 775 */       ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 776 */       Class.forName("org.hsqldb.jdbcDriver", true, cl).newInstance();
/* 777 */       this.connection = DriverManager.getConnection(dbURL, this.user, this.password);
/*     */     }
/* 779 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jdbc.HypersonicDatabase
 * JD-Core Version:    0.6.0
 */