/*    */ package org.jboss.javabean.plugins.xml;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.beans.info.spi.BeanInfo;
/*    */ import org.jboss.beans.info.spi.PropertyInfo;
/*    */ import org.jboss.reflect.spi.TypeInfo;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementInterceptor;
/*    */ 
/*    */ public class PropertyInterceptor extends DefaultElementInterceptor
/*    */ {
/* 44 */   public static final PropertyInterceptor INTERCEPTOR = new PropertyInterceptor();
/*    */ 
/*    */   public void add(Object parent, Object child, QName name)
/*    */   {
/* 60 */     Common.Holder holder = (Common.Holder)parent;
/* 61 */     Object parentValue = holder.getValue();
/* 62 */     Common.Property prop = (Common.Property)child;
/* 63 */     Object value = prop.getValue();
/* 64 */     String property = prop.getProperty();
/*    */     try
/*    */     {
/* 68 */       if ((parentValue instanceof Common.Ctor))
/*    */       {
/* 70 */         Common.Ctor ctor = (Common.Ctor)parentValue;
/* 71 */         if (ctor.isCtorWasDeclared())
/*    */         {
/* 73 */           BeanInfo beanInfo = ConfigurationUtil.getBeanInfo(ctor.getClassName());
/* 74 */           PropertyInfo propertyInfo = beanInfo.getProperty(property);
/* 75 */           value = ConfigurationUtil.convertValue(propertyInfo, prop.getType(), value);
/* 76 */           ctor.addParam(propertyInfo.getType().getName(), value);
/*    */         }
/*    */         else
/*    */         {
/* 81 */           parentValue = ctor.newInstance();
/* 82 */           holder.setValue(parentValue);
/* 83 */           add(parent, child, name);
/*    */         }
/*    */       }
/*    */       else
/*    */       {
/* 88 */         BeanInfo beanInfo = ConfigurationUtil.getBeanInfo(parentValue);
/* 89 */         value = ConfigurationUtil.convertValue(parentValue, property, prop.getType(), value);
/* 90 */         beanInfo.setProperty(parentValue, property, value);
/*    */       }
/*    */     }
/*    */     catch (RuntimeException e)
/*    */     {
/* 95 */       throw e;
/*    */     }
/*    */     catch (Error e)
/*    */     {
/* 99 */       throw e;
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 103 */       throw new RuntimeException("Error setting property " + property + " on object" + parentValue + " with value " + value, t);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.javabean.plugins.xml.PropertyInterceptor
 * JD-Core Version:    0.6.0
 */