/*    */ package org.jboss.javabean.plugins.xml;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingInitializer;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*    */ 
/*    */ public class JavaBeanSchemaInitializer20
/*    */   implements SchemaBindingInitializer
/*    */ {
/*    */   private static final String JAVABEAN_NS = "urn:jboss:javabean:2.0";
/* 45 */   private static final QName javabeanTypeQName = new QName("urn:jboss:javabean:2.0", "javabeanType");
/*    */ 
/* 48 */   private static final QName constructorTypeQName = new QName("urn:jboss:javabean:2.0", "constructorType");
/*    */ 
/* 51 */   private static final QName propertyTypeQName = new QName("urn:jboss:javabean:2.0", "propertyType");
/*    */ 
/* 54 */   private static final QName constructorQName = new QName("urn:jboss:javabean:2.0", "constructor");
/*    */ 
/* 57 */   private static final QName propertyQName = new QName("urn:jboss:javabean:2.0", "property");
/*    */ 
/*    */   public SchemaBinding init(SchemaBinding schema)
/*    */   {
/* 67 */     schema.setReplacePropertyRefs(false);
/*    */ 
/* 70 */     TypeBinding beanType = schema.getType(javabeanTypeQName);
/* 71 */     beanType.setHandler(JavaBeanHandler.HANDLER);
/*    */ 
/* 73 */     beanType.pushInterceptor(constructorQName, ConstructorInterceptor.INTERCEPTOR);
/*    */ 
/* 75 */     beanType.pushInterceptor(propertyQName, PropertyInterceptor.INTERCEPTOR);
/*    */ 
/* 78 */     TypeBinding constructorType = schema.getType(constructorTypeQName);
/* 79 */     constructorType.setHandler(ConstructorHandler.HANDLER);
/*    */ 
/* 81 */     constructorType.pushInterceptor(propertyQName, PropertyInterceptor.INTERCEPTOR);
/*    */ 
/* 84 */     TypeBinding propertyType = schema.getType(propertyTypeQName);
/* 85 */     propertyType.setHandler(PropertyHandler.HANDLER);
/*    */ 
/* 87 */     return schema;
/*    */   }
/*    */ 
/*    */   static
/*    */   {
/* 61 */     ConfigurationUtil.init();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.javabean.plugins.xml.JavaBeanSchemaInitializer20
 * JD-Core Version:    0.6.0
 */