/*     */ package org.jboss.javabean.plugins.xml;
/*     */ 
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class JavaBeanHandler extends DefaultElementHandler
/*     */ {
/*  43 */   public static final JavaBeanHandler HANDLER = new JavaBeanHandler();
/*     */ 
/*     */   public Object startElement(Object parent, QName name, ElementBinding element)
/*     */   {
/*  47 */     return new Common.Holder();
/*     */   }
/*     */ 
/*     */   public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*     */   {
/*  52 */     Common.Holder holder = (Common.Holder)o;
/*  53 */     String className = null;
/*  54 */     for (int i = 0; i < attrs.getLength(); i++)
/*     */     {
/*  56 */       String localName = attrs.getLocalName(i);
/*  57 */       if ("class".equals(localName)) {
/*  58 */         className = attrs.getValue(i);
/*     */       }
/*     */     }
/*  61 */     if (className == null) {
/*  62 */       throw new IllegalArgumentException("No class attribute for " + elementName);
/*     */     }
/*     */     try
/*     */     {
/*  66 */       Common.Ctor ctor = new Common.Ctor(className);
/*  67 */       holder.setValue(ctor);
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/*  71 */       throw e;
/*     */     }
/*     */     catch (Error e)
/*     */     {
/*  75 */       throw e;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  79 */       throw new RuntimeException("Error instantiating class " + className, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object endElement(Object o, QName qName, ElementBinding element)
/*     */   {
/*  85 */     Common.Holder holder = (Common.Holder)o;
/*  86 */     Object result = holder.getValue();
/*     */ 
/*  89 */     if ((result != null) && ((result instanceof Common.Ctor)))
/*     */     {
/*  91 */       Common.Ctor ctor = (Common.Ctor)result;
/*  92 */       result = ctor.getValue();
/*     */ 
/*  95 */       if (result == null)
/*     */       {
/*     */         try
/*     */         {
/*  99 */           return ctor.newInstance();
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 103 */           new RuntimeException("Unable to construct object javabean", t);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 109 */     if (result == null) {
/* 110 */       throw new IllegalStateException("Null object creating javabean");
/*     */     }
/* 112 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.javabean.plugins.xml.JavaBeanHandler
 * JD-Core Version:    0.6.0
 */