/*     */ package org.jboss.javabean.plugins.xml;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.config.plugins.property.PropertyConfiguration;
/*     */ import org.jboss.config.spi.Configuration;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ import org.jboss.util.propertyeditor.PropertyEditors;
/*     */ 
/*     */ public class ConfigurationUtil
/*     */ {
/*     */   private static Configuration config;
/*     */ 
/*     */   static synchronized void init()
/*     */   {
/*  46 */     if (config == null)
/*     */     {
/*  48 */       config = (Configuration)AccessController.doPrivileged(new PrivilegedAction()
/*     */       {
/*     */         public Configuration run()
/*     */         {
/*  52 */           return new PropertyConfiguration(System.getProperties());
/*     */         }
/*     */       });
/*  55 */       PropertyEditors.init();
/*     */     }
/*     */   }
/*     */ 
/*     */   static BeanInfo getBeanInfo(Object object)
/*     */     throws Throwable
/*     */   {
/*  63 */     return getBeanInfo(object.getClass());
/*     */   }
/*     */ 
/*     */   static BeanInfo getBeanInfo(Class clazz) throws Throwable
/*     */   {
/*  68 */     return config.getBeanInfo(clazz);
/*     */   }
/*     */ 
/*     */   static BeanInfo getBeanInfo(String className) throws Throwable
/*     */   {
/*  73 */     return config.getBeanInfo(className, Thread.currentThread().getContextClassLoader());
/*     */   }
/*     */ 
/*     */   static PropertyInfo getPropertyInfo(Object parent, String name) throws Throwable
/*     */   {
/*  78 */     BeanInfo beanInfo = getBeanInfo(parent);
/*  79 */     return beanInfo.getProperty(name);
/*     */   }
/*     */ 
/*     */   static Object newInstance(String className, String[] params, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  85 */     BeanInfo info = getBeanInfo(className);
/*  86 */     return info.newInstance(params, args);
/*     */   }
/*     */ 
/*     */   static Object convertValue(Object parent, String name, String override, Object value)
/*     */     throws Throwable
/*     */   {
/* 101 */     if (parent == null) {
/* 102 */       throw new IllegalArgumentException("Null parent!");
/*     */     }
/* 104 */     PropertyInfo property = getPropertyInfo(parent, name);
/* 105 */     return convertValue(property, override, value);
/*     */   }
/*     */ 
/*     */   static Object convertValue(PropertyInfo property, String override, Object value)
/*     */     throws Throwable
/*     */   {
/* 111 */     if (property == null) {
/* 112 */       throw new IllegalArgumentException("Null property!");
/*     */     }
/* 114 */     TypeInfo type = property.getType();
/* 115 */     if (override != null) {
/* 116 */       type = config.getTypeInfoFactory().getTypeInfo(override, null);
/*     */     }
/* 118 */     return type != null ? type.convertValue(value) : value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.javabean.plugins.xml.ConfigurationUtil
 * JD-Core Version:    0.6.0
 */