/*     */ package org.jboss.javabean.plugins.xml;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ 
/*     */ public class Common
/*     */ {
/*     */   public static class Property extends Common.Holder
/*     */   {
/*     */     private String property;
/*     */     private String type;
/*     */ 
/*     */     public String getProperty()
/*     */     {
/* 160 */       return this.property;
/*     */     }
/*     */ 
/*     */     public void setProperty(String property)
/*     */     {
/* 165 */       this.property = property;
/*     */     }
/*     */ 
/*     */     public String getType()
/*     */     {
/* 170 */       return this.type;
/*     */     }
/*     */ 
/*     */     public void setType(String type)
/*     */     {
/* 175 */       this.type = type;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Constructor
/*     */   {
/*     */     private String factoryClass;
/*     */     private String factoryMethod;
/*     */ 
/*     */     public String getFactoryClass()
/*     */     {
/* 129 */       return this.factoryClass;
/*     */     }
/*     */ 
/*     */     public void setFactoryClass(String value)
/*     */     {
/* 134 */       this.factoryClass = value;
/*     */     }
/*     */ 
/*     */     public String getFactoryMethod()
/*     */     {
/* 139 */       return this.factoryMethod;
/*     */     }
/*     */ 
/*     */     public void setFactoryMethod(String value)
/*     */     {
/* 144 */       this.factoryMethod = value;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Ctor extends Common.Holder
/*     */   {
/*     */     private String className;
/*     */     private boolean ctorWasDeclared;
/*  60 */     private Common.Constructor constructor = new Common.Constructor();
/*  61 */     private List<String> paramTypes = new ArrayList();
/*  62 */     private List<Object> argValues = new ArrayList();
/*     */ 
/*     */     public Ctor(String className)
/*     */     {
/*  66 */       this.className = className;
/*     */     }
/*     */ 
/*     */     public boolean isCtorWasDeclared()
/*     */     {
/*  71 */       return this.ctorWasDeclared;
/*     */     }
/*     */ 
/*     */     public void setCtorWasDeclared(boolean ctorWasDeclared)
/*     */     {
/*  76 */       this.ctorWasDeclared = ctorWasDeclared;
/*     */     }
/*     */ 
/*     */     public String getClassName()
/*     */     {
/*  81 */       return this.className;
/*     */     }
/*     */ 
/*     */     public void addParam(String type, Object value)
/*     */     {
/*  86 */       this.paramTypes.add(type);
/*  87 */       this.argValues.add(value);
/*     */     }
/*     */ 
/*     */     public String[] getParamTypes()
/*     */     {
/*  92 */       String[] types = new String[this.paramTypes.size()];
/*  93 */       this.paramTypes.toArray(types);
/*  94 */       return types;
/*     */     }
/*     */ 
/*     */     public Object[] getArgs()
/*     */     {
/*  99 */       Object[] args = new Object[this.argValues.size()];
/* 100 */       this.argValues.toArray(args);
/* 101 */       return args;
/*     */     }
/*     */ 
/*     */     public Common.Constructor getConstructor()
/*     */     {
/* 106 */       return this.constructor;
/*     */     }
/*     */ 
/*     */     public Object newInstance()
/*     */       throws Throwable
/*     */     {
/* 112 */       String factoryMethod = this.constructor.getFactoryMethod();
/* 113 */       if (factoryMethod != null)
/*     */       {
/* 115 */         BeanInfo beanInfo = ConfigurationUtil.getBeanInfo(this.constructor.getFactoryClass());
/* 116 */         return beanInfo.invokeStatic(factoryMethod, getParamTypes(), getArgs());
/*     */       }
/* 118 */       return ConfigurationUtil.newInstance(getClassName(), getParamTypes(), getArgs());
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Holder
/*     */   {
/*     */     private Object object;
/*     */ 
/*     */     public Object getValue()
/*     */     {
/*  47 */       return this.object;
/*     */     }
/*     */ 
/*     */     public void setValue(Object object)
/*     */     {
/*  52 */       this.object = object;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.javabean.plugins.xml.Common
 * JD-Core Version:    0.6.0
 */