/*     */ package org.jboss.invocation.unified.server;
/*     */ 
/*     */ import java.rmi.MarshalledObject;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.unified.interfaces.UnifiedInvokerProxy;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.JMXExceptionDecoder;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.ConnectorMBean;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class UnifiedInvoker extends ServiceMBeanSupport
/*     */   implements ServerInvocationHandler, UnifiedInvokerMBean
/*     */ {
/*     */   private ConnectorMBean connector;
/*     */   private ServerInvoker serverInvoker;
/*     */   private MBeanServer mbServer;
/*  53 */   private boolean strictRMIException = false;
/*     */   private UnifiedInvokerProxy proxy;
/*  57 */   private String subsystem = "invoker";
/*     */ 
/*     */   public void setStrictRMIException(boolean isStrict)
/*     */   {
/*  69 */     this.strictRMIException = isStrict;
/*     */   }
/*     */ 
/*     */   public boolean getStrictRMIException()
/*     */   {
/*  82 */     return this.strictRMIException;
/*     */   }
/*     */ 
/*     */   public String getSubSystem()
/*     */   {
/*  91 */     return this.subsystem;
/*     */   }
/*     */ 
/*     */   public void setSubSystem(String subsystem)
/*     */   {
/*  96 */     this.subsystem = subsystem;
/*     */   }
/*     */ 
/*     */   public void setConnector(ConnectorMBean connector)
/*     */   {
/* 106 */     this.connector = connector;
/*     */   }
/*     */ 
/*     */   protected void createService() throws Exception
/*     */   {
/* 111 */     if (this.connector != null)
/*     */     {
/*     */       try
/*     */       {
/* 115 */         this.connector.addInvocationHandler(getSubSystem(), this);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 119 */         this.log.error("Error adding unified invoker as handler upon connector being set.", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 132 */     this.log.debug("Starting unified invoker service.");
/*     */ 
/* 134 */     InvokerLocator locator = null;
/* 135 */     if (this.serverInvoker != null)
/*     */     {
/* 137 */       locator = this.serverInvoker.getLocator();
/* 138 */       if (!this.serverInvoker.isStarted())
/*     */       {
/* 140 */         this.serverInvoker.start();
/*     */       }
/*     */     }
/* 143 */     else if (this.connector != null)
/*     */     {
/* 145 */       locator = this.connector.getLocator();
/*     */     }
/*     */     else
/*     */     {
/* 155 */       this.log.error("Error referencing either remoting connector or server invoker to be used.  Please check configuration to make sure proper dependancies are set.");
/*     */ 
/* 157 */       throw new RuntimeException("Error getting locator because server invoker is null.");
/*     */     }
/*     */ 
/* 160 */     this.proxy = new UnifiedInvokerProxy(locator, this.strictRMIException);
/*     */ 
/* 162 */     jmxBind();
/*     */   }
/*     */ 
/*     */   protected void jmxBind()
/*     */   {
/* 168 */     Registry.bind(getServiceName(), this.proxy);
/*     */   }
/*     */ 
/*     */   public void stopService()
/*     */     throws Exception
/*     */   {
/* 178 */     if (this.serverInvoker != null)
/*     */     {
/* 180 */       this.serverInvoker.stop();
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 191 */     return "Unified-Invoker";
/*     */   }
/*     */ 
/*     */   public String getInvokerLocator()
/*     */   {
/* 201 */     if (this.serverInvoker != null)
/*     */     {
/* 203 */       return this.serverInvoker.getLocator().getLocatorURI();
/*     */     }
/*     */ 
/* 207 */     return null;
/*     */   }
/*     */ 
/*     */   public Object invoke(InvocationRequest invocationReq)
/*     */     throws Throwable
/*     */   {
/* 221 */     Invocation invocation = (Invocation)invocationReq.getParameter();
/* 222 */     Thread currentThread = Thread.currentThread();
/* 223 */     ClassLoader oldCl = currentThread.getContextClassLoader();
/* 224 */     ObjectName mbean = null;
/*     */     try
/*     */     {
/* 227 */       mbean = (ObjectName)Registry.lookup(invocation.getObjectName());
/*     */ 
/* 230 */       Object obj = getServer().invoke(mbean, "invoke", new Object[] { invocation }, Invocation.INVOKE_SIGNATURE);
/*     */ 
/* 234 */       localMarshalledObject = new MarshalledObject(obj);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       MarshalledObject localMarshalledObject;
/* 238 */       Throwable th = JMXExceptionDecoder.decode(e);
/* 239 */       if (this.log.isTraceEnabled())
/*     */       {
/* 241 */         this.log.trace("Failed to invoke on mbean: " + mbean, th);
/*     */       }
/*     */ 
/* 244 */       if ((th instanceof Exception))
/*     */       {
/* 246 */         e = (Exception)th;
/*     */       }
/*     */ 
/* 249 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 253 */       currentThread.setContextClassLoader(oldCl);
/* 254 */       Thread.interrupted();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setMBeanServer(MBeanServer server)
/*     */   {
/* 266 */     this.mbServer = server;
/*     */   }
/*     */ 
/*     */   public MBeanServer getServer()
/*     */   {
/* 271 */     return this.mbServer;
/*     */   }
/*     */ 
/*     */   public void setInvoker(ServerInvoker invoker)
/*     */   {
/* 286 */     this.serverInvoker = invoker;
/*     */   }
/*     */ 
/*     */   protected ServerInvoker getInvoker()
/*     */   {
/* 291 */     return this.serverInvoker;
/*     */   }
/*     */ 
/*     */   public void addListener(InvokerCallbackHandler callbackHandler)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.unified.server.UnifiedInvoker
 * JD-Core Version:    0.6.0
 */