/*    */ package org.jboss.invocation.unified.marshall;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.util.Map;
/*    */ import org.jboss.invocation.MarshalledInvocation;
/*    */ import org.jboss.remoting.InvocationRequest;
/*    */ import org.jboss.remoting.marshal.UnMarshaller;
/*    */ import org.jboss.remoting.marshal.UnMarshallerDecorator;
/*    */ import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;
/*    */ import org.jboss.tm.TransactionPropagationContextImporter;
/*    */ import org.jboss.tm.TransactionPropagationContextUtil;
/*    */ 
/*    */ public class InvocationUnMarshaller extends SerializableUnMarshaller
/*    */   implements UnMarshallerDecorator
/*    */ {
/*    */   static final long serialVersionUID = -7323800106085276090L;
/*    */   public static final String DATATYPE = "invocation";
/*    */ 
/*    */   public Object read(InputStream inputStream, Map metadata)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 51 */     Object ret = super.read(inputStream, metadata);
/*    */ 
/* 54 */     return removeDecoration(ret);
/*    */   }
/*    */ 
/*    */   public Object read(InputStream inputStream, Map metadata, int version) throws IOException, ClassNotFoundException
/*    */   {
/* 59 */     Object ret = super.read(inputStream, metadata, version);
/*    */ 
/* 62 */     return removeDecoration(ret);
/*    */   }
/*    */ 
/*    */   public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException
/*    */   {
/* 67 */     InvocationUnMarshaller unmarshaller = new InvocationUnMarshaller();
/* 68 */     unmarshaller.setClassLoader(this.customClassLoader);
/* 69 */     return unmarshaller;
/*    */   }
/*    */ 
/*    */   public Object removeDecoration(Object obj) throws IOException
/*    */   {
/* 74 */     if ((obj instanceof InvocationRequest))
/*    */     {
/* 76 */       InvocationRequest remoteInv = (InvocationRequest)obj;
/* 77 */       Object param = remoteInv.getParameter();
/*    */ 
/* 79 */       if ((param instanceof MarshalledInvocation))
/*    */       {
/* 81 */         MarshalledInvocation mi = (MarshalledInvocation)param;
/* 82 */         Object txCxt = mi.getTransactionPropagationContext();
/* 83 */         if (txCxt != null)
/*    */         {
/* 85 */           TransactionPropagationContextImporter tpcImporter = TransactionPropagationContextUtil.getTPCImporter();
/* 86 */           mi.setTransaction(tpcImporter.importTransactionPropagationContext(txCxt));
/*    */         }
/*    */       }
/*    */     }
/* 90 */     return obj;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.unified.marshall.InvocationUnMarshaller
 * JD-Core Version:    0.6.0
 */